<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for New ServiceType
 */
$new = new \ServiceType\_New($options);
/**
 * Sample call for newOrder operation/method
 */
if ($new->newOrder($OriginatingSystemName, $MessageID, $TimeStamp, $Username, $Password, $OrderNumber, $EntryStatusCode, $RxNumber, $ProcessDateTime, $StoreCode, $OrderType, $DeliveryAddressLineOne, $DeliveryAddressLineTwo, $DeliveryAddressLineThree, $DeliveryAddressPostalCode, $MainMemberSurname, $MainMemberFirstname, $MainMemberInitials, $MainMemberTitle, $MainMemberDOB, $MainMemberMedicalAid, $MainMemberMedicalAidNo, $MainMemberIDNumber, $MainMemberGender, $MainMemberLanguage, $MainMemberHomeTelNo, $MainMemberBusinessTelNo, $MainMemberCellNo, $MainMemberEmail, $MainMemberFax, $MainMemberAddressLineOne, $MainMemberAddressLineTwo, $MainMemberAddressLineThree, $MainMemberAreaCode, $MainMemberPostalLineOne, $MainMemberPostalLineTwo, $MainMemberPostalLineThree, $MainMemberPostalCode, $MainMemberDocName, $MainMemberDocNamePracticeNumber, $MainMemberDocContactNumber, $MainMemberLoyaltyCardNumber, $DependantNo, $DependantRelation, $DependantSurname, $DependantFirstname, $DependantInitials, $DependantTitle, $DependantDOB, $DependantIDNumber, $DependantAddressLineOne, $DependantAddressLineTwo, $DependantAddressLineThree, $DependantAreaCode, $DependantPostalLineOne, $DependantPostalLineTwo, $DependantPostalLineThree, $DependantPostalCode, $DependantLanguage, $DependantHomeTelNo, $DependantBusinessTelNo, $DependantCellNo, $DependantEmail, $DependantFax, $DependantDocName, $DependantDocNamePracticeNumber, $DependantDocContactNumber, $DependantMedicalAid, $DependantMedicalAidNo, $DispensedPatient, $PaymentType, $Comments, $OriginalScriptImage, $Allergies, $Generics, $RepeatScript, $FridgeItemType, $SpecialInstructions) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
/**
 * Sample call for orderMedication operation/method
 */
if ($order->orderMedication(new \StructType\MedDetail(), new \StructType\MedLines()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateOrderStatus operation/method
 */
if ($update->updateOrderStatus($OriginatingSystemName, $MessageID, $TimeStamp, $Username, $Password, $OrderNumber, $OrderStatusCode) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
