<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for medDetail StructType
 * @subpackage Structs
 */
class MedDetail extends AbstractStructBase
{
    /**
     * The OriginatingSystemName
     * @var string
     */
    public $OriginatingSystemName;
    /**
     * The MessageID
     * @var string
     */
    public $MessageID;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Username
     * @var string
     */
    public $Username;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The OrderNumber
     * @var string
     */
    public $OrderNumber;
    /**
     * Constructor method for medDetail
     * @uses MedDetail::setOriginatingSystemName()
     * @uses MedDetail::setMessageID()
     * @uses MedDetail::setTimeStamp()
     * @uses MedDetail::setUsername()
     * @uses MedDetail::setPassword()
     * @uses MedDetail::setOrderNumber()
     * @param string $originatingSystemName
     * @param string $messageID
     * @param string $timeStamp
     * @param string $username
     * @param string $password
     * @param string $orderNumber
     */
    public function __construct($originatingSystemName = null, $messageID = null, $timeStamp = null, $username = null, $password = null, $orderNumber = null)
    {
        $this
            ->setOriginatingSystemName($originatingSystemName)
            ->setMessageID($messageID)
            ->setTimeStamp($timeStamp)
            ->setUsername($username)
            ->setPassword($password)
            ->setOrderNumber($orderNumber);
    }
    /**
     * Get OriginatingSystemName value
     * @return string|null
     */
    public function getOriginatingSystemName()
    {
        return $this->OriginatingSystemName;
    }
    /**
     * Set OriginatingSystemName value
     * @param string $originatingSystemName
     * @return \StructType\MedDetail
     */
    public function setOriginatingSystemName($originatingSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($originatingSystemName) && !is_string($originatingSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatingSystemName, true), gettype($originatingSystemName)), __LINE__);
        }
        $this->OriginatingSystemName = $originatingSystemName;
        return $this;
    }
    /**
     * Get MessageID value
     * @return string|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param string $messageID
     * @return \StructType\MedDetail
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: string
        if (!is_null($messageID) && !is_string($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageID, true), gettype($messageID)), __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\MedDetail
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\MedDetail
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\MedDetail
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\MedDetail
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
}
