<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $originatingSystemName
     * @param string $messageID
     * @param string $timeStamp
     * @param string $username
     * @param string $password
     * @param string $orderNumber
     * @param string $orderStatusCode
     * @return array|bool
     */
    public function updateOrderStatus($originatingSystemName, $messageID, $timeStamp, $username, $password, $orderNumber, $orderStatusCode)
    {
        try {
            $this->setResult($this->getSoapClient()->updateOrderStatus($originatingSystemName, $messageID, $timeStamp, $username, $password, $orderNumber, $orderStatusCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
