<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for medLines StructType
 * @subpackage Structs
 */
class MedLines extends AbstractStructBase
{
    /**
     * The ItemLineNo
     * @var string
     */
    public $ItemLineNo;
    /**
     * The DrugName
     * @var string
     */
    public $DrugName;
    /**
     * The NappiCode
     * @var string
     */
    public $NappiCode;
    /**
     * The Dosage
     * @var string
     */
    public $Dosage;
    /**
     * The Strength
     * @var string
     */
    public $Strength;
    /**
     * The DispenseQTY
     * @var string
     */
    public $DispenseQTY;
    /**
     * The RepeatNumber
     * @var string
     */
    public $RepeatNumber;
    /**
     * The DaysSupply
     * @var string
     */
    public $DaysSupply;
    /**
     * The PrimICD10Code
     * @var string
     */
    public $PrimICD10Code;
    /**
     * The SecoICD10Code
     * @var string
     */
    public $SecoICD10Code;
    /**
     * The DirectionsLine1
     * @var string
     */
    public $DirectionsLine1;
    /**
     * The DirectionsLine2
     * @var string
     */
    public $DirectionsLine2;
    /**
     * Constructor method for medLines
     * @uses MedLines::setItemLineNo()
     * @uses MedLines::setDrugName()
     * @uses MedLines::setNappiCode()
     * @uses MedLines::setDosage()
     * @uses MedLines::setStrength()
     * @uses MedLines::setDispenseQTY()
     * @uses MedLines::setRepeatNumber()
     * @uses MedLines::setDaysSupply()
     * @uses MedLines::setPrimICD10Code()
     * @uses MedLines::setSecoICD10Code()
     * @uses MedLines::setDirectionsLine1()
     * @uses MedLines::setDirectionsLine2()
     * @param string $itemLineNo
     * @param string $drugName
     * @param string $nappiCode
     * @param string $dosage
     * @param string $strength
     * @param string $dispenseQTY
     * @param string $repeatNumber
     * @param string $daysSupply
     * @param string $primICD10Code
     * @param string $secoICD10Code
     * @param string $directionsLine1
     * @param string $directionsLine2
     */
    public function __construct($itemLineNo = null, $drugName = null, $nappiCode = null, $dosage = null, $strength = null, $dispenseQTY = null, $repeatNumber = null, $daysSupply = null, $primICD10Code = null, $secoICD10Code = null, $directionsLine1 = null, $directionsLine2 = null)
    {
        $this
            ->setItemLineNo($itemLineNo)
            ->setDrugName($drugName)
            ->setNappiCode($nappiCode)
            ->setDosage($dosage)
            ->setStrength($strength)
            ->setDispenseQTY($dispenseQTY)
            ->setRepeatNumber($repeatNumber)
            ->setDaysSupply($daysSupply)
            ->setPrimICD10Code($primICD10Code)
            ->setSecoICD10Code($secoICD10Code)
            ->setDirectionsLine1($directionsLine1)
            ->setDirectionsLine2($directionsLine2);
    }
    /**
     * Get ItemLineNo value
     * @return string|null
     */
    public function getItemLineNo()
    {
        return $this->ItemLineNo;
    }
    /**
     * Set ItemLineNo value
     * @param string $itemLineNo
     * @return \StructType\MedLines
     */
    public function setItemLineNo($itemLineNo = null)
    {
        // validation for constraint: string
        if (!is_null($itemLineNo) && !is_string($itemLineNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemLineNo, true), gettype($itemLineNo)), __LINE__);
        }
        $this->ItemLineNo = $itemLineNo;
        return $this;
    }
    /**
     * Get DrugName value
     * @return string|null
     */
    public function getDrugName()
    {
        return $this->DrugName;
    }
    /**
     * Set DrugName value
     * @param string $drugName
     * @return \StructType\MedLines
     */
    public function setDrugName($drugName = null)
    {
        // validation for constraint: string
        if (!is_null($drugName) && !is_string($drugName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drugName, true), gettype($drugName)), __LINE__);
        }
        $this->DrugName = $drugName;
        return $this;
    }
    /**
     * Get NappiCode value
     * @return string|null
     */
    public function getNappiCode()
    {
        return $this->NappiCode;
    }
    /**
     * Set NappiCode value
     * @param string $nappiCode
     * @return \StructType\MedLines
     */
    public function setNappiCode($nappiCode = null)
    {
        // validation for constraint: string
        if (!is_null($nappiCode) && !is_string($nappiCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nappiCode, true), gettype($nappiCode)), __LINE__);
        }
        $this->NappiCode = $nappiCode;
        return $this;
    }
    /**
     * Get Dosage value
     * @return string|null
     */
    public function getDosage()
    {
        return $this->Dosage;
    }
    /**
     * Set Dosage value
     * @param string $dosage
     * @return \StructType\MedLines
     */
    public function setDosage($dosage = null)
    {
        // validation for constraint: string
        if (!is_null($dosage) && !is_string($dosage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosage, true), gettype($dosage)), __LINE__);
        }
        $this->Dosage = $dosage;
        return $this;
    }
    /**
     * Get Strength value
     * @return string|null
     */
    public function getStrength()
    {
        return $this->Strength;
    }
    /**
     * Set Strength value
     * @param string $strength
     * @return \StructType\MedLines
     */
    public function setStrength($strength = null)
    {
        // validation for constraint: string
        if (!is_null($strength) && !is_string($strength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strength, true), gettype($strength)), __LINE__);
        }
        $this->Strength = $strength;
        return $this;
    }
    /**
     * Get DispenseQTY value
     * @return string|null
     */
    public function getDispenseQTY()
    {
        return $this->DispenseQTY;
    }
    /**
     * Set DispenseQTY value
     * @param string $dispenseQTY
     * @return \StructType\MedLines
     */
    public function setDispenseQTY($dispenseQTY = null)
    {
        // validation for constraint: string
        if (!is_null($dispenseQTY) && !is_string($dispenseQTY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispenseQTY, true), gettype($dispenseQTY)), __LINE__);
        }
        $this->DispenseQTY = $dispenseQTY;
        return $this;
    }
    /**
     * Get RepeatNumber value
     * @return string|null
     */
    public function getRepeatNumber()
    {
        return $this->RepeatNumber;
    }
    /**
     * Set RepeatNumber value
     * @param string $repeatNumber
     * @return \StructType\MedLines
     */
    public function setRepeatNumber($repeatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($repeatNumber) && !is_string($repeatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repeatNumber, true), gettype($repeatNumber)), __LINE__);
        }
        $this->RepeatNumber = $repeatNumber;
        return $this;
    }
    /**
     * Get DaysSupply value
     * @return string|null
     */
    public function getDaysSupply()
    {
        return $this->DaysSupply;
    }
    /**
     * Set DaysSupply value
     * @param string $daysSupply
     * @return \StructType\MedLines
     */
    public function setDaysSupply($daysSupply = null)
    {
        // validation for constraint: string
        if (!is_null($daysSupply) && !is_string($daysSupply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysSupply, true), gettype($daysSupply)), __LINE__);
        }
        $this->DaysSupply = $daysSupply;
        return $this;
    }
    /**
     * Get PrimICD10Code value
     * @return string|null
     */
    public function getPrimICD10Code()
    {
        return $this->PrimICD10Code;
    }
    /**
     * Set PrimICD10Code value
     * @param string $primICD10Code
     * @return \StructType\MedLines
     */
    public function setPrimICD10Code($primICD10Code = null)
    {
        // validation for constraint: string
        if (!is_null($primICD10Code) && !is_string($primICD10Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primICD10Code, true), gettype($primICD10Code)), __LINE__);
        }
        $this->PrimICD10Code = $primICD10Code;
        return $this;
    }
    /**
     * Get SecoICD10Code value
     * @return string|null
     */
    public function getSecoICD10Code()
    {
        return $this->SecoICD10Code;
    }
    /**
     * Set SecoICD10Code value
     * @param string $secoICD10Code
     * @return \StructType\MedLines
     */
    public function setSecoICD10Code($secoICD10Code = null)
    {
        // validation for constraint: string
        if (!is_null($secoICD10Code) && !is_string($secoICD10Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secoICD10Code, true), gettype($secoICD10Code)), __LINE__);
        }
        $this->SecoICD10Code = $secoICD10Code;
        return $this;
    }
    /**
     * Get DirectionsLine1 value
     * @return string|null
     */
    public function getDirectionsLine1()
    {
        return $this->DirectionsLine1;
    }
    /**
     * Set DirectionsLine1 value
     * @param string $directionsLine1
     * @return \StructType\MedLines
     */
    public function setDirectionsLine1($directionsLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($directionsLine1) && !is_string($directionsLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directionsLine1, true), gettype($directionsLine1)), __LINE__);
        }
        $this->DirectionsLine1 = $directionsLine1;
        return $this;
    }
    /**
     * Get DirectionsLine2 value
     * @return string|null
     */
    public function getDirectionsLine2()
    {
        return $this->DirectionsLine2;
    }
    /**
     * Set DirectionsLine2 value
     * @param string $directionsLine2
     * @return \StructType\MedLines
     */
    public function setDirectionsLine2($directionsLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($directionsLine2) && !is_string($directionsLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directionsLine2, true), gettype($directionsLine2)), __LINE__);
        }
        $this->DirectionsLine2 = $directionsLine2;
        return $this;
    }
}
