<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UOMConversions StructType
 * @subpackage Structs
 */
class UOMConversions extends AbstractStructBase
{
    /**
     * The InventoryItemUOMConversion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InventoryItemUOMConversion[]
     */
    public $InventoryItemUOMConversion;
    /**
     * Constructor method for UOMConversions
     * @uses UOMConversions::setInventoryItemUOMConversion()
     * @param \StructType\InventoryItemUOMConversion[] $inventoryItemUOMConversion
     */
    public function __construct(array $inventoryItemUOMConversion = array())
    {
        $this
            ->setInventoryItemUOMConversion($inventoryItemUOMConversion);
    }
    /**
     * Get InventoryItemUOMConversion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InventoryItemUOMConversion[]|null
     */
    public function getInventoryItemUOMConversion()
    {
        return isset($this->InventoryItemUOMConversion) ? $this->InventoryItemUOMConversion : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryItemUOMConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryItemUOMConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryItemUOMConversionForArrayConstraintsFromSetInventoryItemUOMConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uOMConversionsInventoryItemUOMConversionItem) {
            // validation for constraint: itemType
            if (!$uOMConversionsInventoryItemUOMConversionItem instanceof \StructType\InventoryItemUOMConversion) {
                $invalidValues[] = is_object($uOMConversionsInventoryItemUOMConversionItem) ? get_class($uOMConversionsInventoryItemUOMConversionItem) : sprintf('%s(%s)', gettype($uOMConversionsInventoryItemUOMConversionItem), var_export($uOMConversionsInventoryItemUOMConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventoryItemUOMConversion property can only contain items of type \StructType\InventoryItemUOMConversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventoryItemUOMConversion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemUOMConversion[] $inventoryItemUOMConversion
     * @return \StructType\UOMConversions
     */
    public function setInventoryItemUOMConversion(array $inventoryItemUOMConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryItemUOMConversionArrayErrorMessage = self::validateInventoryItemUOMConversionForArrayConstraintsFromSetInventoryItemUOMConversion($inventoryItemUOMConversion))) {
            throw new \InvalidArgumentException($inventoryItemUOMConversionArrayErrorMessage, __LINE__);
        }
        if (is_null($inventoryItemUOMConversion) || (is_array($inventoryItemUOMConversion) && empty($inventoryItemUOMConversion))) {
            unset($this->InventoryItemUOMConversion);
        } else {
            $this->InventoryItemUOMConversion = $inventoryItemUOMConversion;
        }
        return $this;
    }
    /**
     * Add item to InventoryItemUOMConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemUOMConversion $item
     * @return \StructType\UOMConversions
     */
    public function addToInventoryItemUOMConversion(\StructType\InventoryItemUOMConversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryItemUOMConversion) {
            throw new \InvalidArgumentException(sprintf('The InventoryItemUOMConversion property can only contain items of type \StructType\InventoryItemUOMConversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventoryItemUOMConversion[] = $item;
        return $this;
    }
}
