<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeAndMaterial StructType
 * @subpackage Structs
 */
class TimeAndMaterial extends Entity
{
    /**
     * The AmountToInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AmountToInvoice;
    /**
     * The BilledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BilledAmount;
    /**
     * The BilledQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BilledQty;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The DeferralCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DeferralCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EmployeeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EmployeeID;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The MaxAvailableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxAvailableAmount;
    /**
     * The MaxLimitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxLimitAmount;
    /**
     * The OverLimitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OverLimitAmount;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The QtyToInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $QtyToInvoice;
    /**
     * The Retainage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Retainage;
    /**
     * The RetainageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RetainageAmount;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Vendor;
    /**
     * The TimeAndMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TimeAndMaterial[]
     */
    public $TimeAndMaterial;
    /**
     * Constructor method for TimeAndMaterial
     * @uses TimeAndMaterial::setAmountToInvoice()
     * @uses TimeAndMaterial::setBilledAmount()
     * @uses TimeAndMaterial::setBilledQty()
     * @uses TimeAndMaterial::setBranch()
     * @uses TimeAndMaterial::setCostCode()
     * @uses TimeAndMaterial::setDate()
     * @uses TimeAndMaterial::setDeferralCode()
     * @uses TimeAndMaterial::setDescription()
     * @uses TimeAndMaterial::setEmployeeID()
     * @uses TimeAndMaterial::setInventoryID()
     * @uses TimeAndMaterial::setMaxAvailableAmount()
     * @uses TimeAndMaterial::setMaxLimitAmount()
     * @uses TimeAndMaterial::setOverLimitAmount()
     * @uses TimeAndMaterial::setProjectTaskID()
     * @uses TimeAndMaterial::setQtyToInvoice()
     * @uses TimeAndMaterial::setRetainage()
     * @uses TimeAndMaterial::setRetainageAmount()
     * @uses TimeAndMaterial::setSalesAccount()
     * @uses TimeAndMaterial::setSalesSubaccount()
     * @uses TimeAndMaterial::setStatus()
     * @uses TimeAndMaterial::setTaxCategory()
     * @uses TimeAndMaterial::setUnitPrice()
     * @uses TimeAndMaterial::setUOM()
     * @uses TimeAndMaterial::setVendor()
     * @uses TimeAndMaterial::setTimeAndMaterial()
     * @param \StructType\DecimalValue $amountToInvoice
     * @param \StructType\DecimalValue $billedAmount
     * @param \StructType\DecimalValue $billedQty
     * @param \StructType\StringValue $branch
     * @param \StructType\StringValue $costCode
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $deferralCode
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $employeeID
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\DecimalValue $maxAvailableAmount
     * @param \StructType\DecimalValue $maxLimitAmount
     * @param \StructType\DecimalValue $overLimitAmount
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\DecimalValue $qtyToInvoice
     * @param \StructType\DecimalValue $retainage
     * @param \StructType\DecimalValue $retainageAmount
     * @param \StructType\StringValue $salesAccount
     * @param \StructType\StringValue $salesSubaccount
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\DecimalValue $unitPrice
     * @param \StructType\StringValue $uOM
     * @param \StructType\StringValue $vendor
     * @param \StructType\TimeAndMaterial[] $timeAndMaterial
     */
    public function __construct(\StructType\DecimalValue $amountToInvoice = null, \StructType\DecimalValue $billedAmount = null, \StructType\DecimalValue $billedQty = null, \StructType\StringValue $branch = null, \StructType\StringValue $costCode = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $deferralCode = null, \StructType\StringValue $description = null, \StructType\StringValue $employeeID = null, \StructType\StringValue $inventoryID = null, \StructType\DecimalValue $maxAvailableAmount = null, \StructType\DecimalValue $maxLimitAmount = null, \StructType\DecimalValue $overLimitAmount = null, \StructType\StringValue $projectTaskID = null, \StructType\DecimalValue $qtyToInvoice = null, \StructType\DecimalValue $retainage = null, \StructType\DecimalValue $retainageAmount = null, \StructType\StringValue $salesAccount = null, \StructType\StringValue $salesSubaccount = null, \StructType\StringValue $status = null, \StructType\StringValue $taxCategory = null, \StructType\DecimalValue $unitPrice = null, \StructType\StringValue $uOM = null, \StructType\StringValue $vendor = null, array $timeAndMaterial = array())
    {
        $this
            ->setAmountToInvoice($amountToInvoice)
            ->setBilledAmount($billedAmount)
            ->setBilledQty($billedQty)
            ->setBranch($branch)
            ->setCostCode($costCode)
            ->setDate($date)
            ->setDeferralCode($deferralCode)
            ->setDescription($description)
            ->setEmployeeID($employeeID)
            ->setInventoryID($inventoryID)
            ->setMaxAvailableAmount($maxAvailableAmount)
            ->setMaxLimitAmount($maxLimitAmount)
            ->setOverLimitAmount($overLimitAmount)
            ->setProjectTaskID($projectTaskID)
            ->setQtyToInvoice($qtyToInvoice)
            ->setRetainage($retainage)
            ->setRetainageAmount($retainageAmount)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setStatus($status)
            ->setTaxCategory($taxCategory)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setVendor($vendor)
            ->setTimeAndMaterial($timeAndMaterial);
    }
    /**
     * Get AmountToInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmountToInvoice()
    {
        return isset($this->AmountToInvoice) ? $this->AmountToInvoice : null;
    }
    /**
     * Set AmountToInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amountToInvoice
     * @return \StructType\TimeAndMaterial
     */
    public function setAmountToInvoice(\StructType\DecimalValue $amountToInvoice = null)
    {
        if (is_null($amountToInvoice) || (is_array($amountToInvoice) && empty($amountToInvoice))) {
            unset($this->AmountToInvoice);
        } else {
            $this->AmountToInvoice = $amountToInvoice;
        }
        return $this;
    }
    /**
     * Get BilledAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBilledAmount()
    {
        return isset($this->BilledAmount) ? $this->BilledAmount : null;
    }
    /**
     * Set BilledAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $billedAmount
     * @return \StructType\TimeAndMaterial
     */
    public function setBilledAmount(\StructType\DecimalValue $billedAmount = null)
    {
        if (is_null($billedAmount) || (is_array($billedAmount) && empty($billedAmount))) {
            unset($this->BilledAmount);
        } else {
            $this->BilledAmount = $billedAmount;
        }
        return $this;
    }
    /**
     * Get BilledQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBilledQty()
    {
        return isset($this->BilledQty) ? $this->BilledQty : null;
    }
    /**
     * Set BilledQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $billedQty
     * @return \StructType\TimeAndMaterial
     */
    public function setBilledQty(\StructType\DecimalValue $billedQty = null)
    {
        if (is_null($billedQty) || (is_array($billedQty) && empty($billedQty))) {
            unset($this->BilledQty);
        } else {
            $this->BilledQty = $billedQty;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\TimeAndMaterial
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\TimeAndMaterial
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\TimeAndMaterial
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get DeferralCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDeferralCode()
    {
        return isset($this->DeferralCode) ? $this->DeferralCode : null;
    }
    /**
     * Set DeferralCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $deferralCode
     * @return \StructType\TimeAndMaterial
     */
    public function setDeferralCode(\StructType\StringValue $deferralCode = null)
    {
        if (is_null($deferralCode) || (is_array($deferralCode) && empty($deferralCode))) {
            unset($this->DeferralCode);
        } else {
            $this->DeferralCode = $deferralCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\TimeAndMaterial
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EmployeeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployeeID()
    {
        return isset($this->EmployeeID) ? $this->EmployeeID : null;
    }
    /**
     * Set EmployeeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employeeID
     * @return \StructType\TimeAndMaterial
     */
    public function setEmployeeID(\StructType\StringValue $employeeID = null)
    {
        if (is_null($employeeID) || (is_array($employeeID) && empty($employeeID))) {
            unset($this->EmployeeID);
        } else {
            $this->EmployeeID = $employeeID;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\TimeAndMaterial
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get MaxAvailableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxAvailableAmount()
    {
        return isset($this->MaxAvailableAmount) ? $this->MaxAvailableAmount : null;
    }
    /**
     * Set MaxAvailableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxAvailableAmount
     * @return \StructType\TimeAndMaterial
     */
    public function setMaxAvailableAmount(\StructType\DecimalValue $maxAvailableAmount = null)
    {
        if (is_null($maxAvailableAmount) || (is_array($maxAvailableAmount) && empty($maxAvailableAmount))) {
            unset($this->MaxAvailableAmount);
        } else {
            $this->MaxAvailableAmount = $maxAvailableAmount;
        }
        return $this;
    }
    /**
     * Get MaxLimitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxLimitAmount()
    {
        return isset($this->MaxLimitAmount) ? $this->MaxLimitAmount : null;
    }
    /**
     * Set MaxLimitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxLimitAmount
     * @return \StructType\TimeAndMaterial
     */
    public function setMaxLimitAmount(\StructType\DecimalValue $maxLimitAmount = null)
    {
        if (is_null($maxLimitAmount) || (is_array($maxLimitAmount) && empty($maxLimitAmount))) {
            unset($this->MaxLimitAmount);
        } else {
            $this->MaxLimitAmount = $maxLimitAmount;
        }
        return $this;
    }
    /**
     * Get OverLimitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOverLimitAmount()
    {
        return isset($this->OverLimitAmount) ? $this->OverLimitAmount : null;
    }
    /**
     * Set OverLimitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $overLimitAmount
     * @return \StructType\TimeAndMaterial
     */
    public function setOverLimitAmount(\StructType\DecimalValue $overLimitAmount = null)
    {
        if (is_null($overLimitAmount) || (is_array($overLimitAmount) && empty($overLimitAmount))) {
            unset($this->OverLimitAmount);
        } else {
            $this->OverLimitAmount = $overLimitAmount;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\TimeAndMaterial
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get QtyToInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQtyToInvoice()
    {
        return isset($this->QtyToInvoice) ? $this->QtyToInvoice : null;
    }
    /**
     * Set QtyToInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qtyToInvoice
     * @return \StructType\TimeAndMaterial
     */
    public function setQtyToInvoice(\StructType\DecimalValue $qtyToInvoice = null)
    {
        if (is_null($qtyToInvoice) || (is_array($qtyToInvoice) && empty($qtyToInvoice))) {
            unset($this->QtyToInvoice);
        } else {
            $this->QtyToInvoice = $qtyToInvoice;
        }
        return $this;
    }
    /**
     * Get Retainage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRetainage()
    {
        return isset($this->Retainage) ? $this->Retainage : null;
    }
    /**
     * Set Retainage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $retainage
     * @return \StructType\TimeAndMaterial
     */
    public function setRetainage(\StructType\DecimalValue $retainage = null)
    {
        if (is_null($retainage) || (is_array($retainage) && empty($retainage))) {
            unset($this->Retainage);
        } else {
            $this->Retainage = $retainage;
        }
        return $this;
    }
    /**
     * Get RetainageAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRetainageAmount()
    {
        return isset($this->RetainageAmount) ? $this->RetainageAmount : null;
    }
    /**
     * Set RetainageAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $retainageAmount
     * @return \StructType\TimeAndMaterial
     */
    public function setRetainageAmount(\StructType\DecimalValue $retainageAmount = null)
    {
        if (is_null($retainageAmount) || (is_array($retainageAmount) && empty($retainageAmount))) {
            unset($this->RetainageAmount);
        } else {
            $this->RetainageAmount = $retainageAmount;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesAccount
     * @return \StructType\TimeAndMaterial
     */
    public function setSalesAccount(\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesSubaccount
     * @return \StructType\TimeAndMaterial
     */
    public function setSalesSubaccount(\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\TimeAndMaterial
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\TimeAndMaterial
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitPrice
     * @return \StructType\TimeAndMaterial
     */
    public function setUnitPrice(\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\TimeAndMaterial
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendor
     * @return \StructType\TimeAndMaterial
     */
    public function setVendor(\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Get TimeAndMaterial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TimeAndMaterial[]|null
     */
    public function getTimeAndMaterial()
    {
        return isset($this->TimeAndMaterial) ? $this->TimeAndMaterial : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTimeAndMaterial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimeAndMaterial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeAndMaterialForArrayConstraintsFromSetTimeAndMaterial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeAndMaterialTimeAndMaterialItem) {
            // validation for constraint: itemType
            if (!$timeAndMaterialTimeAndMaterialItem instanceof \StructType\TimeAndMaterial) {
                $invalidValues[] = is_object($timeAndMaterialTimeAndMaterialItem) ? get_class($timeAndMaterialTimeAndMaterialItem) : sprintf('%s(%s)', gettype($timeAndMaterialTimeAndMaterialItem), var_export($timeAndMaterialTimeAndMaterialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TimeAndMaterial property can only contain items of type \StructType\TimeAndMaterial, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TimeAndMaterial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TimeAndMaterial[] $timeAndMaterial
     * @return \StructType\TimeAndMaterial
     */
    public function setTimeAndMaterial(array $timeAndMaterial = array())
    {
        // validation for constraint: array
        if ('' !== ($timeAndMaterialArrayErrorMessage = self::validateTimeAndMaterialForArrayConstraintsFromSetTimeAndMaterial($timeAndMaterial))) {
            throw new \InvalidArgumentException($timeAndMaterialArrayErrorMessage, __LINE__);
        }
        if (is_null($timeAndMaterial) || (is_array($timeAndMaterial) && empty($timeAndMaterial))) {
            unset($this->TimeAndMaterial);
        } else {
            $this->TimeAndMaterial = $timeAndMaterial;
        }
        return $this;
    }
    /**
     * Add item to TimeAndMaterial value
     * @throws \InvalidArgumentException
     * @param \StructType\TimeAndMaterial $item
     * @return \StructType\TimeAndMaterial
     */
    public function addToTimeAndMaterial(\StructType\TimeAndMaterial $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimeAndMaterial) {
            throw new \InvalidArgumentException(sprintf('The TimeAndMaterial property can only contain items of type \StructType\TimeAndMaterial, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TimeAndMaterial[] = $item;
        return $this;
    }
}
