<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * @subpackage Structs
 */
class Shipment extends Entity
{
    /**
     * The BaseCurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BaseCurrencyID;
    /**
     * The ControlQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ControlQty;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrencyRate;
    /**
     * The CurrencyRateTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyRateTypeID;
    /**
     * The CurrencyViewState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CurrencyViewState;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The FOBPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The FreightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $FreightAmount;
    /**
     * The FreightCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $FreightCost;
    /**
     * The FreightCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FreightCurrency;
    /**
     * The GroundCollect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $GroundCollect;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Insurance;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Operation;
    /**
     * The Orders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Orders
     */
    public $Orders;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Owner;
    /**
     * The PackageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $PackageCount;
    /**
     * The Packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Packages
     */
    public $Packages;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PackageWeight;
    /**
     * The ReciprocalRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ReciprocalRate;
    /**
     * The ResidentialDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The SaturdayDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ShipmentDate;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The ShippedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippedQty;
    /**
     * The ShippedVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippedVolume;
    /**
     * The ShippedWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippedWeight;
    /**
     * The ShippingSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipToSettings
     */
    public $ShippingSettings;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingZoneID;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The ToWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ToWarehouseID;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The UseCustomersAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $UseCustomersAccount;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * The WorkgroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WorkgroupID;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setBaseCurrencyID()
     * @uses Shipment::setControlQty()
     * @uses Shipment::setCreatedDateTime()
     * @uses Shipment::setCurrencyID()
     * @uses Shipment::setCurrencyRate()
     * @uses Shipment::setCurrencyRateTypeID()
     * @uses Shipment::setCurrencyViewState()
     * @uses Shipment::setCustomerID()
     * @uses Shipment::setDetails()
     * @uses Shipment::setEffectiveDate()
     * @uses Shipment::setFOBPoint()
     * @uses Shipment::setFreightAmount()
     * @uses Shipment::setFreightCost()
     * @uses Shipment::setFreightCurrency()
     * @uses Shipment::setGroundCollect()
     * @uses Shipment::setHold()
     * @uses Shipment::setInsurance()
     * @uses Shipment::setLastModifiedDateTime()
     * @uses Shipment::setLocationID()
     * @uses Shipment::setOperation()
     * @uses Shipment::setOrders()
     * @uses Shipment::setOwner()
     * @uses Shipment::setPackageCount()
     * @uses Shipment::setPackages()
     * @uses Shipment::setPackageWeight()
     * @uses Shipment::setReciprocalRate()
     * @uses Shipment::setResidentialDelivery()
     * @uses Shipment::setSaturdayDelivery()
     * @uses Shipment::setShipmentDate()
     * @uses Shipment::setShipmentNbr()
     * @uses Shipment::setShippedQty()
     * @uses Shipment::setShippedVolume()
     * @uses Shipment::setShippedWeight()
     * @uses Shipment::setShippingSettings()
     * @uses Shipment::setShippingTerms()
     * @uses Shipment::setShippingZoneID()
     * @uses Shipment::setShipVia()
     * @uses Shipment::setStatus()
     * @uses Shipment::setToWarehouseID()
     * @uses Shipment::setType()
     * @uses Shipment::setUseCustomersAccount()
     * @uses Shipment::setWarehouseID()
     * @uses Shipment::setWorkgroupID()
     * @param \StructType\StringValue $baseCurrencyID
     * @param \StructType\DecimalValue $controlQty
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $currencyID
     * @param \StructType\DecimalValue $currencyRate
     * @param \StructType\StringValue $currencyRateTypeID
     * @param \StructType\BooleanValue $currencyViewState
     * @param \StructType\StringValue $customerID
     * @param \StructType\Details $details
     * @param \StructType\DateTimeValue $effectiveDate
     * @param \StructType\StringValue $fOBPoint
     * @param \StructType\DecimalValue $freightAmount
     * @param \StructType\DecimalValue $freightCost
     * @param \StructType\StringValue $freightCurrency
     * @param \StructType\BooleanValue $groundCollect
     * @param \StructType\BooleanValue $hold
     * @param \StructType\BooleanValue $insurance
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $locationID
     * @param \StructType\StringValue $operation
     * @param \StructType\Orders $orders
     * @param \StructType\StringValue $owner
     * @param \StructType\IntValue $packageCount
     * @param \StructType\Packages $packages
     * @param \StructType\DecimalValue $packageWeight
     * @param \StructType\DecimalValue $reciprocalRate
     * @param \StructType\BooleanValue $residentialDelivery
     * @param \StructType\BooleanValue $saturdayDelivery
     * @param \StructType\DateTimeValue $shipmentDate
     * @param \StructType\StringValue $shipmentNbr
     * @param \StructType\DecimalValue $shippedQty
     * @param \StructType\DecimalValue $shippedVolume
     * @param \StructType\DecimalValue $shippedWeight
     * @param \StructType\ShipToSettings $shippingSettings
     * @param \StructType\StringValue $shippingTerms
     * @param \StructType\StringValue $shippingZoneID
     * @param \StructType\StringValue $shipVia
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $toWarehouseID
     * @param \StructType\StringValue $type
     * @param \StructType\BooleanValue $useCustomersAccount
     * @param \StructType\StringValue $warehouseID
     * @param \StructType\StringValue $workgroupID
     */
    public function __construct(\StructType\StringValue $baseCurrencyID = null, \StructType\DecimalValue $controlQty = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $currencyID = null, \StructType\DecimalValue $currencyRate = null, \StructType\StringValue $currencyRateTypeID = null, \StructType\BooleanValue $currencyViewState = null, \StructType\StringValue $customerID = null, \StructType\Details $details = null, \StructType\DateTimeValue $effectiveDate = null, \StructType\StringValue $fOBPoint = null, \StructType\DecimalValue $freightAmount = null, \StructType\DecimalValue $freightCost = null, \StructType\StringValue $freightCurrency = null, \StructType\BooleanValue $groundCollect = null, \StructType\BooleanValue $hold = null, \StructType\BooleanValue $insurance = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $locationID = null, \StructType\StringValue $operation = null, \StructType\Orders $orders = null, \StructType\StringValue $owner = null, \StructType\IntValue $packageCount = null, \StructType\Packages $packages = null, \StructType\DecimalValue $packageWeight = null, \StructType\DecimalValue $reciprocalRate = null, \StructType\BooleanValue $residentialDelivery = null, \StructType\BooleanValue $saturdayDelivery = null, \StructType\DateTimeValue $shipmentDate = null, \StructType\StringValue $shipmentNbr = null, \StructType\DecimalValue $shippedQty = null, \StructType\DecimalValue $shippedVolume = null, \StructType\DecimalValue $shippedWeight = null, \StructType\ShipToSettings $shippingSettings = null, \StructType\StringValue $shippingTerms = null, \StructType\StringValue $shippingZoneID = null, \StructType\StringValue $shipVia = null, \StructType\StringValue $status = null, \StructType\StringValue $toWarehouseID = null, \StructType\StringValue $type = null, \StructType\BooleanValue $useCustomersAccount = null, \StructType\StringValue $warehouseID = null, \StructType\StringValue $workgroupID = null)
    {
        $this
            ->setBaseCurrencyID($baseCurrencyID)
            ->setControlQty($controlQty)
            ->setCreatedDateTime($createdDateTime)
            ->setCurrencyID($currencyID)
            ->setCurrencyRate($currencyRate)
            ->setCurrencyRateTypeID($currencyRateTypeID)
            ->setCurrencyViewState($currencyViewState)
            ->setCustomerID($customerID)
            ->setDetails($details)
            ->setEffectiveDate($effectiveDate)
            ->setFOBPoint($fOBPoint)
            ->setFreightAmount($freightAmount)
            ->setFreightCost($freightCost)
            ->setFreightCurrency($freightCurrency)
            ->setGroundCollect($groundCollect)
            ->setHold($hold)
            ->setInsurance($insurance)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLocationID($locationID)
            ->setOperation($operation)
            ->setOrders($orders)
            ->setOwner($owner)
            ->setPackageCount($packageCount)
            ->setPackages($packages)
            ->setPackageWeight($packageWeight)
            ->setReciprocalRate($reciprocalRate)
            ->setResidentialDelivery($residentialDelivery)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setShipmentDate($shipmentDate)
            ->setShipmentNbr($shipmentNbr)
            ->setShippedQty($shippedQty)
            ->setShippedVolume($shippedVolume)
            ->setShippedWeight($shippedWeight)
            ->setShippingSettings($shippingSettings)
            ->setShippingTerms($shippingTerms)
            ->setShippingZoneID($shippingZoneID)
            ->setShipVia($shipVia)
            ->setStatus($status)
            ->setToWarehouseID($toWarehouseID)
            ->setType($type)
            ->setUseCustomersAccount($useCustomersAccount)
            ->setWarehouseID($warehouseID)
            ->setWorkgroupID($workgroupID);
    }
    /**
     * Get BaseCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBaseCurrencyID()
    {
        return isset($this->BaseCurrencyID) ? $this->BaseCurrencyID : null;
    }
    /**
     * Set BaseCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $baseCurrencyID
     * @return \StructType\Shipment
     */
    public function setBaseCurrencyID(\StructType\StringValue $baseCurrencyID = null)
    {
        if (is_null($baseCurrencyID) || (is_array($baseCurrencyID) && empty($baseCurrencyID))) {
            unset($this->BaseCurrencyID);
        } else {
            $this->BaseCurrencyID = $baseCurrencyID;
        }
        return $this;
    }
    /**
     * Get ControlQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getControlQty()
    {
        return isset($this->ControlQty) ? $this->ControlQty : null;
    }
    /**
     * Set ControlQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $controlQty
     * @return \StructType\Shipment
     */
    public function setControlQty(\StructType\DecimalValue $controlQty = null)
    {
        if (is_null($controlQty) || (is_array($controlQty) && empty($controlQty))) {
            unset($this->ControlQty);
        } else {
            $this->ControlQty = $controlQty;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\Shipment
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\Shipment
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currencyRate
     * @return \StructType\Shipment
     */
    public function setCurrencyRate(\StructType\DecimalValue $currencyRate = null)
    {
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get CurrencyRateTypeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyRateTypeID()
    {
        return isset($this->CurrencyRateTypeID) ? $this->CurrencyRateTypeID : null;
    }
    /**
     * Set CurrencyRateTypeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyRateTypeID
     * @return \StructType\Shipment
     */
    public function setCurrencyRateTypeID(\StructType\StringValue $currencyRateTypeID = null)
    {
        if (is_null($currencyRateTypeID) || (is_array($currencyRateTypeID) && empty($currencyRateTypeID))) {
            unset($this->CurrencyRateTypeID);
        } else {
            $this->CurrencyRateTypeID = $currencyRateTypeID;
        }
        return $this;
    }
    /**
     * Get CurrencyViewState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCurrencyViewState()
    {
        return isset($this->CurrencyViewState) ? $this->CurrencyViewState : null;
    }
    /**
     * Set CurrencyViewState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $currencyViewState
     * @return \StructType\Shipment
     */
    public function setCurrencyViewState(\StructType\BooleanValue $currencyViewState = null)
    {
        if (is_null($currencyViewState) || (is_array($currencyViewState) && empty($currencyViewState))) {
            unset($this->CurrencyViewState);
        } else {
            $this->CurrencyViewState = $currencyViewState;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\Shipment
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\Shipment
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $effectiveDate
     * @return \StructType\Shipment
     */
    public function setEffectiveDate(\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $fOBPoint
     * @return \StructType\Shipment
     */
    public function setFOBPoint(\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get FreightAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreightAmount()
    {
        return isset($this->FreightAmount) ? $this->FreightAmount : null;
    }
    /**
     * Set FreightAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freightAmount
     * @return \StructType\Shipment
     */
    public function setFreightAmount(\StructType\DecimalValue $freightAmount = null)
    {
        if (is_null($freightAmount) || (is_array($freightAmount) && empty($freightAmount))) {
            unset($this->FreightAmount);
        } else {
            $this->FreightAmount = $freightAmount;
        }
        return $this;
    }
    /**
     * Get FreightCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreightCost()
    {
        return isset($this->FreightCost) ? $this->FreightCost : null;
    }
    /**
     * Set FreightCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freightCost
     * @return \StructType\Shipment
     */
    public function setFreightCost(\StructType\DecimalValue $freightCost = null)
    {
        if (is_null($freightCost) || (is_array($freightCost) && empty($freightCost))) {
            unset($this->FreightCost);
        } else {
            $this->FreightCost = $freightCost;
        }
        return $this;
    }
    /**
     * Get FreightCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFreightCurrency()
    {
        return isset($this->FreightCurrency) ? $this->FreightCurrency : null;
    }
    /**
     * Set FreightCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $freightCurrency
     * @return \StructType\Shipment
     */
    public function setFreightCurrency(\StructType\StringValue $freightCurrency = null)
    {
        if (is_null($freightCurrency) || (is_array($freightCurrency) && empty($freightCurrency))) {
            unset($this->FreightCurrency);
        } else {
            $this->FreightCurrency = $freightCurrency;
        }
        return $this;
    }
    /**
     * Get GroundCollect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getGroundCollect()
    {
        return isset($this->GroundCollect) ? $this->GroundCollect : null;
    }
    /**
     * Set GroundCollect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $groundCollect
     * @return \StructType\Shipment
     */
    public function setGroundCollect(\StructType\BooleanValue $groundCollect = null)
    {
        if (is_null($groundCollect) || (is_array($groundCollect) && empty($groundCollect))) {
            unset($this->GroundCollect);
        } else {
            $this->GroundCollect = $groundCollect;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\Shipment
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $insurance
     * @return \StructType\Shipment
     */
    public function setInsurance(\StructType\BooleanValue $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\Shipment
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\Shipment
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $operation
     * @return \StructType\Shipment
     */
    public function setOperation(\StructType\StringValue $operation = null)
    {
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get Orders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Orders|null
     */
    public function getOrders()
    {
        return isset($this->Orders) ? $this->Orders : null;
    }
    /**
     * Set Orders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Orders $orders
     * @return \StructType\Shipment
     */
    public function setOrders(\StructType\Orders $orders = null)
    {
        if (is_null($orders) || (is_array($orders) && empty($orders))) {
            unset($this->Orders);
        } else {
            $this->Orders = $orders;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $owner
     * @return \StructType\Shipment
     */
    public function setOwner(\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get PackageCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getPackageCount()
    {
        return isset($this->PackageCount) ? $this->PackageCount : null;
    }
    /**
     * Set PackageCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $packageCount
     * @return \StructType\Shipment
     */
    public function setPackageCount(\StructType\IntValue $packageCount = null)
    {
        if (is_null($packageCount) || (is_array($packageCount) && empty($packageCount))) {
            unset($this->PackageCount);
        } else {
            $this->PackageCount = $packageCount;
        }
        return $this;
    }
    /**
     * Get Packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Packages|null
     */
    public function getPackages()
    {
        return isset($this->Packages) ? $this->Packages : null;
    }
    /**
     * Set Packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Packages $packages
     * @return \StructType\Shipment
     */
    public function setPackages(\StructType\Packages $packages = null)
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->Packages);
        } else {
            $this->Packages = $packages;
        }
        return $this;
    }
    /**
     * Get PackageWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPackageWeight()
    {
        return isset($this->PackageWeight) ? $this->PackageWeight : null;
    }
    /**
     * Set PackageWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $packageWeight
     * @return \StructType\Shipment
     */
    public function setPackageWeight(\StructType\DecimalValue $packageWeight = null)
    {
        if (is_null($packageWeight) || (is_array($packageWeight) && empty($packageWeight))) {
            unset($this->PackageWeight);
        } else {
            $this->PackageWeight = $packageWeight;
        }
        return $this;
    }
    /**
     * Get ReciprocalRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getReciprocalRate()
    {
        return isset($this->ReciprocalRate) ? $this->ReciprocalRate : null;
    }
    /**
     * Set ReciprocalRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $reciprocalRate
     * @return \StructType\Shipment
     */
    public function setReciprocalRate(\StructType\DecimalValue $reciprocalRate = null)
    {
        if (is_null($reciprocalRate) || (is_array($reciprocalRate) && empty($reciprocalRate))) {
            unset($this->ReciprocalRate);
        } else {
            $this->ReciprocalRate = $reciprocalRate;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $residentialDelivery
     * @return \StructType\Shipment
     */
    public function setResidentialDelivery(\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $saturdayDelivery
     * @return \StructType\Shipment
     */
    public function setSaturdayDelivery(\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $shipmentDate
     * @return \StructType\Shipment
     */
    public function setShipmentDate(\StructType\DateTimeValue $shipmentDate = null)
    {
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipmentNbr
     * @return \StructType\Shipment
     */
    public function setShipmentNbr(\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get ShippedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippedQty()
    {
        return isset($this->ShippedQty) ? $this->ShippedQty : null;
    }
    /**
     * Set ShippedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippedQty
     * @return \StructType\Shipment
     */
    public function setShippedQty(\StructType\DecimalValue $shippedQty = null)
    {
        if (is_null($shippedQty) || (is_array($shippedQty) && empty($shippedQty))) {
            unset($this->ShippedQty);
        } else {
            $this->ShippedQty = $shippedQty;
        }
        return $this;
    }
    /**
     * Get ShippedVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippedVolume()
    {
        return isset($this->ShippedVolume) ? $this->ShippedVolume : null;
    }
    /**
     * Set ShippedVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippedVolume
     * @return \StructType\Shipment
     */
    public function setShippedVolume(\StructType\DecimalValue $shippedVolume = null)
    {
        if (is_null($shippedVolume) || (is_array($shippedVolume) && empty($shippedVolume))) {
            unset($this->ShippedVolume);
        } else {
            $this->ShippedVolume = $shippedVolume;
        }
        return $this;
    }
    /**
     * Get ShippedWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippedWeight()
    {
        return isset($this->ShippedWeight) ? $this->ShippedWeight : null;
    }
    /**
     * Set ShippedWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippedWeight
     * @return \StructType\Shipment
     */
    public function setShippedWeight(\StructType\DecimalValue $shippedWeight = null)
    {
        if (is_null($shippedWeight) || (is_array($shippedWeight) && empty($shippedWeight))) {
            unset($this->ShippedWeight);
        } else {
            $this->ShippedWeight = $shippedWeight;
        }
        return $this;
    }
    /**
     * Get ShippingSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipToSettings|null
     */
    public function getShippingSettings()
    {
        return isset($this->ShippingSettings) ? $this->ShippingSettings : null;
    }
    /**
     * Set ShippingSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShipToSettings $shippingSettings
     * @return \StructType\Shipment
     */
    public function setShippingSettings(\StructType\ShipToSettings $shippingSettings = null)
    {
        if (is_null($shippingSettings) || (is_array($shippingSettings) && empty($shippingSettings))) {
            unset($this->ShippingSettings);
        } else {
            $this->ShippingSettings = $shippingSettings;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingTerms
     * @return \StructType\Shipment
     */
    public function setShippingTerms(\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZoneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingZoneID()
    {
        return isset($this->ShippingZoneID) ? $this->ShippingZoneID : null;
    }
    /**
     * Set ShippingZoneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingZoneID
     * @return \StructType\Shipment
     */
    public function setShippingZoneID(\StructType\StringValue $shippingZoneID = null)
    {
        if (is_null($shippingZoneID) || (is_array($shippingZoneID) && empty($shippingZoneID))) {
            unset($this->ShippingZoneID);
        } else {
            $this->ShippingZoneID = $shippingZoneID;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipVia
     * @return \StructType\Shipment
     */
    public function setShipVia(\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Shipment
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ToWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getToWarehouseID()
    {
        return isset($this->ToWarehouseID) ? $this->ToWarehouseID : null;
    }
    /**
     * Set ToWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $toWarehouseID
     * @return \StructType\Shipment
     */
    public function setToWarehouseID(\StructType\StringValue $toWarehouseID = null)
    {
        if (is_null($toWarehouseID) || (is_array($toWarehouseID) && empty($toWarehouseID))) {
            unset($this->ToWarehouseID);
        } else {
            $this->ToWarehouseID = $toWarehouseID;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\Shipment
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UseCustomersAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getUseCustomersAccount()
    {
        return isset($this->UseCustomersAccount) ? $this->UseCustomersAccount : null;
    }
    /**
     * Set UseCustomersAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $useCustomersAccount
     * @return \StructType\Shipment
     */
    public function setUseCustomersAccount(\StructType\BooleanValue $useCustomersAccount = null)
    {
        if (is_null($useCustomersAccount) || (is_array($useCustomersAccount) && empty($useCustomersAccount))) {
            unset($this->UseCustomersAccount);
        } else {
            $this->UseCustomersAccount = $useCustomersAccount;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\Shipment
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Get WorkgroupID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWorkgroupID()
    {
        return isset($this->WorkgroupID) ? $this->WorkgroupID : null;
    }
    /**
     * Set WorkgroupID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $workgroupID
     * @return \StructType\Shipment
     */
    public function setWorkgroupID(\StructType\StringValue $workgroupID = null)
    {
        if (is_null($workgroupID) || (is_array($workgroupID) && empty($workgroupID))) {
            unset($this->WorkgroupID);
        } else {
            $this->WorkgroupID = $workgroupID;
        }
        return $this;
    }
}
