<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethod StructType
 * @subpackage Structs
 */
class PaymentMethod extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The AllowedCashAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AllowedCashAccounts
     */
    public $AllowedCashAccounts;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The IntegratedProcessing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IntegratedProcessing;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The MeansOfPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $MeansOfPayment;
    /**
     * The PaymentMethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethodID;
    /**
     * The ProcessingCenters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProcessingCenters
     */
    public $ProcessingCenters;
    /**
     * The RequireRemittanceInformationforCashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RequireRemittanceInformationforCashAccount;
    /**
     * The UseInAP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $UseInAP;
    /**
     * The UseInAR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $UseInAR;
    /**
     * Constructor method for PaymentMethod
     * @uses PaymentMethod::setActive()
     * @uses PaymentMethod::setAllowedCashAccounts()
     * @uses PaymentMethod::setCreatedDateTime()
     * @uses PaymentMethod::setDescription()
     * @uses PaymentMethod::setIntegratedProcessing()
     * @uses PaymentMethod::setLastModifiedDateTime()
     * @uses PaymentMethod::setMeansOfPayment()
     * @uses PaymentMethod::setPaymentMethodID()
     * @uses PaymentMethod::setProcessingCenters()
     * @uses PaymentMethod::setRequireRemittanceInformationforCashAccount()
     * @uses PaymentMethod::setUseInAP()
     * @uses PaymentMethod::setUseInAR()
     * @param \StructType\BooleanValue $active
     * @param \StructType\AllowedCashAccounts $allowedCashAccounts
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $description
     * @param \StructType\BooleanValue $integratedProcessing
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $meansOfPayment
     * @param \StructType\StringValue $paymentMethodID
     * @param \StructType\ProcessingCenters $processingCenters
     * @param \StructType\BooleanValue $requireRemittanceInformationforCashAccount
     * @param \StructType\BooleanValue $useInAP
     * @param \StructType\BooleanValue $useInAR
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\AllowedCashAccounts $allowedCashAccounts = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $description = null, \StructType\BooleanValue $integratedProcessing = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $meansOfPayment = null, \StructType\StringValue $paymentMethodID = null, \StructType\ProcessingCenters $processingCenters = null, \StructType\BooleanValue $requireRemittanceInformationforCashAccount = null, \StructType\BooleanValue $useInAP = null, \StructType\BooleanValue $useInAR = null)
    {
        $this
            ->setActive($active)
            ->setAllowedCashAccounts($allowedCashAccounts)
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setIntegratedProcessing($integratedProcessing)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMeansOfPayment($meansOfPayment)
            ->setPaymentMethodID($paymentMethodID)
            ->setProcessingCenters($processingCenters)
            ->setRequireRemittanceInformationforCashAccount($requireRemittanceInformationforCashAccount)
            ->setUseInAP($useInAP)
            ->setUseInAR($useInAR);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\PaymentMethod
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AllowedCashAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AllowedCashAccounts|null
     */
    public function getAllowedCashAccounts()
    {
        return isset($this->AllowedCashAccounts) ? $this->AllowedCashAccounts : null;
    }
    /**
     * Set AllowedCashAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AllowedCashAccounts $allowedCashAccounts
     * @return \StructType\PaymentMethod
     */
    public function setAllowedCashAccounts(\StructType\AllowedCashAccounts $allowedCashAccounts = null)
    {
        if (is_null($allowedCashAccounts) || (is_array($allowedCashAccounts) && empty($allowedCashAccounts))) {
            unset($this->AllowedCashAccounts);
        } else {
            $this->AllowedCashAccounts = $allowedCashAccounts;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\PaymentMethod
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\PaymentMethod
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IntegratedProcessing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIntegratedProcessing()
    {
        return isset($this->IntegratedProcessing) ? $this->IntegratedProcessing : null;
    }
    /**
     * Set IntegratedProcessing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $integratedProcessing
     * @return \StructType\PaymentMethod
     */
    public function setIntegratedProcessing(\StructType\BooleanValue $integratedProcessing = null)
    {
        if (is_null($integratedProcessing) || (is_array($integratedProcessing) && empty($integratedProcessing))) {
            unset($this->IntegratedProcessing);
        } else {
            $this->IntegratedProcessing = $integratedProcessing;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\PaymentMethod
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get MeansOfPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getMeansOfPayment()
    {
        return isset($this->MeansOfPayment) ? $this->MeansOfPayment : null;
    }
    /**
     * Set MeansOfPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $meansOfPayment
     * @return \StructType\PaymentMethod
     */
    public function setMeansOfPayment(\StructType\StringValue $meansOfPayment = null)
    {
        if (is_null($meansOfPayment) || (is_array($meansOfPayment) && empty($meansOfPayment))) {
            unset($this->MeansOfPayment);
        } else {
            $this->MeansOfPayment = $meansOfPayment;
        }
        return $this;
    }
    /**
     * Get PaymentMethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethodID()
    {
        return isset($this->PaymentMethodID) ? $this->PaymentMethodID : null;
    }
    /**
     * Set PaymentMethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethodID
     * @return \StructType\PaymentMethod
     */
    public function setPaymentMethodID(\StructType\StringValue $paymentMethodID = null)
    {
        if (is_null($paymentMethodID) || (is_array($paymentMethodID) && empty($paymentMethodID))) {
            unset($this->PaymentMethodID);
        } else {
            $this->PaymentMethodID = $paymentMethodID;
        }
        return $this;
    }
    /**
     * Get ProcessingCenters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProcessingCenters|null
     */
    public function getProcessingCenters()
    {
        return isset($this->ProcessingCenters) ? $this->ProcessingCenters : null;
    }
    /**
     * Set ProcessingCenters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProcessingCenters $processingCenters
     * @return \StructType\PaymentMethod
     */
    public function setProcessingCenters(\StructType\ProcessingCenters $processingCenters = null)
    {
        if (is_null($processingCenters) || (is_array($processingCenters) && empty($processingCenters))) {
            unset($this->ProcessingCenters);
        } else {
            $this->ProcessingCenters = $processingCenters;
        }
        return $this;
    }
    /**
     * Get RequireRemittanceInformationforCashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequireRemittanceInformationforCashAccount()
    {
        return isset($this->RequireRemittanceInformationforCashAccount) ? $this->RequireRemittanceInformationforCashAccount : null;
    }
    /**
     * Set RequireRemittanceInformationforCashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $requireRemittanceInformationforCashAccount
     * @return \StructType\PaymentMethod
     */
    public function setRequireRemittanceInformationforCashAccount(\StructType\BooleanValue $requireRemittanceInformationforCashAccount = null)
    {
        if (is_null($requireRemittanceInformationforCashAccount) || (is_array($requireRemittanceInformationforCashAccount) && empty($requireRemittanceInformationforCashAccount))) {
            unset($this->RequireRemittanceInformationforCashAccount);
        } else {
            $this->RequireRemittanceInformationforCashAccount = $requireRemittanceInformationforCashAccount;
        }
        return $this;
    }
    /**
     * Get UseInAP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getUseInAP()
    {
        return isset($this->UseInAP) ? $this->UseInAP : null;
    }
    /**
     * Set UseInAP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $useInAP
     * @return \StructType\PaymentMethod
     */
    public function setUseInAP(\StructType\BooleanValue $useInAP = null)
    {
        if (is_null($useInAP) || (is_array($useInAP) && empty($useInAP))) {
            unset($this->UseInAP);
        } else {
            $this->UseInAP = $useInAP;
        }
        return $this;
    }
    /**
     * Get UseInAR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getUseInAR()
    {
        return isset($this->UseInAR) ? $this->UseInAR : null;
    }
    /**
     * Set UseInAR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $useInAR
     * @return \StructType\PaymentMethod
     */
    public function setUseInAR(\StructType\BooleanValue $useInAR = null)
    {
        if (is_null($useInAR) || (is_array($useInAR) && empty($useInAR))) {
            unset($this->UseInAR);
        } else {
            $this->UseInAR = $useInAR;
        }
        return $this;
    }
}
