<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Orders StructType
 * @subpackage Structs
 */
class Orders extends AbstractStructBase
{
    /**
     * The BusinessAccountOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountOrder[]
     */
    public $BusinessAccountOrder;
    /**
     * The ShipmentOrderDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipmentOrderDetail[]
     */
    public $ShipmentOrderDetail;
    /**
     * Constructor method for Orders
     * @uses Orders::setBusinessAccountOrder()
     * @uses Orders::setShipmentOrderDetail()
     * @param \StructType\BusinessAccountOrder[] $businessAccountOrder
     * @param \StructType\ShipmentOrderDetail[] $shipmentOrderDetail
     */
    public function __construct(array $businessAccountOrder = array(), array $shipmentOrderDetail = array())
    {
        $this
            ->setBusinessAccountOrder($businessAccountOrder)
            ->setShipmentOrderDetail($shipmentOrderDetail);
    }
    /**
     * Get BusinessAccountOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountOrder[]|null
     */
    public function getBusinessAccountOrder()
    {
        return isset($this->BusinessAccountOrder) ? $this->BusinessAccountOrder : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountOrderForArrayConstraintsFromSetBusinessAccountOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ordersBusinessAccountOrderItem) {
            // validation for constraint: itemType
            if (!$ordersBusinessAccountOrderItem instanceof \StructType\BusinessAccountOrder) {
                $invalidValues[] = is_object($ordersBusinessAccountOrderItem) ? get_class($ordersBusinessAccountOrderItem) : sprintf('%s(%s)', gettype($ordersBusinessAccountOrderItem), var_export($ordersBusinessAccountOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountOrder property can only contain items of type \StructType\BusinessAccountOrder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountOrder[] $businessAccountOrder
     * @return \StructType\Orders
     */
    public function setBusinessAccountOrder(array $businessAccountOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountOrderArrayErrorMessage = self::validateBusinessAccountOrderForArrayConstraintsFromSetBusinessAccountOrder($businessAccountOrder))) {
            throw new \InvalidArgumentException($businessAccountOrderArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountOrder) || (is_array($businessAccountOrder) && empty($businessAccountOrder))) {
            unset($this->BusinessAccountOrder);
        } else {
            $this->BusinessAccountOrder = $businessAccountOrder;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountOrder $item
     * @return \StructType\Orders
     */
    public function addToBusinessAccountOrder(\StructType\BusinessAccountOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountOrder) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountOrder property can only contain items of type \StructType\BusinessAccountOrder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountOrder[] = $item;
        return $this;
    }
    /**
     * Get ShipmentOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipmentOrderDetail[]|null
     */
    public function getShipmentOrderDetail()
    {
        return isset($this->ShipmentOrderDetail) ? $this->ShipmentOrderDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentOrderDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentOrderDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentOrderDetailForArrayConstraintsFromSetShipmentOrderDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ordersShipmentOrderDetailItem) {
            // validation for constraint: itemType
            if (!$ordersShipmentOrderDetailItem instanceof \StructType\ShipmentOrderDetail) {
                $invalidValues[] = is_object($ordersShipmentOrderDetailItem) ? get_class($ordersShipmentOrderDetailItem) : sprintf('%s(%s)', gettype($ordersShipmentOrderDetailItem), var_export($ordersShipmentOrderDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentOrderDetail property can only contain items of type \StructType\ShipmentOrderDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentOrderDetail[] $shipmentOrderDetail
     * @return \StructType\Orders
     */
    public function setShipmentOrderDetail(array $shipmentOrderDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentOrderDetailArrayErrorMessage = self::validateShipmentOrderDetailForArrayConstraintsFromSetShipmentOrderDetail($shipmentOrderDetail))) {
            throw new \InvalidArgumentException($shipmentOrderDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentOrderDetail) || (is_array($shipmentOrderDetail) && empty($shipmentOrderDetail))) {
            unset($this->ShipmentOrderDetail);
        } else {
            $this->ShipmentOrderDetail = $shipmentOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to ShipmentOrderDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentOrderDetail $item
     * @return \StructType\Orders
     */
    public function addToShipmentOrderDetail(\StructType\ShipmentOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The ShipmentOrderDetail property can only contain items of type \StructType\ShipmentOrderDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentOrderDetail[] = $item;
        return $this;
    }
}
