<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Members StructType
 * @subpackage Structs
 */
class Members extends AbstractStructBase
{
    /**
     * The ItemSalesCategoryMember
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemSalesCategoryMember[]
     */
    public $ItemSalesCategoryMember;
    /**
     * Constructor method for Members
     * @uses Members::setItemSalesCategoryMember()
     * @param \StructType\ItemSalesCategoryMember[] $itemSalesCategoryMember
     */
    public function __construct(array $itemSalesCategoryMember = array())
    {
        $this
            ->setItemSalesCategoryMember($itemSalesCategoryMember);
    }
    /**
     * Get ItemSalesCategoryMember value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemSalesCategoryMember[]|null
     */
    public function getItemSalesCategoryMember()
    {
        return isset($this->ItemSalesCategoryMember) ? $this->ItemSalesCategoryMember : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemSalesCategoryMember method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemSalesCategoryMember method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemSalesCategoryMemberForArrayConstraintsFromSetItemSalesCategoryMember(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $membersItemSalesCategoryMemberItem) {
            // validation for constraint: itemType
            if (!$membersItemSalesCategoryMemberItem instanceof \StructType\ItemSalesCategoryMember) {
                $invalidValues[] = is_object($membersItemSalesCategoryMemberItem) ? get_class($membersItemSalesCategoryMemberItem) : sprintf('%s(%s)', gettype($membersItemSalesCategoryMemberItem), var_export($membersItemSalesCategoryMemberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemSalesCategoryMember property can only contain items of type \StructType\ItemSalesCategoryMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemSalesCategoryMember value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemSalesCategoryMember[] $itemSalesCategoryMember
     * @return \StructType\Members
     */
    public function setItemSalesCategoryMember(array $itemSalesCategoryMember = array())
    {
        // validation for constraint: array
        if ('' !== ($itemSalesCategoryMemberArrayErrorMessage = self::validateItemSalesCategoryMemberForArrayConstraintsFromSetItemSalesCategoryMember($itemSalesCategoryMember))) {
            throw new \InvalidArgumentException($itemSalesCategoryMemberArrayErrorMessage, __LINE__);
        }
        if (is_null($itemSalesCategoryMember) || (is_array($itemSalesCategoryMember) && empty($itemSalesCategoryMember))) {
            unset($this->ItemSalesCategoryMember);
        } else {
            $this->ItemSalesCategoryMember = $itemSalesCategoryMember;
        }
        return $this;
    }
    /**
     * Add item to ItemSalesCategoryMember value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemSalesCategoryMember $item
     * @return \StructType\Members
     */
    public function addToItemSalesCategoryMember(\StructType\ItemSalesCategoryMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemSalesCategoryMember) {
            throw new \InvalidArgumentException(sprintf('The ItemSalesCategoryMember property can only contain items of type \StructType\ItemSalesCategoryMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemSalesCategoryMember[] = $item;
        return $this;
    }
}
