<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LaborCostRate StructType
 * @subpackage Structs
 */
class LaborCostRate extends Entity
{
    /**
     * The AnnualRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AnnualRate;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The EmployeeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EmployeeID;
    /**
     * The EmployeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EmployeeName;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The HourlyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $HourlyRate;
    /**
     * The LaborItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LaborItem;
    /**
     * The LaborRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LaborRateType;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $RecordID;
    /**
     * The RegularHoursPerWeek
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RegularHoursPerWeek;
    /**
     * The TypeOfEmployment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TypeOfEmployment;
    /**
     * The UnionLocalID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UnionLocalID;
    /**
     * Constructor method for LaborCostRate
     * @uses LaborCostRate::setAnnualRate()
     * @uses LaborCostRate::setCurrencyID()
     * @uses LaborCostRate::setDescription()
     * @uses LaborCostRate::setEffectiveDate()
     * @uses LaborCostRate::setEmployeeID()
     * @uses LaborCostRate::setEmployeeName()
     * @uses LaborCostRate::setExternalRefNbr()
     * @uses LaborCostRate::setHourlyRate()
     * @uses LaborCostRate::setLaborItem()
     * @uses LaborCostRate::setLaborRateType()
     * @uses LaborCostRate::setProjectID()
     * @uses LaborCostRate::setProjectTaskID()
     * @uses LaborCostRate::setRecordID()
     * @uses LaborCostRate::setRegularHoursPerWeek()
     * @uses LaborCostRate::setTypeOfEmployment()
     * @uses LaborCostRate::setUnionLocalID()
     * @param \StructType\DecimalValue $annualRate
     * @param \StructType\StringValue $currencyID
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $effectiveDate
     * @param \StructType\StringValue $employeeID
     * @param \StructType\StringValue $employeeName
     * @param \StructType\StringValue $externalRefNbr
     * @param \StructType\DecimalValue $hourlyRate
     * @param \StructType\StringValue $laborItem
     * @param \StructType\StringValue $laborRateType
     * @param \StructType\StringValue $projectID
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\IntValue $recordID
     * @param \StructType\DecimalValue $regularHoursPerWeek
     * @param \StructType\StringValue $typeOfEmployment
     * @param \StructType\StringValue $unionLocalID
     */
    public function __construct(\StructType\DecimalValue $annualRate = null, \StructType\StringValue $currencyID = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $effectiveDate = null, \StructType\StringValue $employeeID = null, \StructType\StringValue $employeeName = null, \StructType\StringValue $externalRefNbr = null, \StructType\DecimalValue $hourlyRate = null, \StructType\StringValue $laborItem = null, \StructType\StringValue $laborRateType = null, \StructType\StringValue $projectID = null, \StructType\StringValue $projectTaskID = null, \StructType\IntValue $recordID = null, \StructType\DecimalValue $regularHoursPerWeek = null, \StructType\StringValue $typeOfEmployment = null, \StructType\StringValue $unionLocalID = null)
    {
        $this
            ->setAnnualRate($annualRate)
            ->setCurrencyID($currencyID)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setEmployeeID($employeeID)
            ->setEmployeeName($employeeName)
            ->setExternalRefNbr($externalRefNbr)
            ->setHourlyRate($hourlyRate)
            ->setLaborItem($laborItem)
            ->setLaborRateType($laborRateType)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setRecordID($recordID)
            ->setRegularHoursPerWeek($regularHoursPerWeek)
            ->setTypeOfEmployment($typeOfEmployment)
            ->setUnionLocalID($unionLocalID);
    }
    /**
     * Get AnnualRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAnnualRate()
    {
        return isset($this->AnnualRate) ? $this->AnnualRate : null;
    }
    /**
     * Set AnnualRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $annualRate
     * @return \StructType\LaborCostRate
     */
    public function setAnnualRate(\StructType\DecimalValue $annualRate = null)
    {
        if (is_null($annualRate) || (is_array($annualRate) && empty($annualRate))) {
            unset($this->AnnualRate);
        } else {
            $this->AnnualRate = $annualRate;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\LaborCostRate
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\LaborCostRate
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $effectiveDate
     * @return \StructType\LaborCostRate
     */
    public function setEffectiveDate(\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get EmployeeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployeeID()
    {
        return isset($this->EmployeeID) ? $this->EmployeeID : null;
    }
    /**
     * Set EmployeeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employeeID
     * @return \StructType\LaborCostRate
     */
    public function setEmployeeID(\StructType\StringValue $employeeID = null)
    {
        if (is_null($employeeID) || (is_array($employeeID) && empty($employeeID))) {
            unset($this->EmployeeID);
        } else {
            $this->EmployeeID = $employeeID;
        }
        return $this;
    }
    /**
     * Get EmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployeeName()
    {
        return isset($this->EmployeeName) ? $this->EmployeeName : null;
    }
    /**
     * Set EmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employeeName
     * @return \StructType\LaborCostRate
     */
    public function setEmployeeName(\StructType\StringValue $employeeName = null)
    {
        if (is_null($employeeName) || (is_array($employeeName) && empty($employeeName))) {
            unset($this->EmployeeName);
        } else {
            $this->EmployeeName = $employeeName;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalRefNbr
     * @return \StructType\LaborCostRate
     */
    public function setExternalRefNbr(\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get HourlyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getHourlyRate()
    {
        return isset($this->HourlyRate) ? $this->HourlyRate : null;
    }
    /**
     * Set HourlyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $hourlyRate
     * @return \StructType\LaborCostRate
     */
    public function setHourlyRate(\StructType\DecimalValue $hourlyRate = null)
    {
        if (is_null($hourlyRate) || (is_array($hourlyRate) && empty($hourlyRate))) {
            unset($this->HourlyRate);
        } else {
            $this->HourlyRate = $hourlyRate;
        }
        return $this;
    }
    /**
     * Get LaborItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLaborItem()
    {
        return isset($this->LaborItem) ? $this->LaborItem : null;
    }
    /**
     * Set LaborItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $laborItem
     * @return \StructType\LaborCostRate
     */
    public function setLaborItem(\StructType\StringValue $laborItem = null)
    {
        if (is_null($laborItem) || (is_array($laborItem) && empty($laborItem))) {
            unset($this->LaborItem);
        } else {
            $this->LaborItem = $laborItem;
        }
        return $this;
    }
    /**
     * Get LaborRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLaborRateType()
    {
        return isset($this->LaborRateType) ? $this->LaborRateType : null;
    }
    /**
     * Set LaborRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $laborRateType
     * @return \StructType\LaborCostRate
     */
    public function setLaborRateType(\StructType\StringValue $laborRateType = null)
    {
        if (is_null($laborRateType) || (is_array($laborRateType) && empty($laborRateType))) {
            unset($this->LaborRateType);
        } else {
            $this->LaborRateType = $laborRateType;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectID
     * @return \StructType\LaborCostRate
     */
    public function setProjectID(\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\LaborCostRate
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get RecordID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getRecordID()
    {
        return isset($this->RecordID) ? $this->RecordID : null;
    }
    /**
     * Set RecordID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $recordID
     * @return \StructType\LaborCostRate
     */
    public function setRecordID(\StructType\IntValue $recordID = null)
    {
        if (is_null($recordID) || (is_array($recordID) && empty($recordID))) {
            unset($this->RecordID);
        } else {
            $this->RecordID = $recordID;
        }
        return $this;
    }
    /**
     * Get RegularHoursPerWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRegularHoursPerWeek()
    {
        return isset($this->RegularHoursPerWeek) ? $this->RegularHoursPerWeek : null;
    }
    /**
     * Set RegularHoursPerWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $regularHoursPerWeek
     * @return \StructType\LaborCostRate
     */
    public function setRegularHoursPerWeek(\StructType\DecimalValue $regularHoursPerWeek = null)
    {
        if (is_null($regularHoursPerWeek) || (is_array($regularHoursPerWeek) && empty($regularHoursPerWeek))) {
            unset($this->RegularHoursPerWeek);
        } else {
            $this->RegularHoursPerWeek = $regularHoursPerWeek;
        }
        return $this;
    }
    /**
     * Get TypeOfEmployment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTypeOfEmployment()
    {
        return isset($this->TypeOfEmployment) ? $this->TypeOfEmployment : null;
    }
    /**
     * Set TypeOfEmployment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $typeOfEmployment
     * @return \StructType\LaborCostRate
     */
    public function setTypeOfEmployment(\StructType\StringValue $typeOfEmployment = null)
    {
        if (is_null($typeOfEmployment) || (is_array($typeOfEmployment) && empty($typeOfEmployment))) {
            unset($this->TypeOfEmployment);
        } else {
            $this->TypeOfEmployment = $typeOfEmployment;
        }
        return $this;
    }
    /**
     * Get UnionLocalID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUnionLocalID()
    {
        return isset($this->UnionLocalID) ? $this->UnionLocalID : null;
    }
    /**
     * Set UnionLocalID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $unionLocalID
     * @return \StructType\LaborCostRate
     */
    public function setUnionLocalID(\StructType\StringValue $unionLocalID = null)
    {
        if (is_null($unionLocalID) || (is_array($unionLocalID) && empty($unionLocalID))) {
            unset($this->UnionLocalID);
        } else {
            $this->UnionLocalID = $unionLocalID;
        }
        return $this;
    }
}
