<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailProcessing StructType
 * @subpackage Structs
 */
class EmailProcessing extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $Account;
    /**
     * The AccountEmailAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountEmailAccountID;
    /**
     * The AssignedToMe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AssignedToMe;
    /**
     * The AssignedToOwner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AssignedToOwner;
    /**
     * The IncludeFailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeFailed;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for EmailProcessing
     * @uses EmailProcessing::setAccount()
     * @uses EmailProcessing::setAccountEmailAccountID()
     * @uses EmailProcessing::setAssignedToMe()
     * @uses EmailProcessing::setAssignedToOwner()
     * @uses EmailProcessing::setIncludeFailed()
     * @uses EmailProcessing::setResult()
     * @uses EmailProcessing::setType()
     * @param \StructType\IntValue $account
     * @param \StructType\StringValue $accountEmailAccountID
     * @param \StructType\BooleanValue $assignedToMe
     * @param \StructType\StringValue $assignedToOwner
     * @param \StructType\BooleanValue $includeFailed
     * @param \StructType\Result $result
     * @param \StructType\StringValue $type
     */
    public function __construct(\StructType\IntValue $account = null, \StructType\StringValue $accountEmailAccountID = null, \StructType\BooleanValue $assignedToMe = null, \StructType\StringValue $assignedToOwner = null, \StructType\BooleanValue $includeFailed = null, \StructType\Result $result = null, \StructType\StringValue $type = null)
    {
        $this
            ->setAccount($account)
            ->setAccountEmailAccountID($accountEmailAccountID)
            ->setAssignedToMe($assignedToMe)
            ->setAssignedToOwner($assignedToOwner)
            ->setIncludeFailed($includeFailed)
            ->setResult($result)
            ->setType($type);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $account
     * @return \StructType\EmailProcessing
     */
    public function setAccount(\StructType\IntValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountEmailAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountEmailAccountID()
    {
        return isset($this->AccountEmailAccountID) ? $this->AccountEmailAccountID : null;
    }
    /**
     * Set AccountEmailAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountEmailAccountID
     * @return \StructType\EmailProcessing
     */
    public function setAccountEmailAccountID(\StructType\StringValue $accountEmailAccountID = null)
    {
        if (is_null($accountEmailAccountID) || (is_array($accountEmailAccountID) && empty($accountEmailAccountID))) {
            unset($this->AccountEmailAccountID);
        } else {
            $this->AccountEmailAccountID = $accountEmailAccountID;
        }
        return $this;
    }
    /**
     * Get AssignedToMe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAssignedToMe()
    {
        return isset($this->AssignedToMe) ? $this->AssignedToMe : null;
    }
    /**
     * Set AssignedToMe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $assignedToMe
     * @return \StructType\EmailProcessing
     */
    public function setAssignedToMe(\StructType\BooleanValue $assignedToMe = null)
    {
        if (is_null($assignedToMe) || (is_array($assignedToMe) && empty($assignedToMe))) {
            unset($this->AssignedToMe);
        } else {
            $this->AssignedToMe = $assignedToMe;
        }
        return $this;
    }
    /**
     * Get AssignedToOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAssignedToOwner()
    {
        return isset($this->AssignedToOwner) ? $this->AssignedToOwner : null;
    }
    /**
     * Set AssignedToOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $assignedToOwner
     * @return \StructType\EmailProcessing
     */
    public function setAssignedToOwner(\StructType\StringValue $assignedToOwner = null)
    {
        if (is_null($assignedToOwner) || (is_array($assignedToOwner) && empty($assignedToOwner))) {
            unset($this->AssignedToOwner);
        } else {
            $this->AssignedToOwner = $assignedToOwner;
        }
        return $this;
    }
    /**
     * Get IncludeFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeFailed()
    {
        return isset($this->IncludeFailed) ? $this->IncludeFailed : null;
    }
    /**
     * Set IncludeFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeFailed
     * @return \StructType\EmailProcessing
     */
    public function setIncludeFailed(\StructType\BooleanValue $includeFailed = null)
    {
        if (is_null($includeFailed) || (is_array($includeFailed) && empty($includeFailed))) {
            unset($this->IncludeFailed);
        } else {
            $this->IncludeFailed = $includeFailed;
        }
        return $this;
    }
    /**
     * Get Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return isset($this->Result) ? $this->Result : null;
    }
    /**
     * Set Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Result $result
     * @return \StructType\EmailProcessing
     */
    public function setResult(\StructType\Result $result = null)
    {
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->Result);
        } else {
            $this->Result = $result;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\EmailProcessing
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
