<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discounts StructType
 * @subpackage Structs
 */
class Discounts extends AbstractStructBase
{
    /**
     * The OpportunityDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpportunityDiscount[]
     */
    public $OpportunityDiscount;
    /**
     * Constructor method for Discounts
     * @uses Discounts::setOpportunityDiscount()
     * @param \StructType\OpportunityDiscount[] $opportunityDiscount
     */
    public function __construct(array $opportunityDiscount = array())
    {
        $this
            ->setOpportunityDiscount($opportunityDiscount);
    }
    /**
     * Get OpportunityDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpportunityDiscount[]|null
     */
    public function getOpportunityDiscount()
    {
        return isset($this->OpportunityDiscount) ? $this->OpportunityDiscount : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOpportunityDiscount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpportunityDiscount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpportunityDiscountForArrayConstraintsFromSetOpportunityDiscount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountsOpportunityDiscountItem) {
            // validation for constraint: itemType
            if (!$discountsOpportunityDiscountItem instanceof \StructType\OpportunityDiscount) {
                $invalidValues[] = is_object($discountsOpportunityDiscountItem) ? get_class($discountsOpportunityDiscountItem) : sprintf('%s(%s)', gettype($discountsOpportunityDiscountItem), var_export($discountsOpportunityDiscountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OpportunityDiscount property can only contain items of type \StructType\OpportunityDiscount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OpportunityDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityDiscount[] $opportunityDiscount
     * @return \StructType\Discounts
     */
    public function setOpportunityDiscount(array $opportunityDiscount = array())
    {
        // validation for constraint: array
        if ('' !== ($opportunityDiscountArrayErrorMessage = self::validateOpportunityDiscountForArrayConstraintsFromSetOpportunityDiscount($opportunityDiscount))) {
            throw new \InvalidArgumentException($opportunityDiscountArrayErrorMessage, __LINE__);
        }
        if (is_null($opportunityDiscount) || (is_array($opportunityDiscount) && empty($opportunityDiscount))) {
            unset($this->OpportunityDiscount);
        } else {
            $this->OpportunityDiscount = $opportunityDiscount;
        }
        return $this;
    }
    /**
     * Add item to OpportunityDiscount value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityDiscount $item
     * @return \StructType\Discounts
     */
    public function addToOpportunityDiscount(\StructType\OpportunityDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpportunityDiscount) {
            throw new \InvalidArgumentException(sprintf('The OpportunityDiscount property can only contain items of type \StructType\OpportunityDiscount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OpportunityDiscount[] = $item;
        return $this;
    }
}
