<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountWarehouseDetail StructType
 * @subpackage Structs
 */
class DiscountWarehouseDetail extends Entity
{
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for DiscountWarehouseDetail
     * @uses DiscountWarehouseDetail::setWarehouse()
     * @param \StructType\StringValue $warehouse
     */
    public function __construct(\StructType\StringValue $warehouse = null)
    {
        $this
            ->setWarehouse($warehouse);
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouse
     * @return \StructType\DiscountWarehouseDetail
     */
    public function setWarehouse(\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
}
