<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DefaultTaskForGLAccount StructType
 * @subpackage Structs
 */
class DefaultTaskForGLAccount extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Account;
    /**
     * The DefaultTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DefaultTask;
    /**
     * Constructor method for DefaultTaskForGLAccount
     * @uses DefaultTaskForGLAccount::setAccount()
     * @uses DefaultTaskForGLAccount::setDefaultTask()
     * @param \StructType\StringValue $account
     * @param \StructType\StringValue $defaultTask
     */
    public function __construct(\StructType\StringValue $account = null, \StructType\StringValue $defaultTask = null)
    {
        $this
            ->setAccount($account)
            ->setDefaultTask($defaultTask);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $account
     * @return \StructType\DefaultTaskForGLAccount
     */
    public function setAccount(\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get DefaultTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDefaultTask()
    {
        return isset($this->DefaultTask) ? $this->DefaultTask : null;
    }
    /**
     * Set DefaultTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $defaultTask
     * @return \StructType\DefaultTaskForGLAccount
     */
    public function setDefaultTask(\StructType\StringValue $defaultTask = null)
    {
        if (is_null($defaultTask) || (is_array($defaultTask) && empty($defaultTask))) {
            unset($this->DefaultTask);
        } else {
            $this->DefaultTask = $defaultTask;
        }
        return $this;
    }
}
