<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contracts StructType
 * @subpackage Structs
 */
class Contracts extends AbstractStructBase
{
    /**
     * The BusinessAccountContract
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountContract[]
     */
    public $BusinessAccountContract;
    /**
     * Constructor method for Contracts
     * @uses Contracts::setBusinessAccountContract()
     * @param \StructType\BusinessAccountContract[] $businessAccountContract
     */
    public function __construct(array $businessAccountContract = array())
    {
        $this
            ->setBusinessAccountContract($businessAccountContract);
    }
    /**
     * Get BusinessAccountContract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountContract[]|null
     */
    public function getBusinessAccountContract()
    {
        return isset($this->BusinessAccountContract) ? $this->BusinessAccountContract : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountContract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountContract method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountContractForArrayConstraintsFromSetBusinessAccountContract(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractsBusinessAccountContractItem) {
            // validation for constraint: itemType
            if (!$contractsBusinessAccountContractItem instanceof \StructType\BusinessAccountContract) {
                $invalidValues[] = is_object($contractsBusinessAccountContractItem) ? get_class($contractsBusinessAccountContractItem) : sprintf('%s(%s)', gettype($contractsBusinessAccountContractItem), var_export($contractsBusinessAccountContractItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountContract property can only contain items of type \StructType\BusinessAccountContract, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountContract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountContract[] $businessAccountContract
     * @return \StructType\Contracts
     */
    public function setBusinessAccountContract(array $businessAccountContract = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountContractArrayErrorMessage = self::validateBusinessAccountContractForArrayConstraintsFromSetBusinessAccountContract($businessAccountContract))) {
            throw new \InvalidArgumentException($businessAccountContractArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountContract) || (is_array($businessAccountContract) && empty($businessAccountContract))) {
            unset($this->BusinessAccountContract);
        } else {
            $this->BusinessAccountContract = $businessAccountContract;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountContract value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountContract $item
     * @return \StructType\Contracts
     */
    public function addToBusinessAccountContract(\StructType\BusinessAccountContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountContract) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountContract property can only contain items of type \StructType\BusinessAccountContract, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountContract[] = $item;
        return $this;
    }
}
