<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractUsage StructType
 * @subpackage Structs
 */
class ContractUsage extends Entity
{
    /**
     * The BilledTransactions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BilledTransactions
     */
    public $BilledTransactions;
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ContractID;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The UnbilledTransactions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnbilledTransactions
     */
    public $UnbilledTransactions;
    /**
     * Constructor method for ContractUsage
     * @uses ContractUsage::setBilledTransactions()
     * @uses ContractUsage::setContractID()
     * @uses ContractUsage::setPostPeriod()
     * @uses ContractUsage::setUnbilledTransactions()
     * @param \StructType\BilledTransactions $billedTransactions
     * @param \StructType\StringValue $contractID
     * @param \StructType\StringValue $postPeriod
     * @param \StructType\UnbilledTransactions $unbilledTransactions
     */
    public function __construct(\StructType\BilledTransactions $billedTransactions = null, \StructType\StringValue $contractID = null, \StructType\StringValue $postPeriod = null, \StructType\UnbilledTransactions $unbilledTransactions = null)
    {
        $this
            ->setBilledTransactions($billedTransactions)
            ->setContractID($contractID)
            ->setPostPeriod($postPeriod)
            ->setUnbilledTransactions($unbilledTransactions);
    }
    /**
     * Get BilledTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BilledTransactions|null
     */
    public function getBilledTransactions()
    {
        return isset($this->BilledTransactions) ? $this->BilledTransactions : null;
    }
    /**
     * Set BilledTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BilledTransactions $billedTransactions
     * @return \StructType\ContractUsage
     */
    public function setBilledTransactions(\StructType\BilledTransactions $billedTransactions = null)
    {
        if (is_null($billedTransactions) || (is_array($billedTransactions) && empty($billedTransactions))) {
            unset($this->BilledTransactions);
        } else {
            $this->BilledTransactions = $billedTransactions;
        }
        return $this;
    }
    /**
     * Get ContractID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getContractID()
    {
        return isset($this->ContractID) ? $this->ContractID : null;
    }
    /**
     * Set ContractID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $contractID
     * @return \StructType\ContractUsage
     */
    public function setContractID(\StructType\StringValue $contractID = null)
    {
        if (is_null($contractID) || (is_array($contractID) && empty($contractID))) {
            unset($this->ContractID);
        } else {
            $this->ContractID = $contractID;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $postPeriod
     * @return \StructType\ContractUsage
     */
    public function setPostPeriod(\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get UnbilledTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnbilledTransactions|null
     */
    public function getUnbilledTransactions()
    {
        return isset($this->UnbilledTransactions) ? $this->UnbilledTransactions : null;
    }
    /**
     * Set UnbilledTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UnbilledTransactions $unbilledTransactions
     * @return \StructType\ContractUsage
     */
    public function setUnbilledTransactions(\StructType\UnbilledTransactions $unbilledTransactions = null)
    {
        if (is_null($unbilledTransactions) || (is_array($unbilledTransactions) && empty($unbilledTransactions))) {
            unset($this->UnbilledTransactions);
        } else {
            $this->UnbilledTransactions = $unbilledTransactions;
        }
        return $this;
    }
}
