<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applications StructType
 * @subpackage Structs
 */
class Applications extends AbstractStructBase
{
    /**
     * The BillApplicationDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillApplicationDetail[]
     */
    public $BillApplicationDetail;
    /**
     * Constructor method for Applications
     * @uses Applications::setBillApplicationDetail()
     * @param \StructType\BillApplicationDetail[] $billApplicationDetail
     */
    public function __construct(array $billApplicationDetail = array())
    {
        $this
            ->setBillApplicationDetail($billApplicationDetail);
    }
    /**
     * Get BillApplicationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillApplicationDetail[]|null
     */
    public function getBillApplicationDetail()
    {
        return isset($this->BillApplicationDetail) ? $this->BillApplicationDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBillApplicationDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillApplicationDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillApplicationDetailForArrayConstraintsFromSetBillApplicationDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsBillApplicationDetailItem) {
            // validation for constraint: itemType
            if (!$applicationsBillApplicationDetailItem instanceof \StructType\BillApplicationDetail) {
                $invalidValues[] = is_object($applicationsBillApplicationDetailItem) ? get_class($applicationsBillApplicationDetailItem) : sprintf('%s(%s)', gettype($applicationsBillApplicationDetailItem), var_export($applicationsBillApplicationDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillApplicationDetail property can only contain items of type \StructType\BillApplicationDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillApplicationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BillApplicationDetail[] $billApplicationDetail
     * @return \StructType\Applications
     */
    public function setBillApplicationDetail(array $billApplicationDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($billApplicationDetailArrayErrorMessage = self::validateBillApplicationDetailForArrayConstraintsFromSetBillApplicationDetail($billApplicationDetail))) {
            throw new \InvalidArgumentException($billApplicationDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($billApplicationDetail) || (is_array($billApplicationDetail) && empty($billApplicationDetail))) {
            unset($this->BillApplicationDetail);
        } else {
            $this->BillApplicationDetail = $billApplicationDetail;
        }
        return $this;
    }
    /**
     * Add item to BillApplicationDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BillApplicationDetail $item
     * @return \StructType\Applications
     */
    public function addToBillApplicationDetail(\StructType\BillApplicationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BillApplicationDetail) {
            throw new \InvalidArgumentException(sprintf('The BillApplicationDetail property can only contain items of type \StructType\BillApplicationDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillApplicationDetail[] = $item;
        return $this;
    }
}
