<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APDocuments StructType
 * @subpackage Structs
 */
class APDocuments extends AbstractStructBase
{
    /**
     * The ExpenseClaimAPDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExpenseClaimAPDocument[]
     */
    public $ExpenseClaimAPDocument;
    /**
     * Constructor method for APDocuments
     * @uses APDocuments::setExpenseClaimAPDocument()
     * @param \StructType\ExpenseClaimAPDocument[] $expenseClaimAPDocument
     */
    public function __construct(array $expenseClaimAPDocument = array())
    {
        $this
            ->setExpenseClaimAPDocument($expenseClaimAPDocument);
    }
    /**
     * Get ExpenseClaimAPDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExpenseClaimAPDocument[]|null
     */
    public function getExpenseClaimAPDocument()
    {
        return isset($this->ExpenseClaimAPDocument) ? $this->ExpenseClaimAPDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExpenseClaimAPDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpenseClaimAPDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseClaimAPDocumentForArrayConstraintsFromSetExpenseClaimAPDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aPDocumentsExpenseClaimAPDocumentItem) {
            // validation for constraint: itemType
            if (!$aPDocumentsExpenseClaimAPDocumentItem instanceof \StructType\ExpenseClaimAPDocument) {
                $invalidValues[] = is_object($aPDocumentsExpenseClaimAPDocumentItem) ? get_class($aPDocumentsExpenseClaimAPDocumentItem) : sprintf('%s(%s)', gettype($aPDocumentsExpenseClaimAPDocumentItem), var_export($aPDocumentsExpenseClaimAPDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExpenseClaimAPDocument property can only contain items of type \StructType\ExpenseClaimAPDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExpenseClaimAPDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseClaimAPDocument[] $expenseClaimAPDocument
     * @return \StructType\APDocuments
     */
    public function setExpenseClaimAPDocument(array $expenseClaimAPDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseClaimAPDocumentArrayErrorMessage = self::validateExpenseClaimAPDocumentForArrayConstraintsFromSetExpenseClaimAPDocument($expenseClaimAPDocument))) {
            throw new \InvalidArgumentException($expenseClaimAPDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($expenseClaimAPDocument) || (is_array($expenseClaimAPDocument) && empty($expenseClaimAPDocument))) {
            unset($this->ExpenseClaimAPDocument);
        } else {
            $this->ExpenseClaimAPDocument = $expenseClaimAPDocument;
        }
        return $this;
    }
    /**
     * Add item to ExpenseClaimAPDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseClaimAPDocument $item
     * @return \StructType\APDocuments
     */
    public function addToExpenseClaimAPDocument(\StructType\ExpenseClaimAPDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpenseClaimAPDocument) {
            throw new \InvalidArgumentException(sprintf('The ExpenseClaimAPDocument property can only contain items of type \StructType\ExpenseClaimAPDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExpenseClaimAPDocument[] = $item;
        return $this;
    }
}
