<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warehouses StructType
 * @subpackage Structs
 */
class Warehouses extends AbstractStructBase
{
    /**
     * The DiscountWarehouseDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DiscountWarehouseDetail[]
     */
    public $DiscountWarehouseDetail;
    /**
     * Constructor method for Warehouses
     * @uses Warehouses::setDiscountWarehouseDetail()
     * @param \StructType\DiscountWarehouseDetail[] $discountWarehouseDetail
     */
    public function __construct(array $discountWarehouseDetail = array())
    {
        $this
            ->setDiscountWarehouseDetail($discountWarehouseDetail);
    }
    /**
     * Get DiscountWarehouseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiscountWarehouseDetail[]|null
     */
    public function getDiscountWarehouseDetail()
    {
        return isset($this->DiscountWarehouseDetail) ? $this->DiscountWarehouseDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountWarehouseDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountWarehouseDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountWarehouseDetailForArrayConstraintsFromSetDiscountWarehouseDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $warehousesDiscountWarehouseDetailItem) {
            // validation for constraint: itemType
            if (!$warehousesDiscountWarehouseDetailItem instanceof \StructType\DiscountWarehouseDetail) {
                $invalidValues[] = is_object($warehousesDiscountWarehouseDetailItem) ? get_class($warehousesDiscountWarehouseDetailItem) : sprintf('%s(%s)', gettype($warehousesDiscountWarehouseDetailItem), var_export($warehousesDiscountWarehouseDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountWarehouseDetail property can only contain items of type \StructType\DiscountWarehouseDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountWarehouseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountWarehouseDetail[] $discountWarehouseDetail
     * @return \StructType\Warehouses
     */
    public function setDiscountWarehouseDetail(array $discountWarehouseDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountWarehouseDetailArrayErrorMessage = self::validateDiscountWarehouseDetailForArrayConstraintsFromSetDiscountWarehouseDetail($discountWarehouseDetail))) {
            throw new \InvalidArgumentException($discountWarehouseDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($discountWarehouseDetail) || (is_array($discountWarehouseDetail) && empty($discountWarehouseDetail))) {
            unset($this->DiscountWarehouseDetail);
        } else {
            $this->DiscountWarehouseDetail = $discountWarehouseDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountWarehouseDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountWarehouseDetail $item
     * @return \StructType\Warehouses
     */
    public function addToDiscountWarehouseDetail(\StructType\DiscountWarehouseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountWarehouseDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountWarehouseDetail property can only contain items of type \StructType\DiscountWarehouseDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountWarehouseDetail[] = $item;
        return $this;
    }
}
