<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPricesInquiry StructType
 * @subpackage Structs
 */
class VendorPricesInquiry extends Entity
{
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Vendor;
    /**
     * The VendorPriceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VendorPriceDetails
     */
    public $VendorPriceDetails;
    /**
     * Constructor method for VendorPricesInquiry
     * @uses VendorPricesInquiry::setInventoryID()
     * @uses VendorPricesInquiry::setItemClass()
     * @uses VendorPricesInquiry::setProductManager()
     * @uses VendorPricesInquiry::setProductWorkgroup()
     * @uses VendorPricesInquiry::setVendor()
     * @uses VendorPricesInquiry::setVendorPriceDetails()
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\StringValue $itemClass
     * @param \StructType\StringValue $productManager
     * @param \StructType\StringValue $productWorkgroup
     * @param \StructType\StringValue $vendor
     * @param \StructType\VendorPriceDetails $vendorPriceDetails
     */
    public function __construct(\StructType\StringValue $inventoryID = null, \StructType\StringValue $itemClass = null, \StructType\StringValue $productManager = null, \StructType\StringValue $productWorkgroup = null, \StructType\StringValue $vendor = null, \StructType\VendorPriceDetails $vendorPriceDetails = null)
    {
        $this
            ->setInventoryID($inventoryID)
            ->setItemClass($itemClass)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setVendor($vendor)
            ->setVendorPriceDetails($vendorPriceDetails);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\VendorPricesInquiry
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $itemClass
     * @return \StructType\VendorPricesInquiry
     */
    public function setItemClass(\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $productManager
     * @return \StructType\VendorPricesInquiry
     */
    public function setProductManager(\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $productWorkgroup
     * @return \StructType\VendorPricesInquiry
     */
    public function setProductWorkgroup(\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendor
     * @return \StructType\VendorPricesInquiry
     */
    public function setVendor(\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Get VendorPriceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VendorPriceDetails|null
     */
    public function getVendorPriceDetails()
    {
        return isset($this->VendorPriceDetails) ? $this->VendorPriceDetails : null;
    }
    /**
     * Set VendorPriceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VendorPriceDetails $vendorPriceDetails
     * @return \StructType\VendorPricesInquiry
     */
    public function setVendorPriceDetails(\StructType\VendorPriceDetails $vendorPriceDetails = null)
    {
        if (is_null($vendorPriceDetails) || (is_array($vendorPriceDetails) && empty($vendorPriceDetails))) {
            unset($this->VendorPriceDetails);
        } else {
            $this->VendorPriceDetails = $vendorPriceDetails;
        }
        return $this;
    }
}
