<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor StructType
 * @subpackage Structs
 */
class Vendor extends Entity
{
    /**
     * The AccountRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountRef;
    /**
     * The APAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $APAccount;
    /**
     * The APSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $APSubaccount;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attributes
     */
    public $Attributes;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CashAccount;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contacts
     */
    public $Contacts;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyRateType;
    /**
     * The EnableCurrencyOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $EnableCurrencyOverride;
    /**
     * The EnableRateOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $EnableRateOverride;
    /**
     * The F1099Box
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $F1099Box;
    /**
     * The F1099Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $F1099Vendor;
    /**
     * The FATCA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $FATCA;
    /**
     * The FOBPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The ForeignEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ForeignEntity;
    /**
     * The LandedCostVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $LandedCostVendor;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LeadTimedays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $LeadTimedays;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationName;
    /**
     * The MainContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $MainContact;
    /**
     * The MaxReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxReceipt;
    /**
     * The MinReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MinReceipt;
    /**
     * The ParentAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ParentAccount;
    /**
     * The PaymentBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentBy;
    /**
     * The PaymentInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentInstructions
     */
    public $PaymentInstructions;
    /**
     * The PaymentLeadTimedays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $PaymentLeadTimedays;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaySeparately
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $PaySeparately;
    /**
     * The PrintOrders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $PrintOrders;
    /**
     * The ReceiptAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReceiptAction;
    /**
     * The ReceivingBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReceivingBranch;
    /**
     * The RemittanceAddressSameasMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RemittanceAddressSameasMain;
    /**
     * The RemittanceContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $RemittanceContact;
    /**
     * The RemittanceContactSameasMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RemittanceContactSameasMain;
    /**
     * The SendOrdersbyEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SendOrdersbyEmail;
    /**
     * The ShippersContactSameasMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShippersContactSameasMain;
    /**
     * The ShippingAddressSameasMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShippingAddressSameasMain;
    /**
     * The ShippingContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $ShippingContact;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxCalculationMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCalculationMode;
    /**
     * The TaxRegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Terms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Terms;
    /**
     * The ThresholdReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ThresholdReceipt;
    /**
     * The VendorClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorClass;
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorID;
    /**
     * The VendorIsLaborUnion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $VendorIsLaborUnion;
    /**
     * The VendorIsTaxAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $VendorIsTaxAgency;
    /**
     * The VendorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorName;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for Vendor
     * @uses Vendor::setAccountRef()
     * @uses Vendor::setAPAccount()
     * @uses Vendor::setAPSubaccount()
     * @uses Vendor::setAttributes()
     * @uses Vendor::setCashAccount()
     * @uses Vendor::setContacts()
     * @uses Vendor::setCreatedDateTime()
     * @uses Vendor::setCurrencyID()
     * @uses Vendor::setCurrencyRateType()
     * @uses Vendor::setEnableCurrencyOverride()
     * @uses Vendor::setEnableRateOverride()
     * @uses Vendor::setF1099Box()
     * @uses Vendor::setF1099Vendor()
     * @uses Vendor::setFATCA()
     * @uses Vendor::setFOBPoint()
     * @uses Vendor::setForeignEntity()
     * @uses Vendor::setLandedCostVendor()
     * @uses Vendor::setLastModifiedDateTime()
     * @uses Vendor::setLeadTimedays()
     * @uses Vendor::setLocationName()
     * @uses Vendor::setMainContact()
     * @uses Vendor::setMaxReceipt()
     * @uses Vendor::setMinReceipt()
     * @uses Vendor::setParentAccount()
     * @uses Vendor::setPaymentBy()
     * @uses Vendor::setPaymentInstructions()
     * @uses Vendor::setPaymentLeadTimedays()
     * @uses Vendor::setPaymentMethod()
     * @uses Vendor::setPaySeparately()
     * @uses Vendor::setPrintOrders()
     * @uses Vendor::setReceiptAction()
     * @uses Vendor::setReceivingBranch()
     * @uses Vendor::setRemittanceAddressSameasMain()
     * @uses Vendor::setRemittanceContact()
     * @uses Vendor::setRemittanceContactSameasMain()
     * @uses Vendor::setSendOrdersbyEmail()
     * @uses Vendor::setShippersContactSameasMain()
     * @uses Vendor::setShippingAddressSameasMain()
     * @uses Vendor::setShippingContact()
     * @uses Vendor::setShippingTerms()
     * @uses Vendor::setShipVia()
     * @uses Vendor::setStatus()
     * @uses Vendor::setTaxCalculationMode()
     * @uses Vendor::setTaxRegistrationID()
     * @uses Vendor::setTaxZone()
     * @uses Vendor::setTerms()
     * @uses Vendor::setThresholdReceipt()
     * @uses Vendor::setVendorClass()
     * @uses Vendor::setVendorID()
     * @uses Vendor::setVendorIsLaborUnion()
     * @uses Vendor::setVendorIsTaxAgency()
     * @uses Vendor::setVendorName()
     * @uses Vendor::setWarehouse()
     * @param \StructType\StringValue $accountRef
     * @param \StructType\StringValue $aPAccount
     * @param \StructType\StringValue $aPSubaccount
     * @param \StructType\Attributes $attributes
     * @param \StructType\StringValue $cashAccount
     * @param \StructType\Contacts $contacts
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $currencyID
     * @param \StructType\StringValue $currencyRateType
     * @param \StructType\BooleanValue $enableCurrencyOverride
     * @param \StructType\BooleanValue $enableRateOverride
     * @param \StructType\StringValue $f1099Box
     * @param \StructType\BooleanValue $f1099Vendor
     * @param \StructType\BooleanValue $fATCA
     * @param \StructType\StringValue $fOBPoint
     * @param \StructType\BooleanValue $foreignEntity
     * @param \StructType\BooleanValue $landedCostVendor
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\ShortValue $leadTimedays
     * @param \StructType\StringValue $locationName
     * @param \StructType\Contact $mainContact
     * @param \StructType\DecimalValue $maxReceipt
     * @param \StructType\DecimalValue $minReceipt
     * @param \StructType\StringValue $parentAccount
     * @param \StructType\StringValue $paymentBy
     * @param \StructType\PaymentInstructions $paymentInstructions
     * @param \StructType\ShortValue $paymentLeadTimedays
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\BooleanValue $paySeparately
     * @param \StructType\BooleanValue $printOrders
     * @param \StructType\StringValue $receiptAction
     * @param \StructType\StringValue $receivingBranch
     * @param \StructType\BooleanValue $remittanceAddressSameasMain
     * @param \StructType\Contact $remittanceContact
     * @param \StructType\BooleanValue $remittanceContactSameasMain
     * @param \StructType\BooleanValue $sendOrdersbyEmail
     * @param \StructType\BooleanValue $shippersContactSameasMain
     * @param \StructType\BooleanValue $shippingAddressSameasMain
     * @param \StructType\Contact $shippingContact
     * @param \StructType\StringValue $shippingTerms
     * @param \StructType\StringValue $shipVia
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $taxCalculationMode
     * @param \StructType\StringValue $taxRegistrationID
     * @param \StructType\StringValue $taxZone
     * @param \StructType\StringValue $terms
     * @param \StructType\DecimalValue $thresholdReceipt
     * @param \StructType\StringValue $vendorClass
     * @param \StructType\StringValue $vendorID
     * @param \StructType\BooleanValue $vendorIsLaborUnion
     * @param \StructType\BooleanValue $vendorIsTaxAgency
     * @param \StructType\StringValue $vendorName
     * @param \StructType\StringValue $warehouse
     */
    public function __construct(\StructType\StringValue $accountRef = null, \StructType\StringValue $aPAccount = null, \StructType\StringValue $aPSubaccount = null, \StructType\Attributes $attributes = null, \StructType\StringValue $cashAccount = null, \StructType\Contacts $contacts = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $currencyID = null, \StructType\StringValue $currencyRateType = null, \StructType\BooleanValue $enableCurrencyOverride = null, \StructType\BooleanValue $enableRateOverride = null, \StructType\StringValue $f1099Box = null, \StructType\BooleanValue $f1099Vendor = null, \StructType\BooleanValue $fATCA = null, \StructType\StringValue $fOBPoint = null, \StructType\BooleanValue $foreignEntity = null, \StructType\BooleanValue $landedCostVendor = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\ShortValue $leadTimedays = null, \StructType\StringValue $locationName = null, \StructType\Contact $mainContact = null, \StructType\DecimalValue $maxReceipt = null, \StructType\DecimalValue $minReceipt = null, \StructType\StringValue $parentAccount = null, \StructType\StringValue $paymentBy = null, \StructType\PaymentInstructions $paymentInstructions = null, \StructType\ShortValue $paymentLeadTimedays = null, \StructType\StringValue $paymentMethod = null, \StructType\BooleanValue $paySeparately = null, \StructType\BooleanValue $printOrders = null, \StructType\StringValue $receiptAction = null, \StructType\StringValue $receivingBranch = null, \StructType\BooleanValue $remittanceAddressSameasMain = null, \StructType\Contact $remittanceContact = null, \StructType\BooleanValue $remittanceContactSameasMain = null, \StructType\BooleanValue $sendOrdersbyEmail = null, \StructType\BooleanValue $shippersContactSameasMain = null, \StructType\BooleanValue $shippingAddressSameasMain = null, \StructType\Contact $shippingContact = null, \StructType\StringValue $shippingTerms = null, \StructType\StringValue $shipVia = null, \StructType\StringValue $status = null, \StructType\StringValue $taxCalculationMode = null, \StructType\StringValue $taxRegistrationID = null, \StructType\StringValue $taxZone = null, \StructType\StringValue $terms = null, \StructType\DecimalValue $thresholdReceipt = null, \StructType\StringValue $vendorClass = null, \StructType\StringValue $vendorID = null, \StructType\BooleanValue $vendorIsLaborUnion = null, \StructType\BooleanValue $vendorIsTaxAgency = null, \StructType\StringValue $vendorName = null, \StructType\StringValue $warehouse = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setAPAccount($aPAccount)
            ->setAPSubaccount($aPSubaccount)
            ->setAttributes($attributes)
            ->setCashAccount($cashAccount)
            ->setContacts($contacts)
            ->setCreatedDateTime($createdDateTime)
            ->setCurrencyID($currencyID)
            ->setCurrencyRateType($currencyRateType)
            ->setEnableCurrencyOverride($enableCurrencyOverride)
            ->setEnableRateOverride($enableRateOverride)
            ->setF1099Box($f1099Box)
            ->setF1099Vendor($f1099Vendor)
            ->setFATCA($fATCA)
            ->setFOBPoint($fOBPoint)
            ->setForeignEntity($foreignEntity)
            ->setLandedCostVendor($landedCostVendor)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLeadTimedays($leadTimedays)
            ->setLocationName($locationName)
            ->setMainContact($mainContact)
            ->setMaxReceipt($maxReceipt)
            ->setMinReceipt($minReceipt)
            ->setParentAccount($parentAccount)
            ->setPaymentBy($paymentBy)
            ->setPaymentInstructions($paymentInstructions)
            ->setPaymentLeadTimedays($paymentLeadTimedays)
            ->setPaymentMethod($paymentMethod)
            ->setPaySeparately($paySeparately)
            ->setPrintOrders($printOrders)
            ->setReceiptAction($receiptAction)
            ->setReceivingBranch($receivingBranch)
            ->setRemittanceAddressSameasMain($remittanceAddressSameasMain)
            ->setRemittanceContact($remittanceContact)
            ->setRemittanceContactSameasMain($remittanceContactSameasMain)
            ->setSendOrdersbyEmail($sendOrdersbyEmail)
            ->setShippersContactSameasMain($shippersContactSameasMain)
            ->setShippingAddressSameasMain($shippingAddressSameasMain)
            ->setShippingContact($shippingContact)
            ->setShippingTerms($shippingTerms)
            ->setShipVia($shipVia)
            ->setStatus($status)
            ->setTaxCalculationMode($taxCalculationMode)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setTerms($terms)
            ->setThresholdReceipt($thresholdReceipt)
            ->setVendorClass($vendorClass)
            ->setVendorID($vendorID)
            ->setVendorIsLaborUnion($vendorIsLaborUnion)
            ->setVendorIsTaxAgency($vendorIsTaxAgency)
            ->setVendorName($vendorName)
            ->setWarehouse($warehouse);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountRef
     * @return \StructType\Vendor
     */
    public function setAccountRef(\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get APAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAPAccount()
    {
        return isset($this->APAccount) ? $this->APAccount : null;
    }
    /**
     * Set APAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $aPAccount
     * @return \StructType\Vendor
     */
    public function setAPAccount(\StructType\StringValue $aPAccount = null)
    {
        if (is_null($aPAccount) || (is_array($aPAccount) && empty($aPAccount))) {
            unset($this->APAccount);
        } else {
            $this->APAccount = $aPAccount;
        }
        return $this;
    }
    /**
     * Get APSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAPSubaccount()
    {
        return isset($this->APSubaccount) ? $this->APSubaccount : null;
    }
    /**
     * Set APSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $aPSubaccount
     * @return \StructType\Vendor
     */
    public function setAPSubaccount(\StructType\StringValue $aPSubaccount = null)
    {
        if (is_null($aPSubaccount) || (is_array($aPSubaccount) && empty($aPSubaccount))) {
            unset($this->APSubaccount);
        } else {
            $this->APSubaccount = $aPSubaccount;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attributes $attributes
     * @return \StructType\Vendor
     */
    public function setAttributes(\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cashAccount
     * @return \StructType\Vendor
     */
    public function setCashAccount(\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contacts $contacts
     * @return \StructType\Vendor
     */
    public function setContacts(\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\Vendor
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\Vendor
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyRateType()
    {
        return isset($this->CurrencyRateType) ? $this->CurrencyRateType : null;
    }
    /**
     * Set CurrencyRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyRateType
     * @return \StructType\Vendor
     */
    public function setCurrencyRateType(\StructType\StringValue $currencyRateType = null)
    {
        if (is_null($currencyRateType) || (is_array($currencyRateType) && empty($currencyRateType))) {
            unset($this->CurrencyRateType);
        } else {
            $this->CurrencyRateType = $currencyRateType;
        }
        return $this;
    }
    /**
     * Get EnableCurrencyOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getEnableCurrencyOverride()
    {
        return isset($this->EnableCurrencyOverride) ? $this->EnableCurrencyOverride : null;
    }
    /**
     * Set EnableCurrencyOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $enableCurrencyOverride
     * @return \StructType\Vendor
     */
    public function setEnableCurrencyOverride(\StructType\BooleanValue $enableCurrencyOverride = null)
    {
        if (is_null($enableCurrencyOverride) || (is_array($enableCurrencyOverride) && empty($enableCurrencyOverride))) {
            unset($this->EnableCurrencyOverride);
        } else {
            $this->EnableCurrencyOverride = $enableCurrencyOverride;
        }
        return $this;
    }
    /**
     * Get EnableRateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getEnableRateOverride()
    {
        return isset($this->EnableRateOverride) ? $this->EnableRateOverride : null;
    }
    /**
     * Set EnableRateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $enableRateOverride
     * @return \StructType\Vendor
     */
    public function setEnableRateOverride(\StructType\BooleanValue $enableRateOverride = null)
    {
        if (is_null($enableRateOverride) || (is_array($enableRateOverride) && empty($enableRateOverride))) {
            unset($this->EnableRateOverride);
        } else {
            $this->EnableRateOverride = $enableRateOverride;
        }
        return $this;
    }
    /**
     * Get F1099Box value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getF1099Box()
    {
        return isset($this->F1099Box) ? $this->F1099Box : null;
    }
    /**
     * Set F1099Box value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $f1099Box
     * @return \StructType\Vendor
     */
    public function setF1099Box(\StructType\StringValue $f1099Box = null)
    {
        if (is_null($f1099Box) || (is_array($f1099Box) && empty($f1099Box))) {
            unset($this->F1099Box);
        } else {
            $this->F1099Box = $f1099Box;
        }
        return $this;
    }
    /**
     * Get F1099Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getF1099Vendor()
    {
        return isset($this->F1099Vendor) ? $this->F1099Vendor : null;
    }
    /**
     * Set F1099Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $f1099Vendor
     * @return \StructType\Vendor
     */
    public function setF1099Vendor(\StructType\BooleanValue $f1099Vendor = null)
    {
        if (is_null($f1099Vendor) || (is_array($f1099Vendor) && empty($f1099Vendor))) {
            unset($this->F1099Vendor);
        } else {
            $this->F1099Vendor = $f1099Vendor;
        }
        return $this;
    }
    /**
     * Get FATCA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getFATCA()
    {
        return isset($this->FATCA) ? $this->FATCA : null;
    }
    /**
     * Set FATCA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $fATCA
     * @return \StructType\Vendor
     */
    public function setFATCA(\StructType\BooleanValue $fATCA = null)
    {
        if (is_null($fATCA) || (is_array($fATCA) && empty($fATCA))) {
            unset($this->FATCA);
        } else {
            $this->FATCA = $fATCA;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $fOBPoint
     * @return \StructType\Vendor
     */
    public function setFOBPoint(\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get ForeignEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getForeignEntity()
    {
        return isset($this->ForeignEntity) ? $this->ForeignEntity : null;
    }
    /**
     * Set ForeignEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $foreignEntity
     * @return \StructType\Vendor
     */
    public function setForeignEntity(\StructType\BooleanValue $foreignEntity = null)
    {
        if (is_null($foreignEntity) || (is_array($foreignEntity) && empty($foreignEntity))) {
            unset($this->ForeignEntity);
        } else {
            $this->ForeignEntity = $foreignEntity;
        }
        return $this;
    }
    /**
     * Get LandedCostVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getLandedCostVendor()
    {
        return isset($this->LandedCostVendor) ? $this->LandedCostVendor : null;
    }
    /**
     * Set LandedCostVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $landedCostVendor
     * @return \StructType\Vendor
     */
    public function setLandedCostVendor(\StructType\BooleanValue $landedCostVendor = null)
    {
        if (is_null($landedCostVendor) || (is_array($landedCostVendor) && empty($landedCostVendor))) {
            unset($this->LandedCostVendor);
        } else {
            $this->LandedCostVendor = $landedCostVendor;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\Vendor
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getLeadTimedays()
    {
        return isset($this->LeadTimedays) ? $this->LeadTimedays : null;
    }
    /**
     * Set LeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $leadTimedays
     * @return \StructType\Vendor
     */
    public function setLeadTimedays(\StructType\ShortValue $leadTimedays = null)
    {
        if (is_null($leadTimedays) || (is_array($leadTimedays) && empty($leadTimedays))) {
            unset($this->LeadTimedays);
        } else {
            $this->LeadTimedays = $leadTimedays;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationName
     * @return \StructType\Vendor
     */
    public function setLocationName(\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $mainContact
     * @return \StructType\Vendor
     */
    public function setMainContact(\StructType\Contact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get MaxReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxReceipt()
    {
        return isset($this->MaxReceipt) ? $this->MaxReceipt : null;
    }
    /**
     * Set MaxReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxReceipt
     * @return \StructType\Vendor
     */
    public function setMaxReceipt(\StructType\DecimalValue $maxReceipt = null)
    {
        if (is_null($maxReceipt) || (is_array($maxReceipt) && empty($maxReceipt))) {
            unset($this->MaxReceipt);
        } else {
            $this->MaxReceipt = $maxReceipt;
        }
        return $this;
    }
    /**
     * Get MinReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMinReceipt()
    {
        return isset($this->MinReceipt) ? $this->MinReceipt : null;
    }
    /**
     * Set MinReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $minReceipt
     * @return \StructType\Vendor
     */
    public function setMinReceipt(\StructType\DecimalValue $minReceipt = null)
    {
        if (is_null($minReceipt) || (is_array($minReceipt) && empty($minReceipt))) {
            unset($this->MinReceipt);
        } else {
            $this->MinReceipt = $minReceipt;
        }
        return $this;
    }
    /**
     * Get ParentAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getParentAccount()
    {
        return isset($this->ParentAccount) ? $this->ParentAccount : null;
    }
    /**
     * Set ParentAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $parentAccount
     * @return \StructType\Vendor
     */
    public function setParentAccount(\StructType\StringValue $parentAccount = null)
    {
        if (is_null($parentAccount) || (is_array($parentAccount) && empty($parentAccount))) {
            unset($this->ParentAccount);
        } else {
            $this->ParentAccount = $parentAccount;
        }
        return $this;
    }
    /**
     * Get PaymentBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentBy()
    {
        return isset($this->PaymentBy) ? $this->PaymentBy : null;
    }
    /**
     * Set PaymentBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentBy
     * @return \StructType\Vendor
     */
    public function setPaymentBy(\StructType\StringValue $paymentBy = null)
    {
        if (is_null($paymentBy) || (is_array($paymentBy) && empty($paymentBy))) {
            unset($this->PaymentBy);
        } else {
            $this->PaymentBy = $paymentBy;
        }
        return $this;
    }
    /**
     * Get PaymentInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentInstructions|null
     */
    public function getPaymentInstructions()
    {
        return isset($this->PaymentInstructions) ? $this->PaymentInstructions : null;
    }
    /**
     * Set PaymentInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PaymentInstructions $paymentInstructions
     * @return \StructType\Vendor
     */
    public function setPaymentInstructions(\StructType\PaymentInstructions $paymentInstructions = null)
    {
        if (is_null($paymentInstructions) || (is_array($paymentInstructions) && empty($paymentInstructions))) {
            unset($this->PaymentInstructions);
        } else {
            $this->PaymentInstructions = $paymentInstructions;
        }
        return $this;
    }
    /**
     * Get PaymentLeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getPaymentLeadTimedays()
    {
        return isset($this->PaymentLeadTimedays) ? $this->PaymentLeadTimedays : null;
    }
    /**
     * Set PaymentLeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $paymentLeadTimedays
     * @return \StructType\Vendor
     */
    public function setPaymentLeadTimedays(\StructType\ShortValue $paymentLeadTimedays = null)
    {
        if (is_null($paymentLeadTimedays) || (is_array($paymentLeadTimedays) && empty($paymentLeadTimedays))) {
            unset($this->PaymentLeadTimedays);
        } else {
            $this->PaymentLeadTimedays = $paymentLeadTimedays;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\Vendor
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaySeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getPaySeparately()
    {
        return isset($this->PaySeparately) ? $this->PaySeparately : null;
    }
    /**
     * Set PaySeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $paySeparately
     * @return \StructType\Vendor
     */
    public function setPaySeparately(\StructType\BooleanValue $paySeparately = null)
    {
        if (is_null($paySeparately) || (is_array($paySeparately) && empty($paySeparately))) {
            unset($this->PaySeparately);
        } else {
            $this->PaySeparately = $paySeparately;
        }
        return $this;
    }
    /**
     * Get PrintOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getPrintOrders()
    {
        return isset($this->PrintOrders) ? $this->PrintOrders : null;
    }
    /**
     * Set PrintOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $printOrders
     * @return \StructType\Vendor
     */
    public function setPrintOrders(\StructType\BooleanValue $printOrders = null)
    {
        if (is_null($printOrders) || (is_array($printOrders) && empty($printOrders))) {
            unset($this->PrintOrders);
        } else {
            $this->PrintOrders = $printOrders;
        }
        return $this;
    }
    /**
     * Get ReceiptAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReceiptAction()
    {
        return isset($this->ReceiptAction) ? $this->ReceiptAction : null;
    }
    /**
     * Set ReceiptAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $receiptAction
     * @return \StructType\Vendor
     */
    public function setReceiptAction(\StructType\StringValue $receiptAction = null)
    {
        if (is_null($receiptAction) || (is_array($receiptAction) && empty($receiptAction))) {
            unset($this->ReceiptAction);
        } else {
            $this->ReceiptAction = $receiptAction;
        }
        return $this;
    }
    /**
     * Get ReceivingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReceivingBranch()
    {
        return isset($this->ReceivingBranch) ? $this->ReceivingBranch : null;
    }
    /**
     * Set ReceivingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $receivingBranch
     * @return \StructType\Vendor
     */
    public function setReceivingBranch(\StructType\StringValue $receivingBranch = null)
    {
        if (is_null($receivingBranch) || (is_array($receivingBranch) && empty($receivingBranch))) {
            unset($this->ReceivingBranch);
        } else {
            $this->ReceivingBranch = $receivingBranch;
        }
        return $this;
    }
    /**
     * Get RemittanceAddressSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRemittanceAddressSameasMain()
    {
        return isset($this->RemittanceAddressSameasMain) ? $this->RemittanceAddressSameasMain : null;
    }
    /**
     * Set RemittanceAddressSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $remittanceAddressSameasMain
     * @return \StructType\Vendor
     */
    public function setRemittanceAddressSameasMain(\StructType\BooleanValue $remittanceAddressSameasMain = null)
    {
        if (is_null($remittanceAddressSameasMain) || (is_array($remittanceAddressSameasMain) && empty($remittanceAddressSameasMain))) {
            unset($this->RemittanceAddressSameasMain);
        } else {
            $this->RemittanceAddressSameasMain = $remittanceAddressSameasMain;
        }
        return $this;
    }
    /**
     * Get RemittanceContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getRemittanceContact()
    {
        return isset($this->RemittanceContact) ? $this->RemittanceContact : null;
    }
    /**
     * Set RemittanceContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $remittanceContact
     * @return \StructType\Vendor
     */
    public function setRemittanceContact(\StructType\Contact $remittanceContact = null)
    {
        if (is_null($remittanceContact) || (is_array($remittanceContact) && empty($remittanceContact))) {
            unset($this->RemittanceContact);
        } else {
            $this->RemittanceContact = $remittanceContact;
        }
        return $this;
    }
    /**
     * Get RemittanceContactSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRemittanceContactSameasMain()
    {
        return isset($this->RemittanceContactSameasMain) ? $this->RemittanceContactSameasMain : null;
    }
    /**
     * Set RemittanceContactSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $remittanceContactSameasMain
     * @return \StructType\Vendor
     */
    public function setRemittanceContactSameasMain(\StructType\BooleanValue $remittanceContactSameasMain = null)
    {
        if (is_null($remittanceContactSameasMain) || (is_array($remittanceContactSameasMain) && empty($remittanceContactSameasMain))) {
            unset($this->RemittanceContactSameasMain);
        } else {
            $this->RemittanceContactSameasMain = $remittanceContactSameasMain;
        }
        return $this;
    }
    /**
     * Get SendOrdersbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSendOrdersbyEmail()
    {
        return isset($this->SendOrdersbyEmail) ? $this->SendOrdersbyEmail : null;
    }
    /**
     * Set SendOrdersbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $sendOrdersbyEmail
     * @return \StructType\Vendor
     */
    public function setSendOrdersbyEmail(\StructType\BooleanValue $sendOrdersbyEmail = null)
    {
        if (is_null($sendOrdersbyEmail) || (is_array($sendOrdersbyEmail) && empty($sendOrdersbyEmail))) {
            unset($this->SendOrdersbyEmail);
        } else {
            $this->SendOrdersbyEmail = $sendOrdersbyEmail;
        }
        return $this;
    }
    /**
     * Get ShippersContactSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShippersContactSameasMain()
    {
        return isset($this->ShippersContactSameasMain) ? $this->ShippersContactSameasMain : null;
    }
    /**
     * Set ShippersContactSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shippersContactSameasMain
     * @return \StructType\Vendor
     */
    public function setShippersContactSameasMain(\StructType\BooleanValue $shippersContactSameasMain = null)
    {
        if (is_null($shippersContactSameasMain) || (is_array($shippersContactSameasMain) && empty($shippersContactSameasMain))) {
            unset($this->ShippersContactSameasMain);
        } else {
            $this->ShippersContactSameasMain = $shippersContactSameasMain;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShippingAddressSameasMain()
    {
        return isset($this->ShippingAddressSameasMain) ? $this->ShippingAddressSameasMain : null;
    }
    /**
     * Set ShippingAddressSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shippingAddressSameasMain
     * @return \StructType\Vendor
     */
    public function setShippingAddressSameasMain(\StructType\BooleanValue $shippingAddressSameasMain = null)
    {
        if (is_null($shippingAddressSameasMain) || (is_array($shippingAddressSameasMain) && empty($shippingAddressSameasMain))) {
            unset($this->ShippingAddressSameasMain);
        } else {
            $this->ShippingAddressSameasMain = $shippingAddressSameasMain;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $shippingContact
     * @return \StructType\Vendor
     */
    public function setShippingContact(\StructType\Contact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingTerms
     * @return \StructType\Vendor
     */
    public function setShippingTerms(\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipVia
     * @return \StructType\Vendor
     */
    public function setShipVia(\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Vendor
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxCalculationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCalculationMode()
    {
        return isset($this->TaxCalculationMode) ? $this->TaxCalculationMode : null;
    }
    /**
     * Set TaxCalculationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCalculationMode
     * @return \StructType\Vendor
     */
    public function setTaxCalculationMode(\StructType\StringValue $taxCalculationMode = null)
    {
        if (is_null($taxCalculationMode) || (is_array($taxCalculationMode) && empty($taxCalculationMode))) {
            unset($this->TaxCalculationMode);
        } else {
            $this->TaxCalculationMode = $taxCalculationMode;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxRegistrationID
     * @return \StructType\Vendor
     */
    public function setTaxRegistrationID(\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxZone
     * @return \StructType\Vendor
     */
    public function setTaxZone(\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $terms
     * @return \StructType\Vendor
     */
    public function setTerms(\StructType\StringValue $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get ThresholdReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getThresholdReceipt()
    {
        return isset($this->ThresholdReceipt) ? $this->ThresholdReceipt : null;
    }
    /**
     * Set ThresholdReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $thresholdReceipt
     * @return \StructType\Vendor
     */
    public function setThresholdReceipt(\StructType\DecimalValue $thresholdReceipt = null)
    {
        if (is_null($thresholdReceipt) || (is_array($thresholdReceipt) && empty($thresholdReceipt))) {
            unset($this->ThresholdReceipt);
        } else {
            $this->ThresholdReceipt = $thresholdReceipt;
        }
        return $this;
    }
    /**
     * Get VendorClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorClass()
    {
        return isset($this->VendorClass) ? $this->VendorClass : null;
    }
    /**
     * Set VendorClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorClass
     * @return \StructType\Vendor
     */
    public function setVendorClass(\StructType\StringValue $vendorClass = null)
    {
        if (is_null($vendorClass) || (is_array($vendorClass) && empty($vendorClass))) {
            unset($this->VendorClass);
        } else {
            $this->VendorClass = $vendorClass;
        }
        return $this;
    }
    /**
     * Get VendorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorID()
    {
        return isset($this->VendorID) ? $this->VendorID : null;
    }
    /**
     * Set VendorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorID
     * @return \StructType\Vendor
     */
    public function setVendorID(\StructType\StringValue $vendorID = null)
    {
        if (is_null($vendorID) || (is_array($vendorID) && empty($vendorID))) {
            unset($this->VendorID);
        } else {
            $this->VendorID = $vendorID;
        }
        return $this;
    }
    /**
     * Get VendorIsLaborUnion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getVendorIsLaborUnion()
    {
        return isset($this->VendorIsLaborUnion) ? $this->VendorIsLaborUnion : null;
    }
    /**
     * Set VendorIsLaborUnion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $vendorIsLaborUnion
     * @return \StructType\Vendor
     */
    public function setVendorIsLaborUnion(\StructType\BooleanValue $vendorIsLaborUnion = null)
    {
        if (is_null($vendorIsLaborUnion) || (is_array($vendorIsLaborUnion) && empty($vendorIsLaborUnion))) {
            unset($this->VendorIsLaborUnion);
        } else {
            $this->VendorIsLaborUnion = $vendorIsLaborUnion;
        }
        return $this;
    }
    /**
     * Get VendorIsTaxAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getVendorIsTaxAgency()
    {
        return isset($this->VendorIsTaxAgency) ? $this->VendorIsTaxAgency : null;
    }
    /**
     * Set VendorIsTaxAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $vendorIsTaxAgency
     * @return \StructType\Vendor
     */
    public function setVendorIsTaxAgency(\StructType\BooleanValue $vendorIsTaxAgency = null)
    {
        if (is_null($vendorIsTaxAgency) || (is_array($vendorIsTaxAgency) && empty($vendorIsTaxAgency))) {
            unset($this->VendorIsTaxAgency);
        } else {
            $this->VendorIsTaxAgency = $vendorIsTaxAgency;
        }
        return $this;
    }
    /**
     * Get VendorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorName()
    {
        return isset($this->VendorName) ? $this->VendorName : null;
    }
    /**
     * Set VendorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorName
     * @return \StructType\Vendor
     */
    public function setVendorName(\StructType\StringValue $vendorName = null)
    {
        if (is_null($vendorName) || (is_array($vendorName) && empty($vendorName))) {
            unset($this->VendorName);
        } else {
            $this->VendorName = $vendorName;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouse
     * @return \StructType\Vendor
     */
    public function setWarehouse(\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
}
