<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceTotals StructType
 * @subpackage Structs
 */
class SalesInvoiceTotals extends Entity
{
    /**
     * The DiscountTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountTotal;
    /**
     * The Freight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Freight;
    /**
     * The LineTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LineTotal;
    /**
     * The MiscTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MiscTotal;
    /**
     * The PaymentTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PaymentTotal;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * Constructor method for SalesInvoiceTotals
     * @uses SalesInvoiceTotals::setDiscountTotal()
     * @uses SalesInvoiceTotals::setFreight()
     * @uses SalesInvoiceTotals::setLineTotal()
     * @uses SalesInvoiceTotals::setMiscTotal()
     * @uses SalesInvoiceTotals::setPaymentTotal()
     * @uses SalesInvoiceTotals::setTaxTotal()
     * @param \StructType\DecimalValue $discountTotal
     * @param \StructType\DecimalValue $freight
     * @param \StructType\DecimalValue $lineTotal
     * @param \StructType\DecimalValue $miscTotal
     * @param \StructType\DecimalValue $paymentTotal
     * @param \StructType\DecimalValue $taxTotal
     */
    public function __construct(\StructType\DecimalValue $discountTotal = null, \StructType\DecimalValue $freight = null, \StructType\DecimalValue $lineTotal = null, \StructType\DecimalValue $miscTotal = null, \StructType\DecimalValue $paymentTotal = null, \StructType\DecimalValue $taxTotal = null)
    {
        $this
            ->setDiscountTotal($discountTotal)
            ->setFreight($freight)
            ->setLineTotal($lineTotal)
            ->setMiscTotal($miscTotal)
            ->setPaymentTotal($paymentTotal)
            ->setTaxTotal($taxTotal);
    }
    /**
     * Get DiscountTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountTotal()
    {
        return isset($this->DiscountTotal) ? $this->DiscountTotal : null;
    }
    /**
     * Set DiscountTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountTotal
     * @return \StructType\SalesInvoiceTotals
     */
    public function setDiscountTotal(\StructType\DecimalValue $discountTotal = null)
    {
        if (is_null($discountTotal) || (is_array($discountTotal) && empty($discountTotal))) {
            unset($this->DiscountTotal);
        } else {
            $this->DiscountTotal = $discountTotal;
        }
        return $this;
    }
    /**
     * Get Freight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreight()
    {
        return isset($this->Freight) ? $this->Freight : null;
    }
    /**
     * Set Freight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freight
     * @return \StructType\SalesInvoiceTotals
     */
    public function setFreight(\StructType\DecimalValue $freight = null)
    {
        if (is_null($freight) || (is_array($freight) && empty($freight))) {
            unset($this->Freight);
        } else {
            $this->Freight = $freight;
        }
        return $this;
    }
    /**
     * Get LineTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLineTotal()
    {
        return isset($this->LineTotal) ? $this->LineTotal : null;
    }
    /**
     * Set LineTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lineTotal
     * @return \StructType\SalesInvoiceTotals
     */
    public function setLineTotal(\StructType\DecimalValue $lineTotal = null)
    {
        if (is_null($lineTotal) || (is_array($lineTotal) && empty($lineTotal))) {
            unset($this->LineTotal);
        } else {
            $this->LineTotal = $lineTotal;
        }
        return $this;
    }
    /**
     * Get MiscTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMiscTotal()
    {
        return isset($this->MiscTotal) ? $this->MiscTotal : null;
    }
    /**
     * Set MiscTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $miscTotal
     * @return \StructType\SalesInvoiceTotals
     */
    public function setMiscTotal(\StructType\DecimalValue $miscTotal = null)
    {
        if (is_null($miscTotal) || (is_array($miscTotal) && empty($miscTotal))) {
            unset($this->MiscTotal);
        } else {
            $this->MiscTotal = $miscTotal;
        }
        return $this;
    }
    /**
     * Get PaymentTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPaymentTotal()
    {
        return isset($this->PaymentTotal) ? $this->PaymentTotal : null;
    }
    /**
     * Set PaymentTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $paymentTotal
     * @return \StructType\SalesInvoiceTotals
     */
    public function setPaymentTotal(\StructType\DecimalValue $paymentTotal = null)
    {
        if (is_null($paymentTotal) || (is_array($paymentTotal) && empty($paymentTotal))) {
            unset($this->PaymentTotal);
        } else {
            $this->PaymentTotal = $paymentTotal;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxTotal
     * @return \StructType\SalesInvoiceTotals
     */
    public function setTaxTotal(\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
}
