<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTemplate StructType
 * @subpackage Structs
 */
class ProjectTemplate extends Entity
{
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attributes
     */
    public $Attributes;
    /**
     * The BillingAndAllocationSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectBillingAndAllocationSettings
     */
    public $BillingAndAllocationSettings;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Employees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Employees
     */
    public $Employees;
    /**
     * The Equipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Equipments
     */
    public $Equipments;
    /**
     * The GLAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectGLAccount
     */
    public $GLAccounts;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The ProjectProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectProperties
     */
    public $ProjectProperties;
    /**
     * The ProjectTemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTemplateID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The VisibilitySettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VisibilitySettings
     */
    public $VisibilitySettings;
    /**
     * Constructor method for ProjectTemplate
     * @uses ProjectTemplate::setAttributes()
     * @uses ProjectTemplate::setBillingAndAllocationSettings()
     * @uses ProjectTemplate::setDescription()
     * @uses ProjectTemplate::setEmployees()
     * @uses ProjectTemplate::setEquipments()
     * @uses ProjectTemplate::setGLAccounts()
     * @uses ProjectTemplate::setLastModifiedDateTime()
     * @uses ProjectTemplate::setProjectProperties()
     * @uses ProjectTemplate::setProjectTemplateID()
     * @uses ProjectTemplate::setStatus()
     * @uses ProjectTemplate::setVisibilitySettings()
     * @param \StructType\Attributes $attributes
     * @param \StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings
     * @param \StructType\StringValue $description
     * @param \StructType\Employees $employees
     * @param \StructType\Equipments $equipments
     * @param \StructType\ProjectGLAccount $gLAccounts
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\ProjectProperties $projectProperties
     * @param \StructType\StringValue $projectTemplateID
     * @param \StructType\StringValue $status
     * @param \StructType\VisibilitySettings $visibilitySettings
     */
    public function __construct(\StructType\Attributes $attributes = null, \StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings = null, \StructType\StringValue $description = null, \StructType\Employees $employees = null, \StructType\Equipments $equipments = null, \StructType\ProjectGLAccount $gLAccounts = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\ProjectProperties $projectProperties = null, \StructType\StringValue $projectTemplateID = null, \StructType\StringValue $status = null, \StructType\VisibilitySettings $visibilitySettings = null)
    {
        $this
            ->setAttributes($attributes)
            ->setBillingAndAllocationSettings($billingAndAllocationSettings)
            ->setDescription($description)
            ->setEmployees($employees)
            ->setEquipments($equipments)
            ->setGLAccounts($gLAccounts)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setProjectProperties($projectProperties)
            ->setProjectTemplateID($projectTemplateID)
            ->setStatus($status)
            ->setVisibilitySettings($visibilitySettings);
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attributes $attributes
     * @return \StructType\ProjectTemplate
     */
    public function setAttributes(\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get BillingAndAllocationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectBillingAndAllocationSettings|null
     */
    public function getBillingAndAllocationSettings()
    {
        return isset($this->BillingAndAllocationSettings) ? $this->BillingAndAllocationSettings : null;
    }
    /**
     * Set BillingAndAllocationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings
     * @return \StructType\ProjectTemplate
     */
    public function setBillingAndAllocationSettings(\StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings = null)
    {
        if (is_null($billingAndAllocationSettings) || (is_array($billingAndAllocationSettings) && empty($billingAndAllocationSettings))) {
            unset($this->BillingAndAllocationSettings);
        } else {
            $this->BillingAndAllocationSettings = $billingAndAllocationSettings;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProjectTemplate
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Employees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Employees|null
     */
    public function getEmployees()
    {
        return isset($this->Employees) ? $this->Employees : null;
    }
    /**
     * Set Employees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Employees $employees
     * @return \StructType\ProjectTemplate
     */
    public function setEmployees(\StructType\Employees $employees = null)
    {
        if (is_null($employees) || (is_array($employees) && empty($employees))) {
            unset($this->Employees);
        } else {
            $this->Employees = $employees;
        }
        return $this;
    }
    /**
     * Get Equipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Equipments|null
     */
    public function getEquipments()
    {
        return isset($this->Equipments) ? $this->Equipments : null;
    }
    /**
     * Set Equipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Equipments $equipments
     * @return \StructType\ProjectTemplate
     */
    public function setEquipments(\StructType\Equipments $equipments = null)
    {
        if (is_null($equipments) || (is_array($equipments) && empty($equipments))) {
            unset($this->Equipments);
        } else {
            $this->Equipments = $equipments;
        }
        return $this;
    }
    /**
     * Get GLAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectGLAccount|null
     */
    public function getGLAccounts()
    {
        return isset($this->GLAccounts) ? $this->GLAccounts : null;
    }
    /**
     * Set GLAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectGLAccount $gLAccounts
     * @return \StructType\ProjectTemplate
     */
    public function setGLAccounts(\StructType\ProjectGLAccount $gLAccounts = null)
    {
        if (is_null($gLAccounts) || (is_array($gLAccounts) && empty($gLAccounts))) {
            unset($this->GLAccounts);
        } else {
            $this->GLAccounts = $gLAccounts;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ProjectTemplate
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get ProjectProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectProperties|null
     */
    public function getProjectProperties()
    {
        return isset($this->ProjectProperties) ? $this->ProjectProperties : null;
    }
    /**
     * Set ProjectProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectProperties $projectProperties
     * @return \StructType\ProjectTemplate
     */
    public function setProjectProperties(\StructType\ProjectProperties $projectProperties = null)
    {
        if (is_null($projectProperties) || (is_array($projectProperties) && empty($projectProperties))) {
            unset($this->ProjectProperties);
        } else {
            $this->ProjectProperties = $projectProperties;
        }
        return $this;
    }
    /**
     * Get ProjectTemplateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTemplateID()
    {
        return isset($this->ProjectTemplateID) ? $this->ProjectTemplateID : null;
    }
    /**
     * Set ProjectTemplateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTemplateID
     * @return \StructType\ProjectTemplate
     */
    public function setProjectTemplateID(\StructType\StringValue $projectTemplateID = null)
    {
        if (is_null($projectTemplateID) || (is_array($projectTemplateID) && empty($projectTemplateID))) {
            unset($this->ProjectTemplateID);
        } else {
            $this->ProjectTemplateID = $projectTemplateID;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\ProjectTemplate
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get VisibilitySettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VisibilitySettings|null
     */
    public function getVisibilitySettings()
    {
        return isset($this->VisibilitySettings) ? $this->VisibilitySettings : null;
    }
    /**
     * Set VisibilitySettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VisibilitySettings $visibilitySettings
     * @return \StructType\ProjectTemplate
     */
    public function setVisibilitySettings(\StructType\VisibilitySettings $visibilitySettings = null)
    {
        if (is_null($visibilitySettings) || (is_array($visibilitySettings) && empty($visibilitySettings))) {
            unset($this->VisibilitySettings);
        } else {
            $this->VisibilitySettings = $visibilitySettings;
        }
        return $this;
    }
}
