<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTask StructType
 * @subpackage Structs
 */
class ProjectTask extends Entity
{
    /**
     * The ActivityHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityHistory
     */
    public $ActivityHistory;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attribute
     */
    public $Attribute;
    /**
     * The BillingAndAllocationSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectTaskBillingAndAllocationSettings
     */
    public $BillingAndAllocationSettings;
    /**
     * The CRMLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectTaskToCRMLink
     */
    public $CRMLink;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Default;
    /**
     * The DefaultValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectTaskDefaultValues
     */
    public $DefaultValues;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Properties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectTaskProperties
     */
    public $Properties;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The VisibilitySettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VisibilitySettings
     */
    public $VisibilitySettings;
    /**
     * Constructor method for ProjectTask
     * @uses ProjectTask::setActivityHistory()
     * @uses ProjectTask::setAttribute()
     * @uses ProjectTask::setBillingAndAllocationSettings()
     * @uses ProjectTask::setCRMLink()
     * @uses ProjectTask::setDefault()
     * @uses ProjectTask::setDefaultValues()
     * @uses ProjectTask::setDescription()
     * @uses ProjectTask::setExternalRefNbr()
     * @uses ProjectTask::setLastModifiedDateTime()
     * @uses ProjectTask::setProjectID()
     * @uses ProjectTask::setProjectTaskID()
     * @uses ProjectTask::setProperties()
     * @uses ProjectTask::setStatus()
     * @uses ProjectTask::setVisibilitySettings()
     * @param \StructType\ActivityHistory $activityHistory
     * @param \StructType\Attribute $attribute
     * @param \StructType\ProjectTaskBillingAndAllocationSettings $billingAndAllocationSettings
     * @param \StructType\ProjectTaskToCRMLink $cRMLink
     * @param \StructType\BooleanValue $default
     * @param \StructType\ProjectTaskDefaultValues $defaultValues
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $externalRefNbr
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $projectID
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\ProjectTaskProperties $properties
     * @param \StructType\StringValue $status
     * @param \StructType\VisibilitySettings $visibilitySettings
     */
    public function __construct(\StructType\ActivityHistory $activityHistory = null, \StructType\Attribute $attribute = null, \StructType\ProjectTaskBillingAndAllocationSettings $billingAndAllocationSettings = null, \StructType\ProjectTaskToCRMLink $cRMLink = null, \StructType\BooleanValue $default = null, \StructType\ProjectTaskDefaultValues $defaultValues = null, \StructType\StringValue $description = null, \StructType\StringValue $externalRefNbr = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $projectID = null, \StructType\StringValue $projectTaskID = null, \StructType\ProjectTaskProperties $properties = null, \StructType\StringValue $status = null, \StructType\VisibilitySettings $visibilitySettings = null)
    {
        $this
            ->setActivityHistory($activityHistory)
            ->setAttribute($attribute)
            ->setBillingAndAllocationSettings($billingAndAllocationSettings)
            ->setCRMLink($cRMLink)
            ->setDefault($default)
            ->setDefaultValues($defaultValues)
            ->setDescription($description)
            ->setExternalRefNbr($externalRefNbr)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setProperties($properties)
            ->setStatus($status)
            ->setVisibilitySettings($visibilitySettings);
    }
    /**
     * Get ActivityHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityHistory|null
     */
    public function getActivityHistory()
    {
        return isset($this->ActivityHistory) ? $this->ActivityHistory : null;
    }
    /**
     * Set ActivityHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ActivityHistory $activityHistory
     * @return \StructType\ProjectTask
     */
    public function setActivityHistory(\StructType\ActivityHistory $activityHistory = null)
    {
        if (is_null($activityHistory) || (is_array($activityHistory) && empty($activityHistory))) {
            unset($this->ActivityHistory);
        } else {
            $this->ActivityHistory = $activityHistory;
        }
        return $this;
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attribute|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attribute $attribute
     * @return \StructType\ProjectTask
     */
    public function setAttribute(\StructType\Attribute $attribute = null)
    {
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Get BillingAndAllocationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectTaskBillingAndAllocationSettings|null
     */
    public function getBillingAndAllocationSettings()
    {
        return isset($this->BillingAndAllocationSettings) ? $this->BillingAndAllocationSettings : null;
    }
    /**
     * Set BillingAndAllocationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectTaskBillingAndAllocationSettings $billingAndAllocationSettings
     * @return \StructType\ProjectTask
     */
    public function setBillingAndAllocationSettings(\StructType\ProjectTaskBillingAndAllocationSettings $billingAndAllocationSettings = null)
    {
        if (is_null($billingAndAllocationSettings) || (is_array($billingAndAllocationSettings) && empty($billingAndAllocationSettings))) {
            unset($this->BillingAndAllocationSettings);
        } else {
            $this->BillingAndAllocationSettings = $billingAndAllocationSettings;
        }
        return $this;
    }
    /**
     * Get CRMLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectTaskToCRMLink|null
     */
    public function getCRMLink()
    {
        return isset($this->CRMLink) ? $this->CRMLink : null;
    }
    /**
     * Set CRMLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectTaskToCRMLink $cRMLink
     * @return \StructType\ProjectTask
     */
    public function setCRMLink(\StructType\ProjectTaskToCRMLink $cRMLink = null)
    {
        if (is_null($cRMLink) || (is_array($cRMLink) && empty($cRMLink))) {
            unset($this->CRMLink);
        } else {
            $this->CRMLink = $cRMLink;
        }
        return $this;
    }
    /**
     * Get Default value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getDefault()
    {
        return isset($this->Default) ? $this->Default : null;
    }
    /**
     * Set Default value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $default
     * @return \StructType\ProjectTask
     */
    public function setDefault(\StructType\BooleanValue $default = null)
    {
        if (is_null($default) || (is_array($default) && empty($default))) {
            unset($this->Default);
        } else {
            $this->Default = $default;
        }
        return $this;
    }
    /**
     * Get DefaultValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectTaskDefaultValues|null
     */
    public function getDefaultValues()
    {
        return isset($this->DefaultValues) ? $this->DefaultValues : null;
    }
    /**
     * Set DefaultValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectTaskDefaultValues $defaultValues
     * @return \StructType\ProjectTask
     */
    public function setDefaultValues(\StructType\ProjectTaskDefaultValues $defaultValues = null)
    {
        if (is_null($defaultValues) || (is_array($defaultValues) && empty($defaultValues))) {
            unset($this->DefaultValues);
        } else {
            $this->DefaultValues = $defaultValues;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProjectTask
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalRefNbr
     * @return \StructType\ProjectTask
     */
    public function setExternalRefNbr(\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ProjectTask
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectID
     * @return \StructType\ProjectTask
     */
    public function setProjectID(\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\ProjectTask
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectTaskProperties|null
     */
    public function getProperties()
    {
        return isset($this->Properties) ? $this->Properties : null;
    }
    /**
     * Set Properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectTaskProperties $properties
     * @return \StructType\ProjectTask
     */
    public function setProperties(\StructType\ProjectTaskProperties $properties = null)
    {
        if (is_null($properties) || (is_array($properties) && empty($properties))) {
            unset($this->Properties);
        } else {
            $this->Properties = $properties;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\ProjectTask
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get VisibilitySettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VisibilitySettings|null
     */
    public function getVisibilitySettings()
    {
        return isset($this->VisibilitySettings) ? $this->VisibilitySettings : null;
    }
    /**
     * Set VisibilitySettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VisibilitySettings $visibilitySettings
     * @return \StructType\ProjectTask
     */
    public function setVisibilitySettings(\StructType\VisibilitySettings $visibilitySettings = null)
    {
        if (is_null($visibilitySettings) || (is_array($visibilitySettings) && empty($visibilitySettings))) {
            unset($this->VisibilitySettings);
        } else {
            $this->VisibilitySettings = $visibilitySettings;
        }
        return $this;
    }
}
