<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The ContactNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactNotification[]
     */
    public $ContactNotification;
    /**
     * Constructor method for Notifications
     * @uses Notifications::setContactNotification()
     * @param \StructType\ContactNotification[] $contactNotification
     */
    public function __construct(array $contactNotification = array())
    {
        $this
            ->setContactNotification($contactNotification);
    }
    /**
     * Get ContactNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactNotification[]|null
     */
    public function getContactNotification()
    {
        return isset($this->ContactNotification) ? $this->ContactNotification : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContactNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactNotificationForArrayConstraintsFromSetContactNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationsContactNotificationItem) {
            // validation for constraint: itemType
            if (!$notificationsContactNotificationItem instanceof \StructType\ContactNotification) {
                $invalidValues[] = is_object($notificationsContactNotificationItem) ? get_class($notificationsContactNotificationItem) : sprintf('%s(%s)', gettype($notificationsContactNotificationItem), var_export($notificationsContactNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactNotification property can only contain items of type \StructType\ContactNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactNotification[] $contactNotification
     * @return \StructType\Notifications
     */
    public function setContactNotification(array $contactNotification = array())
    {
        // validation for constraint: array
        if ('' !== ($contactNotificationArrayErrorMessage = self::validateContactNotificationForArrayConstraintsFromSetContactNotification($contactNotification))) {
            throw new \InvalidArgumentException($contactNotificationArrayErrorMessage, __LINE__);
        }
        if (is_null($contactNotification) || (is_array($contactNotification) && empty($contactNotification))) {
            unset($this->ContactNotification);
        } else {
            $this->ContactNotification = $contactNotification;
        }
        return $this;
    }
    /**
     * Add item to ContactNotification value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactNotification $item
     * @return \StructType\Notifications
     */
    public function addToContactNotification(\StructType\ContactNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactNotification) {
            throw new \InvalidArgumentException(sprintf('The ContactNotification property can only contain items of type \StructType\ContactNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactNotification[] = $item;
        return $this;
    }
}
