<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitSpecification StructType
 * @subpackage Structs
 */
class KitSpecification extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The IsNonStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IsNonStock;
    /**
     * The KitInventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $KitInventoryID;
    /**
     * The NonStockComponents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NonStockComponents
     */
    public $NonStockComponents;
    /**
     * The RevisionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RevisionID;
    /**
     * The StockComponents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockComponents
     */
    public $StockComponents;
    /**
     * Constructor method for KitSpecification
     * @uses KitSpecification::setActive()
     * @uses KitSpecification::setDescription()
     * @uses KitSpecification::setIsNonStock()
     * @uses KitSpecification::setKitInventoryID()
     * @uses KitSpecification::setNonStockComponents()
     * @uses KitSpecification::setRevisionID()
     * @uses KitSpecification::setStockComponents()
     * @param \StructType\BooleanValue $active
     * @param \StructType\StringValue $description
     * @param \StructType\BooleanValue $isNonStock
     * @param \StructType\StringValue $kitInventoryID
     * @param \StructType\NonStockComponents $nonStockComponents
     * @param \StructType\StringValue $revisionID
     * @param \StructType\StockComponents $stockComponents
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\StringValue $description = null, \StructType\BooleanValue $isNonStock = null, \StructType\StringValue $kitInventoryID = null, \StructType\NonStockComponents $nonStockComponents = null, \StructType\StringValue $revisionID = null, \StructType\StockComponents $stockComponents = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setIsNonStock($isNonStock)
            ->setKitInventoryID($kitInventoryID)
            ->setNonStockComponents($nonStockComponents)
            ->setRevisionID($revisionID)
            ->setStockComponents($stockComponents);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\KitSpecification
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\KitSpecification
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsNonStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIsNonStock()
    {
        return isset($this->IsNonStock) ? $this->IsNonStock : null;
    }
    /**
     * Set IsNonStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $isNonStock
     * @return \StructType\KitSpecification
     */
    public function setIsNonStock(\StructType\BooleanValue $isNonStock = null)
    {
        if (is_null($isNonStock) || (is_array($isNonStock) && empty($isNonStock))) {
            unset($this->IsNonStock);
        } else {
            $this->IsNonStock = $isNonStock;
        }
        return $this;
    }
    /**
     * Get KitInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getKitInventoryID()
    {
        return isset($this->KitInventoryID) ? $this->KitInventoryID : null;
    }
    /**
     * Set KitInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $kitInventoryID
     * @return \StructType\KitSpecification
     */
    public function setKitInventoryID(\StructType\StringValue $kitInventoryID = null)
    {
        if (is_null($kitInventoryID) || (is_array($kitInventoryID) && empty($kitInventoryID))) {
            unset($this->KitInventoryID);
        } else {
            $this->KitInventoryID = $kitInventoryID;
        }
        return $this;
    }
    /**
     * Get NonStockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NonStockComponents|null
     */
    public function getNonStockComponents()
    {
        return isset($this->NonStockComponents) ? $this->NonStockComponents : null;
    }
    /**
     * Set NonStockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\NonStockComponents $nonStockComponents
     * @return \StructType\KitSpecification
     */
    public function setNonStockComponents(\StructType\NonStockComponents $nonStockComponents = null)
    {
        if (is_null($nonStockComponents) || (is_array($nonStockComponents) && empty($nonStockComponents))) {
            unset($this->NonStockComponents);
        } else {
            $this->NonStockComponents = $nonStockComponents;
        }
        return $this;
    }
    /**
     * Get RevisionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRevisionID()
    {
        return isset($this->RevisionID) ? $this->RevisionID : null;
    }
    /**
     * Set RevisionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $revisionID
     * @return \StructType\KitSpecification
     */
    public function setRevisionID(\StructType\StringValue $revisionID = null)
    {
        if (is_null($revisionID) || (is_array($revisionID) && empty($revisionID))) {
            unset($this->RevisionID);
        } else {
            $this->RevisionID = $revisionID;
        }
        return $this;
    }
    /**
     * Get StockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockComponents|null
     */
    public function getStockComponents()
    {
        return isset($this->StockComponents) ? $this->StockComponents : null;
    }
    /**
     * Set StockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StockComponents $stockComponents
     * @return \StructType\KitSpecification
     */
    public function setStockComponents(\StructType\StockComponents $stockComponents = null)
    {
        if (is_null($stockComponents) || (is_array($stockComponents) && empty($stockComponents))) {
            unset($this->StockComponents);
        } else {
            $this->StockComponents = $stockComponents;
        }
        return $this;
    }
}
