<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAllocationInquiry StructType
 * @subpackage Structs
 */
class InventoryAllocationInquiry extends Entity
{
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Available;
    /**
     * The AvailableForIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AvailableForIssue;
    /**
     * The AvailableForShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AvailableForShipping;
    /**
     * The BaseUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BaseUnit;
    /**
     * The InTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $InTransit;
    /**
     * The InTransitToSO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $InTransitToSO;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventoryIssues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $InventoryIssues;
    /**
     * The InventoryReceipts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $InventoryReceipts;
    /**
     * The KitAssemblyDemand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $KitAssemblyDemand;
    /**
     * The KitAssemblySupply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $KitAssemblySupply;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Location;
    /**
     * The OnHand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OnHand;
    /**
     * The OnLocationNotAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OnLocationNotAvailable;
    /**
     * The PurchaseForSO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PurchaseForSO;
    /**
     * The PurchaseForSOPrepared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PurchaseForSOPrepared;
    /**
     * The PurchaseOrders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PurchaseOrders;
    /**
     * The PurchasePrepared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PurchasePrepared;
    /**
     * The PurchaseReceipts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PurchaseReceipts;
    /**
     * The ReceiptsForSO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ReceiptsForSO;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Results
     */
    public $Results;
    /**
     * The SOAllocated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $SOAllocated;
    /**
     * The SOBackOrdered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $SOBackOrdered;
    /**
     * The SOBooked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $SOBooked;
    /**
     * The SOPrepared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $SOPrepared;
    /**
     * The SOShipped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $SOShipped;
    /**
     * The SOToPurchase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $SOToPurchase;
    /**
     * The TotalAddition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalAddition;
    /**
     * The TotalDeduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalDeduction;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for InventoryAllocationInquiry
     * @uses InventoryAllocationInquiry::setAvailable()
     * @uses InventoryAllocationInquiry::setAvailableForIssue()
     * @uses InventoryAllocationInquiry::setAvailableForShipping()
     * @uses InventoryAllocationInquiry::setBaseUnit()
     * @uses InventoryAllocationInquiry::setInTransit()
     * @uses InventoryAllocationInquiry::setInTransitToSO()
     * @uses InventoryAllocationInquiry::setInventoryID()
     * @uses InventoryAllocationInquiry::setInventoryIssues()
     * @uses InventoryAllocationInquiry::setInventoryReceipts()
     * @uses InventoryAllocationInquiry::setKitAssemblyDemand()
     * @uses InventoryAllocationInquiry::setKitAssemblySupply()
     * @uses InventoryAllocationInquiry::setLocation()
     * @uses InventoryAllocationInquiry::setOnHand()
     * @uses InventoryAllocationInquiry::setOnLocationNotAvailable()
     * @uses InventoryAllocationInquiry::setPurchaseForSO()
     * @uses InventoryAllocationInquiry::setPurchaseForSOPrepared()
     * @uses InventoryAllocationInquiry::setPurchaseOrders()
     * @uses InventoryAllocationInquiry::setPurchasePrepared()
     * @uses InventoryAllocationInquiry::setPurchaseReceipts()
     * @uses InventoryAllocationInquiry::setReceiptsForSO()
     * @uses InventoryAllocationInquiry::setResults()
     * @uses InventoryAllocationInquiry::setSOAllocated()
     * @uses InventoryAllocationInquiry::setSOBackOrdered()
     * @uses InventoryAllocationInquiry::setSOBooked()
     * @uses InventoryAllocationInquiry::setSOPrepared()
     * @uses InventoryAllocationInquiry::setSOShipped()
     * @uses InventoryAllocationInquiry::setSOToPurchase()
     * @uses InventoryAllocationInquiry::setTotalAddition()
     * @uses InventoryAllocationInquiry::setTotalDeduction()
     * @uses InventoryAllocationInquiry::setWarehouseID()
     * @param \StructType\DecimalValue $available
     * @param \StructType\DecimalValue $availableForIssue
     * @param \StructType\DecimalValue $availableForShipping
     * @param \StructType\StringValue $baseUnit
     * @param \StructType\DecimalValue $inTransit
     * @param \StructType\DecimalValue $inTransitToSO
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\DecimalValue $inventoryIssues
     * @param \StructType\DecimalValue $inventoryReceipts
     * @param \StructType\DecimalValue $kitAssemblyDemand
     * @param \StructType\DecimalValue $kitAssemblySupply
     * @param \StructType\StringValue $location
     * @param \StructType\DecimalValue $onHand
     * @param \StructType\DecimalValue $onLocationNotAvailable
     * @param \StructType\DecimalValue $purchaseForSO
     * @param \StructType\DecimalValue $purchaseForSOPrepared
     * @param \StructType\DecimalValue $purchaseOrders
     * @param \StructType\DecimalValue $purchasePrepared
     * @param \StructType\DecimalValue $purchaseReceipts
     * @param \StructType\DecimalValue $receiptsForSO
     * @param \StructType\Results $results
     * @param \StructType\DecimalValue $sOAllocated
     * @param \StructType\DecimalValue $sOBackOrdered
     * @param \StructType\DecimalValue $sOBooked
     * @param \StructType\DecimalValue $sOPrepared
     * @param \StructType\DecimalValue $sOShipped
     * @param \StructType\DecimalValue $sOToPurchase
     * @param \StructType\DecimalValue $totalAddition
     * @param \StructType\DecimalValue $totalDeduction
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\DecimalValue $available = null, \StructType\DecimalValue $availableForIssue = null, \StructType\DecimalValue $availableForShipping = null, \StructType\StringValue $baseUnit = null, \StructType\DecimalValue $inTransit = null, \StructType\DecimalValue $inTransitToSO = null, \StructType\StringValue $inventoryID = null, \StructType\DecimalValue $inventoryIssues = null, \StructType\DecimalValue $inventoryReceipts = null, \StructType\DecimalValue $kitAssemblyDemand = null, \StructType\DecimalValue $kitAssemblySupply = null, \StructType\StringValue $location = null, \StructType\DecimalValue $onHand = null, \StructType\DecimalValue $onLocationNotAvailable = null, \StructType\DecimalValue $purchaseForSO = null, \StructType\DecimalValue $purchaseForSOPrepared = null, \StructType\DecimalValue $purchaseOrders = null, \StructType\DecimalValue $purchasePrepared = null, \StructType\DecimalValue $purchaseReceipts = null, \StructType\DecimalValue $receiptsForSO = null, \StructType\Results $results = null, \StructType\DecimalValue $sOAllocated = null, \StructType\DecimalValue $sOBackOrdered = null, \StructType\DecimalValue $sOBooked = null, \StructType\DecimalValue $sOPrepared = null, \StructType\DecimalValue $sOShipped = null, \StructType\DecimalValue $sOToPurchase = null, \StructType\DecimalValue $totalAddition = null, \StructType\DecimalValue $totalDeduction = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAvailable($available)
            ->setAvailableForIssue($availableForIssue)
            ->setAvailableForShipping($availableForShipping)
            ->setBaseUnit($baseUnit)
            ->setInTransit($inTransit)
            ->setInTransitToSO($inTransitToSO)
            ->setInventoryID($inventoryID)
            ->setInventoryIssues($inventoryIssues)
            ->setInventoryReceipts($inventoryReceipts)
            ->setKitAssemblyDemand($kitAssemblyDemand)
            ->setKitAssemblySupply($kitAssemblySupply)
            ->setLocation($location)
            ->setOnHand($onHand)
            ->setOnLocationNotAvailable($onLocationNotAvailable)
            ->setPurchaseForSO($purchaseForSO)
            ->setPurchaseForSOPrepared($purchaseForSOPrepared)
            ->setPurchaseOrders($purchaseOrders)
            ->setPurchasePrepared($purchasePrepared)
            ->setPurchaseReceipts($purchaseReceipts)
            ->setReceiptsForSO($receiptsForSO)
            ->setResults($results)
            ->setSOAllocated($sOAllocated)
            ->setSOBackOrdered($sOBackOrdered)
            ->setSOBooked($sOBooked)
            ->setSOPrepared($sOPrepared)
            ->setSOShipped($sOShipped)
            ->setSOToPurchase($sOToPurchase)
            ->setTotalAddition($totalAddition)
            ->setTotalDeduction($totalDeduction)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAvailable()
    {
        return isset($this->Available) ? $this->Available : null;
    }
    /**
     * Set Available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $available
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setAvailable(\StructType\DecimalValue $available = null)
    {
        if (is_null($available) || (is_array($available) && empty($available))) {
            unset($this->Available);
        } else {
            $this->Available = $available;
        }
        return $this;
    }
    /**
     * Get AvailableForIssue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAvailableForIssue()
    {
        return isset($this->AvailableForIssue) ? $this->AvailableForIssue : null;
    }
    /**
     * Set AvailableForIssue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $availableForIssue
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setAvailableForIssue(\StructType\DecimalValue $availableForIssue = null)
    {
        if (is_null($availableForIssue) || (is_array($availableForIssue) && empty($availableForIssue))) {
            unset($this->AvailableForIssue);
        } else {
            $this->AvailableForIssue = $availableForIssue;
        }
        return $this;
    }
    /**
     * Get AvailableForShipping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAvailableForShipping()
    {
        return isset($this->AvailableForShipping) ? $this->AvailableForShipping : null;
    }
    /**
     * Set AvailableForShipping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $availableForShipping
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setAvailableForShipping(\StructType\DecimalValue $availableForShipping = null)
    {
        if (is_null($availableForShipping) || (is_array($availableForShipping) && empty($availableForShipping))) {
            unset($this->AvailableForShipping);
        } else {
            $this->AvailableForShipping = $availableForShipping;
        }
        return $this;
    }
    /**
     * Get BaseUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBaseUnit()
    {
        return isset($this->BaseUnit) ? $this->BaseUnit : null;
    }
    /**
     * Set BaseUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $baseUnit
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setBaseUnit(\StructType\StringValue $baseUnit = null)
    {
        if (is_null($baseUnit) || (is_array($baseUnit) && empty($baseUnit))) {
            unset($this->BaseUnit);
        } else {
            $this->BaseUnit = $baseUnit;
        }
        return $this;
    }
    /**
     * Get InTransit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getInTransit()
    {
        return isset($this->InTransit) ? $this->InTransit : null;
    }
    /**
     * Set InTransit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $inTransit
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setInTransit(\StructType\DecimalValue $inTransit = null)
    {
        if (is_null($inTransit) || (is_array($inTransit) && empty($inTransit))) {
            unset($this->InTransit);
        } else {
            $this->InTransit = $inTransit;
        }
        return $this;
    }
    /**
     * Get InTransitToSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getInTransitToSO()
    {
        return isset($this->InTransitToSO) ? $this->InTransitToSO : null;
    }
    /**
     * Set InTransitToSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $inTransitToSO
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setInTransitToSO(\StructType\DecimalValue $inTransitToSO = null)
    {
        if (is_null($inTransitToSO) || (is_array($inTransitToSO) && empty($inTransitToSO))) {
            unset($this->InTransitToSO);
        } else {
            $this->InTransitToSO = $inTransitToSO;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventoryIssues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getInventoryIssues()
    {
        return isset($this->InventoryIssues) ? $this->InventoryIssues : null;
    }
    /**
     * Set InventoryIssues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $inventoryIssues
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setInventoryIssues(\StructType\DecimalValue $inventoryIssues = null)
    {
        if (is_null($inventoryIssues) || (is_array($inventoryIssues) && empty($inventoryIssues))) {
            unset($this->InventoryIssues);
        } else {
            $this->InventoryIssues = $inventoryIssues;
        }
        return $this;
    }
    /**
     * Get InventoryReceipts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getInventoryReceipts()
    {
        return isset($this->InventoryReceipts) ? $this->InventoryReceipts : null;
    }
    /**
     * Set InventoryReceipts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $inventoryReceipts
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setInventoryReceipts(\StructType\DecimalValue $inventoryReceipts = null)
    {
        if (is_null($inventoryReceipts) || (is_array($inventoryReceipts) && empty($inventoryReceipts))) {
            unset($this->InventoryReceipts);
        } else {
            $this->InventoryReceipts = $inventoryReceipts;
        }
        return $this;
    }
    /**
     * Get KitAssemblyDemand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getKitAssemblyDemand()
    {
        return isset($this->KitAssemblyDemand) ? $this->KitAssemblyDemand : null;
    }
    /**
     * Set KitAssemblyDemand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $kitAssemblyDemand
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setKitAssemblyDemand(\StructType\DecimalValue $kitAssemblyDemand = null)
    {
        if (is_null($kitAssemblyDemand) || (is_array($kitAssemblyDemand) && empty($kitAssemblyDemand))) {
            unset($this->KitAssemblyDemand);
        } else {
            $this->KitAssemblyDemand = $kitAssemblyDemand;
        }
        return $this;
    }
    /**
     * Get KitAssemblySupply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getKitAssemblySupply()
    {
        return isset($this->KitAssemblySupply) ? $this->KitAssemblySupply : null;
    }
    /**
     * Set KitAssemblySupply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $kitAssemblySupply
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setKitAssemblySupply(\StructType\DecimalValue $kitAssemblySupply = null)
    {
        if (is_null($kitAssemblySupply) || (is_array($kitAssemblySupply) && empty($kitAssemblySupply))) {
            unset($this->KitAssemblySupply);
        } else {
            $this->KitAssemblySupply = $kitAssemblySupply;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $location
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setLocation(\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get OnHand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOnHand()
    {
        return isset($this->OnHand) ? $this->OnHand : null;
    }
    /**
     * Set OnHand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $onHand
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setOnHand(\StructType\DecimalValue $onHand = null)
    {
        if (is_null($onHand) || (is_array($onHand) && empty($onHand))) {
            unset($this->OnHand);
        } else {
            $this->OnHand = $onHand;
        }
        return $this;
    }
    /**
     * Get OnLocationNotAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOnLocationNotAvailable()
    {
        return isset($this->OnLocationNotAvailable) ? $this->OnLocationNotAvailable : null;
    }
    /**
     * Set OnLocationNotAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $onLocationNotAvailable
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setOnLocationNotAvailable(\StructType\DecimalValue $onLocationNotAvailable = null)
    {
        if (is_null($onLocationNotAvailable) || (is_array($onLocationNotAvailable) && empty($onLocationNotAvailable))) {
            unset($this->OnLocationNotAvailable);
        } else {
            $this->OnLocationNotAvailable = $onLocationNotAvailable;
        }
        return $this;
    }
    /**
     * Get PurchaseForSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPurchaseForSO()
    {
        return isset($this->PurchaseForSO) ? $this->PurchaseForSO : null;
    }
    /**
     * Set PurchaseForSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $purchaseForSO
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setPurchaseForSO(\StructType\DecimalValue $purchaseForSO = null)
    {
        if (is_null($purchaseForSO) || (is_array($purchaseForSO) && empty($purchaseForSO))) {
            unset($this->PurchaseForSO);
        } else {
            $this->PurchaseForSO = $purchaseForSO;
        }
        return $this;
    }
    /**
     * Get PurchaseForSOPrepared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPurchaseForSOPrepared()
    {
        return isset($this->PurchaseForSOPrepared) ? $this->PurchaseForSOPrepared : null;
    }
    /**
     * Set PurchaseForSOPrepared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $purchaseForSOPrepared
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setPurchaseForSOPrepared(\StructType\DecimalValue $purchaseForSOPrepared = null)
    {
        if (is_null($purchaseForSOPrepared) || (is_array($purchaseForSOPrepared) && empty($purchaseForSOPrepared))) {
            unset($this->PurchaseForSOPrepared);
        } else {
            $this->PurchaseForSOPrepared = $purchaseForSOPrepared;
        }
        return $this;
    }
    /**
     * Get PurchaseOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPurchaseOrders()
    {
        return isset($this->PurchaseOrders) ? $this->PurchaseOrders : null;
    }
    /**
     * Set PurchaseOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $purchaseOrders
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setPurchaseOrders(\StructType\DecimalValue $purchaseOrders = null)
    {
        if (is_null($purchaseOrders) || (is_array($purchaseOrders) && empty($purchaseOrders))) {
            unset($this->PurchaseOrders);
        } else {
            $this->PurchaseOrders = $purchaseOrders;
        }
        return $this;
    }
    /**
     * Get PurchasePrepared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPurchasePrepared()
    {
        return isset($this->PurchasePrepared) ? $this->PurchasePrepared : null;
    }
    /**
     * Set PurchasePrepared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $purchasePrepared
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setPurchasePrepared(\StructType\DecimalValue $purchasePrepared = null)
    {
        if (is_null($purchasePrepared) || (is_array($purchasePrepared) && empty($purchasePrepared))) {
            unset($this->PurchasePrepared);
        } else {
            $this->PurchasePrepared = $purchasePrepared;
        }
        return $this;
    }
    /**
     * Get PurchaseReceipts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPurchaseReceipts()
    {
        return isset($this->PurchaseReceipts) ? $this->PurchaseReceipts : null;
    }
    /**
     * Set PurchaseReceipts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $purchaseReceipts
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setPurchaseReceipts(\StructType\DecimalValue $purchaseReceipts = null)
    {
        if (is_null($purchaseReceipts) || (is_array($purchaseReceipts) && empty($purchaseReceipts))) {
            unset($this->PurchaseReceipts);
        } else {
            $this->PurchaseReceipts = $purchaseReceipts;
        }
        return $this;
    }
    /**
     * Get ReceiptsForSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getReceiptsForSO()
    {
        return isset($this->ReceiptsForSO) ? $this->ReceiptsForSO : null;
    }
    /**
     * Set ReceiptsForSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $receiptsForSO
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setReceiptsForSO(\StructType\DecimalValue $receiptsForSO = null)
    {
        if (is_null($receiptsForSO) || (is_array($receiptsForSO) && empty($receiptsForSO))) {
            unset($this->ReceiptsForSO);
        } else {
            $this->ReceiptsForSO = $receiptsForSO;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Results $results
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setResults(\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get SOAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getSOAllocated()
    {
        return isset($this->SOAllocated) ? $this->SOAllocated : null;
    }
    /**
     * Set SOAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $sOAllocated
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setSOAllocated(\StructType\DecimalValue $sOAllocated = null)
    {
        if (is_null($sOAllocated) || (is_array($sOAllocated) && empty($sOAllocated))) {
            unset($this->SOAllocated);
        } else {
            $this->SOAllocated = $sOAllocated;
        }
        return $this;
    }
    /**
     * Get SOBackOrdered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getSOBackOrdered()
    {
        return isset($this->SOBackOrdered) ? $this->SOBackOrdered : null;
    }
    /**
     * Set SOBackOrdered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $sOBackOrdered
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setSOBackOrdered(\StructType\DecimalValue $sOBackOrdered = null)
    {
        if (is_null($sOBackOrdered) || (is_array($sOBackOrdered) && empty($sOBackOrdered))) {
            unset($this->SOBackOrdered);
        } else {
            $this->SOBackOrdered = $sOBackOrdered;
        }
        return $this;
    }
    /**
     * Get SOBooked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getSOBooked()
    {
        return isset($this->SOBooked) ? $this->SOBooked : null;
    }
    /**
     * Set SOBooked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $sOBooked
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setSOBooked(\StructType\DecimalValue $sOBooked = null)
    {
        if (is_null($sOBooked) || (is_array($sOBooked) && empty($sOBooked))) {
            unset($this->SOBooked);
        } else {
            $this->SOBooked = $sOBooked;
        }
        return $this;
    }
    /**
     * Get SOPrepared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getSOPrepared()
    {
        return isset($this->SOPrepared) ? $this->SOPrepared : null;
    }
    /**
     * Set SOPrepared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $sOPrepared
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setSOPrepared(\StructType\DecimalValue $sOPrepared = null)
    {
        if (is_null($sOPrepared) || (is_array($sOPrepared) && empty($sOPrepared))) {
            unset($this->SOPrepared);
        } else {
            $this->SOPrepared = $sOPrepared;
        }
        return $this;
    }
    /**
     * Get SOShipped value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getSOShipped()
    {
        return isset($this->SOShipped) ? $this->SOShipped : null;
    }
    /**
     * Set SOShipped value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $sOShipped
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setSOShipped(\StructType\DecimalValue $sOShipped = null)
    {
        if (is_null($sOShipped) || (is_array($sOShipped) && empty($sOShipped))) {
            unset($this->SOShipped);
        } else {
            $this->SOShipped = $sOShipped;
        }
        return $this;
    }
    /**
     * Get SOToPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getSOToPurchase()
    {
        return isset($this->SOToPurchase) ? $this->SOToPurchase : null;
    }
    /**
     * Set SOToPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $sOToPurchase
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setSOToPurchase(\StructType\DecimalValue $sOToPurchase = null)
    {
        if (is_null($sOToPurchase) || (is_array($sOToPurchase) && empty($sOToPurchase))) {
            unset($this->SOToPurchase);
        } else {
            $this->SOToPurchase = $sOToPurchase;
        }
        return $this;
    }
    /**
     * Get TotalAddition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalAddition()
    {
        return isset($this->TotalAddition) ? $this->TotalAddition : null;
    }
    /**
     * Set TotalAddition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalAddition
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setTotalAddition(\StructType\DecimalValue $totalAddition = null)
    {
        if (is_null($totalAddition) || (is_array($totalAddition) && empty($totalAddition))) {
            unset($this->TotalAddition);
        } else {
            $this->TotalAddition = $totalAddition;
        }
        return $this;
    }
    /**
     * Get TotalDeduction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalDeduction()
    {
        return isset($this->TotalDeduction) ? $this->TotalDeduction : null;
    }
    /**
     * Set TotalDeduction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalDeduction
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setTotalDeduction(\StructType\DecimalValue $totalDeduction = null)
    {
        if (is_null($totalDeduction) || (is_array($totalDeduction) && empty($totalDeduction))) {
            unset($this->TotalDeduction);
        } else {
            $this->TotalDeduction = $totalDeduction;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
