<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntSearch StructType
 * @subpackage Structs
 */
class IntSearch extends IntValue
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Condition;
    /**
     * The Value2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Value2;
    /**
     * Constructor method for IntSearch
     * @uses IntSearch::setCondition()
     * @uses IntSearch::setValue2()
     * @param string $condition
     * @param int $value2
     */
    public function __construct($condition = null, $value2 = null)
    {
        $this
            ->setCondition($condition)
            ->setValue2($value2);
    }
    /**
     * Get Condition value
     * @return string
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \EnumType\IntCondition::valueIsValid()
     * @uses \EnumType\IntCondition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $condition
     * @return \StructType\IntSearch
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IntCondition::valueIsValid($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IntCondition', is_array($condition) ? implode(', ', $condition) : var_export($condition, true), implode(', ', \EnumType\IntCondition::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get Value2 value
     * @return int
     */
    public function getValue2()
    {
        return $this->Value2;
    }
    /**
     * Set Value2 value
     * @param int $value2
     * @return \StructType\IntSearch
     */
    public function setValue2($value2 = null)
    {
        // validation for constraint: int
        if (!is_null($value2) && !(is_int($value2) || ctype_digit($value2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value2, true), gettype($value2)), __LINE__);
        }
        $this->Value2 = $value2;
        return $this;
    }
}
