<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerContact StructType
 * @subpackage Structs
 */
class CustomerContact extends Entity
{
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The ContactID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $ContactID;
    /**
     * Constructor method for CustomerContact
     * @uses CustomerContact::setContact()
     * @uses CustomerContact::setContactID()
     * @param \StructType\Contact $contact
     * @param \StructType\IntValue $contactID
     */
    public function __construct(\StructType\Contact $contact = null, \StructType\IntValue $contactID = null)
    {
        $this
            ->setContact($contact)
            ->setContactID($contactID);
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\CustomerContact
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get ContactID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getContactID()
    {
        return isset($this->ContactID) ? $this->ContactID : null;
    }
    /**
     * Set ContactID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $contactID
     * @return \StructType\CustomerContact
     */
    public function setContactID(\StructType\IntValue $contactID = null)
    {
        if (is_null($contactID) || (is_array($contactID) && empty($contactID))) {
            unset($this->ContactID);
        } else {
            $this->ContactID = $contactID;
        }
        return $this;
    }
}
