<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contacts StructType
 * @subpackage Structs
 */
class Contacts extends AbstractStructBase
{
    /**
     * The CustomerContact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerContact[]
     */
    public $CustomerContact;
    /**
     * The BusinessAccountContact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountContact[]
     */
    public $BusinessAccountContact;
    /**
     * Constructor method for Contacts
     * @uses Contacts::setCustomerContact()
     * @uses Contacts::setBusinessAccountContact()
     * @param \StructType\CustomerContact[] $customerContact
     * @param \StructType\BusinessAccountContact[] $businessAccountContact
     */
    public function __construct(array $customerContact = array(), array $businessAccountContact = array())
    {
        $this
            ->setCustomerContact($customerContact)
            ->setBusinessAccountContact($businessAccountContact);
    }
    /**
     * Get CustomerContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerContact[]|null
     */
    public function getCustomerContact()
    {
        return isset($this->CustomerContact) ? $this->CustomerContact : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerContactForArrayConstraintsFromSetCustomerContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactsCustomerContactItem) {
            // validation for constraint: itemType
            if (!$contactsCustomerContactItem instanceof \StructType\CustomerContact) {
                $invalidValues[] = is_object($contactsCustomerContactItem) ? get_class($contactsCustomerContactItem) : sprintf('%s(%s)', gettype($contactsCustomerContactItem), var_export($contactsCustomerContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerContact property can only contain items of type \StructType\CustomerContact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerContact[] $customerContact
     * @return \StructType\Contacts
     */
    public function setCustomerContact(array $customerContact = array())
    {
        // validation for constraint: array
        if ('' !== ($customerContactArrayErrorMessage = self::validateCustomerContactForArrayConstraintsFromSetCustomerContact($customerContact))) {
            throw new \InvalidArgumentException($customerContactArrayErrorMessage, __LINE__);
        }
        if (is_null($customerContact) || (is_array($customerContact) && empty($customerContact))) {
            unset($this->CustomerContact);
        } else {
            $this->CustomerContact = $customerContact;
        }
        return $this;
    }
    /**
     * Add item to CustomerContact value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerContact $item
     * @return \StructType\Contacts
     */
    public function addToCustomerContact(\StructType\CustomerContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerContact) {
            throw new \InvalidArgumentException(sprintf('The CustomerContact property can only contain items of type \StructType\CustomerContact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerContact[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountContact[]|null
     */
    public function getBusinessAccountContact()
    {
        return isset($this->BusinessAccountContact) ? $this->BusinessAccountContact : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountContactForArrayConstraintsFromSetBusinessAccountContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactsBusinessAccountContactItem) {
            // validation for constraint: itemType
            if (!$contactsBusinessAccountContactItem instanceof \StructType\BusinessAccountContact) {
                $invalidValues[] = is_object($contactsBusinessAccountContactItem) ? get_class($contactsBusinessAccountContactItem) : sprintf('%s(%s)', gettype($contactsBusinessAccountContactItem), var_export($contactsBusinessAccountContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountContact property can only contain items of type \StructType\BusinessAccountContact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountContact[] $businessAccountContact
     * @return \StructType\Contacts
     */
    public function setBusinessAccountContact(array $businessAccountContact = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountContactArrayErrorMessage = self::validateBusinessAccountContactForArrayConstraintsFromSetBusinessAccountContact($businessAccountContact))) {
            throw new \InvalidArgumentException($businessAccountContactArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountContact) || (is_array($businessAccountContact) && empty($businessAccountContact))) {
            unset($this->BusinessAccountContact);
        } else {
            $this->BusinessAccountContact = $businessAccountContact;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountContact value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountContact $item
     * @return \StructType\Contacts
     */
    public function addToBusinessAccountContact(\StructType\BusinessAccountContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountContact) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountContact property can only contain items of type \StructType\BusinessAccountContact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountContact[] = $item;
        return $this;
    }
}
