<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDetail StructType
 * @subpackage Structs
 */
class CheckDetail extends Entity
{
    /**
     * The AmountPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AmountPaid;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Balance;
    /**
     * The CashDiscountBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CashDiscountBalance;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DocType;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * Constructor method for CheckDetail
     * @uses CheckDetail::setAmountPaid()
     * @uses CheckDetail::setBalance()
     * @uses CheckDetail::setCashDiscountBalance()
     * @uses CheckDetail::setDocType()
     * @uses CheckDetail::setReferenceNbr()
     * @param \StructType\DecimalValue $amountPaid
     * @param \StructType\DecimalValue $balance
     * @param \StructType\DecimalValue $cashDiscountBalance
     * @param \StructType\StringValue $docType
     * @param \StructType\StringValue $referenceNbr
     */
    public function __construct(\StructType\DecimalValue $amountPaid = null, \StructType\DecimalValue $balance = null, \StructType\DecimalValue $cashDiscountBalance = null, \StructType\StringValue $docType = null, \StructType\StringValue $referenceNbr = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setBalance($balance)
            ->setCashDiscountBalance($cashDiscountBalance)
            ->setDocType($docType)
            ->setReferenceNbr($referenceNbr);
    }
    /**
     * Get AmountPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmountPaid()
    {
        return isset($this->AmountPaid) ? $this->AmountPaid : null;
    }
    /**
     * Set AmountPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amountPaid
     * @return \StructType\CheckDetail
     */
    public function setAmountPaid(\StructType\DecimalValue $amountPaid = null)
    {
        if (is_null($amountPaid) || (is_array($amountPaid) && empty($amountPaid))) {
            unset($this->AmountPaid);
        } else {
            $this->AmountPaid = $amountPaid;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $balance
     * @return \StructType\CheckDetail
     */
    public function setBalance(\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get CashDiscountBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCashDiscountBalance()
    {
        return isset($this->CashDiscountBalance) ? $this->CashDiscountBalance : null;
    }
    /**
     * Set CashDiscountBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $cashDiscountBalance
     * @return \StructType\CheckDetail
     */
    public function setCashDiscountBalance(\StructType\DecimalValue $cashDiscountBalance = null)
    {
        if (is_null($cashDiscountBalance) || (is_array($cashDiscountBalance) && empty($cashDiscountBalance))) {
            unset($this->CashDiscountBalance);
        } else {
            $this->CashDiscountBalance = $cashDiscountBalance;
        }
        return $this;
    }
    /**
     * Get DocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDocType()
    {
        return isset($this->DocType) ? $this->DocType : null;
    }
    /**
     * Set DocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $docType
     * @return \StructType\CheckDetail
     */
    public function setDocType(\StructType\StringValue $docType = null)
    {
        if (is_null($docType) || (is_array($docType) && empty($docType))) {
            unset($this->DocType);
        } else {
            $this->DocType = $docType;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\CheckDetail
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
}
