<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashSale StructType
 * @subpackage Structs
 */
class CashSale extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Amount;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Balance;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Project;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for CashSale
     * @uses CashSale::setAmount()
     * @uses CashSale::setBalance()
     * @uses CashSale::setCashAccount()
     * @uses CashSale::setCreatedDateTime()
     * @uses CashSale::setCustomerID()
     * @uses CashSale::setDate()
     * @uses CashSale::setDescription()
     * @uses CashSale::setDetails()
     * @uses CashSale::setHold()
     * @uses CashSale::setLastModifiedDateTime()
     * @uses CashSale::setPaymentMethod()
     * @uses CashSale::setPaymentRef()
     * @uses CashSale::setProject()
     * @uses CashSale::setReferenceNbr()
     * @uses CashSale::setStatus()
     * @uses CashSale::setTaxTotal()
     * @uses CashSale::setType()
     * @param \StructType\DecimalValue $amount
     * @param \StructType\DecimalValue $balance
     * @param \StructType\StringValue $cashAccount
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $customerID
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $description
     * @param \StructType\Details $details
     * @param \StructType\BooleanValue $hold
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\StringValue $paymentRef
     * @param \StructType\StringValue $project
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $taxTotal
     * @param \StructType\StringValue $type
     */
    public function __construct(\StructType\DecimalValue $amount = null, \StructType\DecimalValue $balance = null, \StructType\StringValue $cashAccount = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $customerID = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $description = null, \StructType\Details $details = null, \StructType\BooleanValue $hold = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $paymentMethod = null, \StructType\StringValue $paymentRef = null, \StructType\StringValue $project = null, \StructType\StringValue $referenceNbr = null, \StructType\StringValue $status = null, \StructType\DecimalValue $taxTotal = null, \StructType\StringValue $type = null)
    {
        $this
            ->setAmount($amount)
            ->setBalance($balance)
            ->setCashAccount($cashAccount)
            ->setCreatedDateTime($createdDateTime)
            ->setCustomerID($customerID)
            ->setDate($date)
            ->setDescription($description)
            ->setDetails($details)
            ->setHold($hold)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setProject($project)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTaxTotal($taxTotal)
            ->setType($type);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amount
     * @return \StructType\CashSale
     */
    public function setAmount(\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $balance
     * @return \StructType\CashSale
     */
    public function setBalance(\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cashAccount
     * @return \StructType\CashSale
     */
    public function setCashAccount(\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\CashSale
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\CashSale
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\CashSale
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\CashSale
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\CashSale
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\CashSale
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\CashSale
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\CashSale
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentRef
     * @return \StructType\CashSale
     */
    public function setPaymentRef(\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $project
     * @return \StructType\CashSale
     */
    public function setProject(\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\CashSale
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\CashSale
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxTotal
     * @return \StructType\CashSale
     */
    public function setTaxTotal(\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\CashSale
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
