<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carrier StructType
 * @subpackage Structs
 */
class Carrier extends Entity
{
    /**
     * The CarrierID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CarrierID;
    /**
     * The CarrierUnitOfWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CarrierUnitOfWeight;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CustomerAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerAccounts
     */
    public $CustomerAccounts;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The PlugInParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlugInParameters
     */
    public $PlugInParameters;
    /**
     * The PlugInType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PlugInType;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for Carrier
     * @uses Carrier::setCarrierID()
     * @uses Carrier::setCarrierUnitOfWeight()
     * @uses Carrier::setCreatedDateTime()
     * @uses Carrier::setCustomerAccounts()
     * @uses Carrier::setDescription()
     * @uses Carrier::setLastModifiedDateTime()
     * @uses Carrier::setPlugInParameters()
     * @uses Carrier::setPlugInType()
     * @uses Carrier::setUOM()
     * @param \StructType\StringValue $carrierID
     * @param \StructType\StringValue $carrierUnitOfWeight
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\CustomerAccounts $customerAccounts
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\PlugInParameters $plugInParameters
     * @param \StructType\StringValue $plugInType
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\StringValue $carrierID = null, \StructType\StringValue $carrierUnitOfWeight = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\CustomerAccounts $customerAccounts = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\PlugInParameters $plugInParameters = null, \StructType\StringValue $plugInType = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setCarrierID($carrierID)
            ->setCarrierUnitOfWeight($carrierUnitOfWeight)
            ->setCreatedDateTime($createdDateTime)
            ->setCustomerAccounts($customerAccounts)
            ->setDescription($description)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setPlugInParameters($plugInParameters)
            ->setPlugInType($plugInType)
            ->setUOM($uOM);
    }
    /**
     * Get CarrierID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCarrierID()
    {
        return isset($this->CarrierID) ? $this->CarrierID : null;
    }
    /**
     * Set CarrierID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $carrierID
     * @return \StructType\Carrier
     */
    public function setCarrierID(\StructType\StringValue $carrierID = null)
    {
        if (is_null($carrierID) || (is_array($carrierID) && empty($carrierID))) {
            unset($this->CarrierID);
        } else {
            $this->CarrierID = $carrierID;
        }
        return $this;
    }
    /**
     * Get CarrierUnitOfWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCarrierUnitOfWeight()
    {
        return isset($this->CarrierUnitOfWeight) ? $this->CarrierUnitOfWeight : null;
    }
    /**
     * Set CarrierUnitOfWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $carrierUnitOfWeight
     * @return \StructType\Carrier
     */
    public function setCarrierUnitOfWeight(\StructType\StringValue $carrierUnitOfWeight = null)
    {
        if (is_null($carrierUnitOfWeight) || (is_array($carrierUnitOfWeight) && empty($carrierUnitOfWeight))) {
            unset($this->CarrierUnitOfWeight);
        } else {
            $this->CarrierUnitOfWeight = $carrierUnitOfWeight;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\Carrier
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CustomerAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerAccounts|null
     */
    public function getCustomerAccounts()
    {
        return isset($this->CustomerAccounts) ? $this->CustomerAccounts : null;
    }
    /**
     * Set CustomerAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerAccounts $customerAccounts
     * @return \StructType\Carrier
     */
    public function setCustomerAccounts(\StructType\CustomerAccounts $customerAccounts = null)
    {
        if (is_null($customerAccounts) || (is_array($customerAccounts) && empty($customerAccounts))) {
            unset($this->CustomerAccounts);
        } else {
            $this->CustomerAccounts = $customerAccounts;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Carrier
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\Carrier
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get PlugInParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlugInParameters|null
     */
    public function getPlugInParameters()
    {
        return isset($this->PlugInParameters) ? $this->PlugInParameters : null;
    }
    /**
     * Set PlugInParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PlugInParameters $plugInParameters
     * @return \StructType\Carrier
     */
    public function setPlugInParameters(\StructType\PlugInParameters $plugInParameters = null)
    {
        if (is_null($plugInParameters) || (is_array($plugInParameters) && empty($plugInParameters))) {
            unset($this->PlugInParameters);
        } else {
            $this->PlugInParameters = $plugInParameters;
        }
        return $this;
    }
    /**
     * Get PlugInType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPlugInType()
    {
        return isset($this->PlugInType) ? $this->PlugInType : null;
    }
    /**
     * Set PlugInType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $plugInType
     * @return \StructType\Carrier
     */
    public function setPlugInType(\StructType\StringValue $plugInType = null)
    {
        if (is_null($plugInType) || (is_array($plugInType) && empty($plugInType))) {
            unset($this->PlugInType);
        } else {
            $this->PlugInType = $plugInType;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\Carrier
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
