<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ByteSearch StructType
 * @subpackage Structs
 */
class ByteSearch extends ByteValue
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Condition;
    /**
     * The Value2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Value2;
    /**
     * Constructor method for ByteSearch
     * @uses ByteSearch::setCondition()
     * @uses ByteSearch::setValue2()
     * @param string $condition
     * @param string $value2
     */
    public function __construct($condition = null, $value2 = null)
    {
        $this
            ->setCondition($condition)
            ->setValue2($value2);
    }
    /**
     * Get Condition value
     * @return string
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \EnumType\ByteCondition::valueIsValid()
     * @uses \EnumType\ByteCondition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $condition
     * @return \StructType\ByteSearch
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ByteCondition::valueIsValid($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ByteCondition', is_array($condition) ? implode(', ', $condition) : var_export($condition, true), implode(', ', \EnumType\ByteCondition::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get Value2 value
     * @return string
     */
    public function getValue2()
    {
        return $this->Value2;
    }
    /**
     * Set Value2 value
     * @param string $value2
     * @return \StructType\ByteSearch
     */
    public function setValue2($value2 = null)
    {
        // validation for constraint: string
        if (!is_null($value2) && !is_string($value2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value2, true), gettype($value2)), __LINE__);
        }
        $this->Value2 = $value2;
        return $this;
    }
}
