<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessAccountContract StructType
 * @subpackage Structs
 */
class BusinessAccountContract extends Entity
{
    /**
     * The BusinessAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BusinessAccountID;
    /**
     * The BusinessAccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BusinessAccountName;
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ContractID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Location;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for BusinessAccountContract
     * @uses BusinessAccountContract::setBusinessAccountID()
     * @uses BusinessAccountContract::setBusinessAccountName()
     * @uses BusinessAccountContract::setContractID()
     * @uses BusinessAccountContract::setDescription()
     * @uses BusinessAccountContract::setExpirationDate()
     * @uses BusinessAccountContract::setLocation()
     * @uses BusinessAccountContract::setStatus()
     * @param \StructType\StringValue $businessAccountID
     * @param \StructType\StringValue $businessAccountName
     * @param \StructType\StringValue $contractID
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $expirationDate
     * @param \StructType\StringValue $location
     * @param \StructType\StringValue $status
     */
    public function __construct(\StructType\StringValue $businessAccountID = null, \StructType\StringValue $businessAccountName = null, \StructType\StringValue $contractID = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $expirationDate = null, \StructType\StringValue $location = null, \StructType\StringValue $status = null)
    {
        $this
            ->setBusinessAccountID($businessAccountID)
            ->setBusinessAccountName($businessAccountName)
            ->setContractID($contractID)
            ->setDescription($description)
            ->setExpirationDate($expirationDate)
            ->setLocation($location)
            ->setStatus($status);
    }
    /**
     * Get BusinessAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBusinessAccountID()
    {
        return isset($this->BusinessAccountID) ? $this->BusinessAccountID : null;
    }
    /**
     * Set BusinessAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $businessAccountID
     * @return \StructType\BusinessAccountContract
     */
    public function setBusinessAccountID(\StructType\StringValue $businessAccountID = null)
    {
        if (is_null($businessAccountID) || (is_array($businessAccountID) && empty($businessAccountID))) {
            unset($this->BusinessAccountID);
        } else {
            $this->BusinessAccountID = $businessAccountID;
        }
        return $this;
    }
    /**
     * Get BusinessAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBusinessAccountName()
    {
        return isset($this->BusinessAccountName) ? $this->BusinessAccountName : null;
    }
    /**
     * Set BusinessAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $businessAccountName
     * @return \StructType\BusinessAccountContract
     */
    public function setBusinessAccountName(\StructType\StringValue $businessAccountName = null)
    {
        if (is_null($businessAccountName) || (is_array($businessAccountName) && empty($businessAccountName))) {
            unset($this->BusinessAccountName);
        } else {
            $this->BusinessAccountName = $businessAccountName;
        }
        return $this;
    }
    /**
     * Get ContractID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getContractID()
    {
        return isset($this->ContractID) ? $this->ContractID : null;
    }
    /**
     * Set ContractID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $contractID
     * @return \StructType\BusinessAccountContract
     */
    public function setContractID(\StructType\StringValue $contractID = null)
    {
        if (is_null($contractID) || (is_array($contractID) && empty($contractID))) {
            unset($this->ContractID);
        } else {
            $this->ContractID = $contractID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\BusinessAccountContract
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $expirationDate
     * @return \StructType\BusinessAccountContract
     */
    public function setExpirationDate(\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $location
     * @return \StructType\BusinessAccountContract
     */
    public function setLocation(\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\BusinessAccountContract
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
