<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeDetail StructType
 * @subpackage Structs
 */
class AttributeDetail extends Entity
{
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Attribute;
    /**
     * The RefNoteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GuidValue
     */
    public $RefNoteID;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Required;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Value;
    /**
     * Constructor method for AttributeDetail
     * @uses AttributeDetail::setAttribute()
     * @uses AttributeDetail::setRefNoteID()
     * @uses AttributeDetail::setRequired()
     * @uses AttributeDetail::setValue()
     * @param \StructType\StringValue $attribute
     * @param \StructType\GuidValue $refNoteID
     * @param \StructType\BooleanValue $required
     * @param \StructType\StringValue $value
     */
    public function __construct(\StructType\StringValue $attribute = null, \StructType\GuidValue $refNoteID = null, \StructType\BooleanValue $required = null, \StructType\StringValue $value = null)
    {
        $this
            ->setAttribute($attribute)
            ->setRefNoteID($refNoteID)
            ->setRequired($required)
            ->setValue($value);
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $attribute
     * @return \StructType\AttributeDetail
     */
    public function setAttribute(\StructType\StringValue $attribute = null)
    {
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Get RefNoteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GuidValue|null
     */
    public function getRefNoteID()
    {
        return isset($this->RefNoteID) ? $this->RefNoteID : null;
    }
    /**
     * Set RefNoteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GuidValue $refNoteID
     * @return \StructType\AttributeDetail
     */
    public function setRefNoteID(\StructType\GuidValue $refNoteID = null)
    {
        if (is_null($refNoteID) || (is_array($refNoteID) && empty($refNoteID))) {
            unset($this->RefNoteID);
        } else {
            $this->RefNoteID = $refNoteID;
        }
        return $this;
    }
    /**
     * Get Required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequired()
    {
        return isset($this->Required) ? $this->Required : null;
    }
    /**
     * Set Required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $required
     * @return \StructType\AttributeDetail
     */
    public function setRequired(\StructType\BooleanValue $required = null)
    {
        if (is_null($required) || (is_array($required) && empty($required))) {
            unset($this->Required);
        } else {
            $this->Required = $required;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $value
     * @return \StructType\AttributeDetail
     */
    public function setValue(\StructType\StringValue $value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
