<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountLocation StructType
 * @subpackage Structs
 */
class AccountLocation extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The AddressSameAsMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AddressSameAsMain;
    /**
     * The AddressValidated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AddressValidated;
    /**
     * The ARAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ARAccount;
    /**
     * The ARSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ARSubaccount;
    /**
     * The BusinessAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BusinessAccountID;
    /**
     * The Calendar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Calendar;
    /**
     * The Cases
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Cases
     */
    public $Cases;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountLocationContact
     */
    public $Contact;
    /**
     * The DefaultProject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DefaultProject;
    /**
     * The DiscountAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountAccount;
    /**
     * The DiscountSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountSubaccount;
    /**
     * The EntityUsageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EntityUsageType;
    /**
     * The FedExGroundCollect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $FedExGroundCollect;
    /**
     * The FOBPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The FreightAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FreightAccount;
    /**
     * The FreightSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FreightSubaccount;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Insurance;
    /**
     * The LeadTimeInDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $LeadTimeInDays;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationName;
    /**
     * The Opportunities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Opportunities
     */
    public $Opportunities;
    /**
     * The OrderPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $OrderPriority;
    /**
     * The PriceClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PriceClass;
    /**
     * The ResidentialDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The SameAsDefaultLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SameAsDefaultLocation;
    /**
     * The SaturdayDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The ShippingBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingBranch;
    /**
     * The ShippingRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingZone;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipVia;
    /**
     * The TaxExemptionNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxExemptionNumber;
    /**
     * The TaxRegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for AccountLocation
     * @uses AccountLocation::setActive()
     * @uses AccountLocation::setAddress()
     * @uses AccountLocation::setAddressSameAsMain()
     * @uses AccountLocation::setAddressValidated()
     * @uses AccountLocation::setARAccount()
     * @uses AccountLocation::setARSubaccount()
     * @uses AccountLocation::setBusinessAccountID()
     * @uses AccountLocation::setCalendar()
     * @uses AccountLocation::setCases()
     * @uses AccountLocation::setContact()
     * @uses AccountLocation::setDefaultProject()
     * @uses AccountLocation::setDiscountAccount()
     * @uses AccountLocation::setDiscountSubaccount()
     * @uses AccountLocation::setEntityUsageType()
     * @uses AccountLocation::setFedExGroundCollect()
     * @uses AccountLocation::setFOBPoint()
     * @uses AccountLocation::setFreightAccount()
     * @uses AccountLocation::setFreightSubaccount()
     * @uses AccountLocation::setInsurance()
     * @uses AccountLocation::setLeadTimeInDays()
     * @uses AccountLocation::setLocationID()
     * @uses AccountLocation::setLocationName()
     * @uses AccountLocation::setOpportunities()
     * @uses AccountLocation::setOrderPriority()
     * @uses AccountLocation::setPriceClass()
     * @uses AccountLocation::setResidentialDelivery()
     * @uses AccountLocation::setSalesAccount()
     * @uses AccountLocation::setSalesSubaccount()
     * @uses AccountLocation::setSameAsDefaultLocation()
     * @uses AccountLocation::setSaturdayDelivery()
     * @uses AccountLocation::setShippingBranch()
     * @uses AccountLocation::setShippingRule()
     * @uses AccountLocation::setShippingTerms()
     * @uses AccountLocation::setShippingZone()
     * @uses AccountLocation::setShipVia()
     * @uses AccountLocation::setTaxExemptionNumber()
     * @uses AccountLocation::setTaxRegistrationID()
     * @uses AccountLocation::setTaxZone()
     * @uses AccountLocation::setWarehouse()
     * @param \StructType\BooleanValue $active
     * @param \StructType\Address $address
     * @param \StructType\BooleanValue $addressSameAsMain
     * @param \StructType\BooleanValue $addressValidated
     * @param \StructType\StringValue $aRAccount
     * @param \StructType\StringValue $aRSubaccount
     * @param \StructType\StringValue $businessAccountID
     * @param \StructType\StringValue $calendar
     * @param \StructType\Cases $cases
     * @param \StructType\AccountLocationContact $contact
     * @param \StructType\StringValue $defaultProject
     * @param \StructType\StringValue $discountAccount
     * @param \StructType\StringValue $discountSubaccount
     * @param \StructType\StringValue $entityUsageType
     * @param \StructType\BooleanValue $fedExGroundCollect
     * @param \StructType\StringValue $fOBPoint
     * @param \StructType\StringValue $freightAccount
     * @param \StructType\StringValue $freightSubaccount
     * @param \StructType\BooleanValue $insurance
     * @param \StructType\ShortValue $leadTimeInDays
     * @param \StructType\StringValue $locationID
     * @param \StructType\StringValue $locationName
     * @param \StructType\Opportunities $opportunities
     * @param \StructType\ShortValue $orderPriority
     * @param \StructType\StringValue $priceClass
     * @param \StructType\BooleanValue $residentialDelivery
     * @param \StructType\StringValue $salesAccount
     * @param \StructType\StringValue $salesSubaccount
     * @param \StructType\BooleanValue $sameAsDefaultLocation
     * @param \StructType\BooleanValue $saturdayDelivery
     * @param \StructType\StringValue $shippingBranch
     * @param \StructType\StringValue $shippingRule
     * @param \StructType\StringValue $shippingTerms
     * @param \StructType\StringValue $shippingZone
     * @param \StructType\StringValue $shipVia
     * @param \StructType\StringValue $taxExemptionNumber
     * @param \StructType\StringValue $taxRegistrationID
     * @param \StructType\StringValue $taxZone
     * @param \StructType\StringValue $warehouse
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\Address $address = null, \StructType\BooleanValue $addressSameAsMain = null, \StructType\BooleanValue $addressValidated = null, \StructType\StringValue $aRAccount = null, \StructType\StringValue $aRSubaccount = null, \StructType\StringValue $businessAccountID = null, \StructType\StringValue $calendar = null, \StructType\Cases $cases = null, \StructType\AccountLocationContact $contact = null, \StructType\StringValue $defaultProject = null, \StructType\StringValue $discountAccount = null, \StructType\StringValue $discountSubaccount = null, \StructType\StringValue $entityUsageType = null, \StructType\BooleanValue $fedExGroundCollect = null, \StructType\StringValue $fOBPoint = null, \StructType\StringValue $freightAccount = null, \StructType\StringValue $freightSubaccount = null, \StructType\BooleanValue $insurance = null, \StructType\ShortValue $leadTimeInDays = null, \StructType\StringValue $locationID = null, \StructType\StringValue $locationName = null, \StructType\Opportunities $opportunities = null, \StructType\ShortValue $orderPriority = null, \StructType\StringValue $priceClass = null, \StructType\BooleanValue $residentialDelivery = null, \StructType\StringValue $salesAccount = null, \StructType\StringValue $salesSubaccount = null, \StructType\BooleanValue $sameAsDefaultLocation = null, \StructType\BooleanValue $saturdayDelivery = null, \StructType\StringValue $shippingBranch = null, \StructType\StringValue $shippingRule = null, \StructType\StringValue $shippingTerms = null, \StructType\StringValue $shippingZone = null, \StructType\StringValue $shipVia = null, \StructType\StringValue $taxExemptionNumber = null, \StructType\StringValue $taxRegistrationID = null, \StructType\StringValue $taxZone = null, \StructType\StringValue $warehouse = null)
    {
        $this
            ->setActive($active)
            ->setAddress($address)
            ->setAddressSameAsMain($addressSameAsMain)
            ->setAddressValidated($addressValidated)
            ->setARAccount($aRAccount)
            ->setARSubaccount($aRSubaccount)
            ->setBusinessAccountID($businessAccountID)
            ->setCalendar($calendar)
            ->setCases($cases)
            ->setContact($contact)
            ->setDefaultProject($defaultProject)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSubaccount($discountSubaccount)
            ->setEntityUsageType($entityUsageType)
            ->setFedExGroundCollect($fedExGroundCollect)
            ->setFOBPoint($fOBPoint)
            ->setFreightAccount($freightAccount)
            ->setFreightSubaccount($freightSubaccount)
            ->setInsurance($insurance)
            ->setLeadTimeInDays($leadTimeInDays)
            ->setLocationID($locationID)
            ->setLocationName($locationName)
            ->setOpportunities($opportunities)
            ->setOrderPriority($orderPriority)
            ->setPriceClass($priceClass)
            ->setResidentialDelivery($residentialDelivery)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setSameAsDefaultLocation($sameAsDefaultLocation)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setShippingBranch($shippingBranch)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZone($shippingZone)
            ->setShipVia($shipVia)
            ->setTaxExemptionNumber($taxExemptionNumber)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setWarehouse($warehouse);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\AccountLocation
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $address
     * @return \StructType\AccountLocation
     */
    public function setAddress(\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAddressSameAsMain()
    {
        return isset($this->AddressSameAsMain) ? $this->AddressSameAsMain : null;
    }
    /**
     * Set AddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $addressSameAsMain
     * @return \StructType\AccountLocation
     */
    public function setAddressSameAsMain(\StructType\BooleanValue $addressSameAsMain = null)
    {
        if (is_null($addressSameAsMain) || (is_array($addressSameAsMain) && empty($addressSameAsMain))) {
            unset($this->AddressSameAsMain);
        } else {
            $this->AddressSameAsMain = $addressSameAsMain;
        }
        return $this;
    }
    /**
     * Get AddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAddressValidated()
    {
        return isset($this->AddressValidated) ? $this->AddressValidated : null;
    }
    /**
     * Set AddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $addressValidated
     * @return \StructType\AccountLocation
     */
    public function setAddressValidated(\StructType\BooleanValue $addressValidated = null)
    {
        if (is_null($addressValidated) || (is_array($addressValidated) && empty($addressValidated))) {
            unset($this->AddressValidated);
        } else {
            $this->AddressValidated = $addressValidated;
        }
        return $this;
    }
    /**
     * Get ARAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getARAccount()
    {
        return isset($this->ARAccount) ? $this->ARAccount : null;
    }
    /**
     * Set ARAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $aRAccount
     * @return \StructType\AccountLocation
     */
    public function setARAccount(\StructType\StringValue $aRAccount = null)
    {
        if (is_null($aRAccount) || (is_array($aRAccount) && empty($aRAccount))) {
            unset($this->ARAccount);
        } else {
            $this->ARAccount = $aRAccount;
        }
        return $this;
    }
    /**
     * Get ARSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getARSubaccount()
    {
        return isset($this->ARSubaccount) ? $this->ARSubaccount : null;
    }
    /**
     * Set ARSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $aRSubaccount
     * @return \StructType\AccountLocation
     */
    public function setARSubaccount(\StructType\StringValue $aRSubaccount = null)
    {
        if (is_null($aRSubaccount) || (is_array($aRSubaccount) && empty($aRSubaccount))) {
            unset($this->ARSubaccount);
        } else {
            $this->ARSubaccount = $aRSubaccount;
        }
        return $this;
    }
    /**
     * Get BusinessAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBusinessAccountID()
    {
        return isset($this->BusinessAccountID) ? $this->BusinessAccountID : null;
    }
    /**
     * Set BusinessAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $businessAccountID
     * @return \StructType\AccountLocation
     */
    public function setBusinessAccountID(\StructType\StringValue $businessAccountID = null)
    {
        if (is_null($businessAccountID) || (is_array($businessAccountID) && empty($businessAccountID))) {
            unset($this->BusinessAccountID);
        } else {
            $this->BusinessAccountID = $businessAccountID;
        }
        return $this;
    }
    /**
     * Get Calendar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCalendar()
    {
        return isset($this->Calendar) ? $this->Calendar : null;
    }
    /**
     * Set Calendar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $calendar
     * @return \StructType\AccountLocation
     */
    public function setCalendar(\StructType\StringValue $calendar = null)
    {
        if (is_null($calendar) || (is_array($calendar) && empty($calendar))) {
            unset($this->Calendar);
        } else {
            $this->Calendar = $calendar;
        }
        return $this;
    }
    /**
     * Get Cases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Cases|null
     */
    public function getCases()
    {
        return isset($this->Cases) ? $this->Cases : null;
    }
    /**
     * Set Cases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Cases $cases
     * @return \StructType\AccountLocation
     */
    public function setCases(\StructType\Cases $cases = null)
    {
        if (is_null($cases) || (is_array($cases) && empty($cases))) {
            unset($this->Cases);
        } else {
            $this->Cases = $cases;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountLocationContact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountLocationContact $contact
     * @return \StructType\AccountLocation
     */
    public function setContact(\StructType\AccountLocationContact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get DefaultProject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDefaultProject()
    {
        return isset($this->DefaultProject) ? $this->DefaultProject : null;
    }
    /**
     * Set DefaultProject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $defaultProject
     * @return \StructType\AccountLocation
     */
    public function setDefaultProject(\StructType\StringValue $defaultProject = null)
    {
        if (is_null($defaultProject) || (is_array($defaultProject) && empty($defaultProject))) {
            unset($this->DefaultProject);
        } else {
            $this->DefaultProject = $defaultProject;
        }
        return $this;
    }
    /**
     * Get DiscountAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountAccount()
    {
        return isset($this->DiscountAccount) ? $this->DiscountAccount : null;
    }
    /**
     * Set DiscountAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountAccount
     * @return \StructType\AccountLocation
     */
    public function setDiscountAccount(\StructType\StringValue $discountAccount = null)
    {
        if (is_null($discountAccount) || (is_array($discountAccount) && empty($discountAccount))) {
            unset($this->DiscountAccount);
        } else {
            $this->DiscountAccount = $discountAccount;
        }
        return $this;
    }
    /**
     * Get DiscountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountSubaccount()
    {
        return isset($this->DiscountSubaccount) ? $this->DiscountSubaccount : null;
    }
    /**
     * Set DiscountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountSubaccount
     * @return \StructType\AccountLocation
     */
    public function setDiscountSubaccount(\StructType\StringValue $discountSubaccount = null)
    {
        if (is_null($discountSubaccount) || (is_array($discountSubaccount) && empty($discountSubaccount))) {
            unset($this->DiscountSubaccount);
        } else {
            $this->DiscountSubaccount = $discountSubaccount;
        }
        return $this;
    }
    /**
     * Get EntityUsageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEntityUsageType()
    {
        return isset($this->EntityUsageType) ? $this->EntityUsageType : null;
    }
    /**
     * Set EntityUsageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $entityUsageType
     * @return \StructType\AccountLocation
     */
    public function setEntityUsageType(\StructType\StringValue $entityUsageType = null)
    {
        if (is_null($entityUsageType) || (is_array($entityUsageType) && empty($entityUsageType))) {
            unset($this->EntityUsageType);
        } else {
            $this->EntityUsageType = $entityUsageType;
        }
        return $this;
    }
    /**
     * Get FedExGroundCollect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getFedExGroundCollect()
    {
        return isset($this->FedExGroundCollect) ? $this->FedExGroundCollect : null;
    }
    /**
     * Set FedExGroundCollect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $fedExGroundCollect
     * @return \StructType\AccountLocation
     */
    public function setFedExGroundCollect(\StructType\BooleanValue $fedExGroundCollect = null)
    {
        if (is_null($fedExGroundCollect) || (is_array($fedExGroundCollect) && empty($fedExGroundCollect))) {
            unset($this->FedExGroundCollect);
        } else {
            $this->FedExGroundCollect = $fedExGroundCollect;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $fOBPoint
     * @return \StructType\AccountLocation
     */
    public function setFOBPoint(\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get FreightAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFreightAccount()
    {
        return isset($this->FreightAccount) ? $this->FreightAccount : null;
    }
    /**
     * Set FreightAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $freightAccount
     * @return \StructType\AccountLocation
     */
    public function setFreightAccount(\StructType\StringValue $freightAccount = null)
    {
        if (is_null($freightAccount) || (is_array($freightAccount) && empty($freightAccount))) {
            unset($this->FreightAccount);
        } else {
            $this->FreightAccount = $freightAccount;
        }
        return $this;
    }
    /**
     * Get FreightSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFreightSubaccount()
    {
        return isset($this->FreightSubaccount) ? $this->FreightSubaccount : null;
    }
    /**
     * Set FreightSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $freightSubaccount
     * @return \StructType\AccountLocation
     */
    public function setFreightSubaccount(\StructType\StringValue $freightSubaccount = null)
    {
        if (is_null($freightSubaccount) || (is_array($freightSubaccount) && empty($freightSubaccount))) {
            unset($this->FreightSubaccount);
        } else {
            $this->FreightSubaccount = $freightSubaccount;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $insurance
     * @return \StructType\AccountLocation
     */
    public function setInsurance(\StructType\BooleanValue $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get LeadTimeInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getLeadTimeInDays()
    {
        return isset($this->LeadTimeInDays) ? $this->LeadTimeInDays : null;
    }
    /**
     * Set LeadTimeInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $leadTimeInDays
     * @return \StructType\AccountLocation
     */
    public function setLeadTimeInDays(\StructType\ShortValue $leadTimeInDays = null)
    {
        if (is_null($leadTimeInDays) || (is_array($leadTimeInDays) && empty($leadTimeInDays))) {
            unset($this->LeadTimeInDays);
        } else {
            $this->LeadTimeInDays = $leadTimeInDays;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\AccountLocation
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationName
     * @return \StructType\AccountLocation
     */
    public function setLocationName(\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get Opportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Opportunities|null
     */
    public function getOpportunities()
    {
        return isset($this->Opportunities) ? $this->Opportunities : null;
    }
    /**
     * Set Opportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Opportunities $opportunities
     * @return \StructType\AccountLocation
     */
    public function setOpportunities(\StructType\Opportunities $opportunities = null)
    {
        if (is_null($opportunities) || (is_array($opportunities) && empty($opportunities))) {
            unset($this->Opportunities);
        } else {
            $this->Opportunities = $opportunities;
        }
        return $this;
    }
    /**
     * Get OrderPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getOrderPriority()
    {
        return isset($this->OrderPriority) ? $this->OrderPriority : null;
    }
    /**
     * Set OrderPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $orderPriority
     * @return \StructType\AccountLocation
     */
    public function setOrderPriority(\StructType\ShortValue $orderPriority = null)
    {
        if (is_null($orderPriority) || (is_array($orderPriority) && empty($orderPriority))) {
            unset($this->OrderPriority);
        } else {
            $this->OrderPriority = $orderPriority;
        }
        return $this;
    }
    /**
     * Get PriceClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPriceClass()
    {
        return isset($this->PriceClass) ? $this->PriceClass : null;
    }
    /**
     * Set PriceClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $priceClass
     * @return \StructType\AccountLocation
     */
    public function setPriceClass(\StructType\StringValue $priceClass = null)
    {
        if (is_null($priceClass) || (is_array($priceClass) && empty($priceClass))) {
            unset($this->PriceClass);
        } else {
            $this->PriceClass = $priceClass;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $residentialDelivery
     * @return \StructType\AccountLocation
     */
    public function setResidentialDelivery(\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesAccount
     * @return \StructType\AccountLocation
     */
    public function setSalesAccount(\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesSubaccount
     * @return \StructType\AccountLocation
     */
    public function setSalesSubaccount(\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get SameAsDefaultLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSameAsDefaultLocation()
    {
        return isset($this->SameAsDefaultLocation) ? $this->SameAsDefaultLocation : null;
    }
    /**
     * Set SameAsDefaultLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $sameAsDefaultLocation
     * @return \StructType\AccountLocation
     */
    public function setSameAsDefaultLocation(\StructType\BooleanValue $sameAsDefaultLocation = null)
    {
        if (is_null($sameAsDefaultLocation) || (is_array($sameAsDefaultLocation) && empty($sameAsDefaultLocation))) {
            unset($this->SameAsDefaultLocation);
        } else {
            $this->SameAsDefaultLocation = $sameAsDefaultLocation;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $saturdayDelivery
     * @return \StructType\AccountLocation
     */
    public function setSaturdayDelivery(\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get ShippingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingBranch()
    {
        return isset($this->ShippingBranch) ? $this->ShippingBranch : null;
    }
    /**
     * Set ShippingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingBranch
     * @return \StructType\AccountLocation
     */
    public function setShippingBranch(\StructType\StringValue $shippingBranch = null)
    {
        if (is_null($shippingBranch) || (is_array($shippingBranch) && empty($shippingBranch))) {
            unset($this->ShippingBranch);
        } else {
            $this->ShippingBranch = $shippingBranch;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingRule
     * @return \StructType\AccountLocation
     */
    public function setShippingRule(\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingTerms
     * @return \StructType\AccountLocation
     */
    public function setShippingTerms(\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingZone()
    {
        return isset($this->ShippingZone) ? $this->ShippingZone : null;
    }
    /**
     * Set ShippingZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingZone
     * @return \StructType\AccountLocation
     */
    public function setShippingZone(\StructType\StringValue $shippingZone = null)
    {
        if (is_null($shippingZone) || (is_array($shippingZone) && empty($shippingZone))) {
            unset($this->ShippingZone);
        } else {
            $this->ShippingZone = $shippingZone;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipVia
     * @return \StructType\AccountLocation
     */
    public function setShipVia(\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get TaxExemptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxExemptionNumber()
    {
        return isset($this->TaxExemptionNumber) ? $this->TaxExemptionNumber : null;
    }
    /**
     * Set TaxExemptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxExemptionNumber
     * @return \StructType\AccountLocation
     */
    public function setTaxExemptionNumber(\StructType\StringValue $taxExemptionNumber = null)
    {
        if (is_null($taxExemptionNumber) || (is_array($taxExemptionNumber) && empty($taxExemptionNumber))) {
            unset($this->TaxExemptionNumber);
        } else {
            $this->TaxExemptionNumber = $taxExemptionNumber;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxRegistrationID
     * @return \StructType\AccountLocation
     */
    public function setTaxRegistrationID(\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxZone
     * @return \StructType\AccountLocation
     */
    public function setTaxZone(\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouse
     * @return \StructType\AccountLocation
     */
    public function setWarehouse(\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
}
