<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountGroup StructType
 * @subpackage Structs
 */
class AccountGroup extends Entity
{
    /**
     * The AccountGroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroupID;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attributes
     */
    public $Attributes;
    /**
     * The DefaultAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DefaultAccountID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Expense
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Expense;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $SortOrder;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for AccountGroup
     * @uses AccountGroup::setAccountGroupID()
     * @uses AccountGroup::setActive()
     * @uses AccountGroup::setAttributes()
     * @uses AccountGroup::setDefaultAccountID()
     * @uses AccountGroup::setDescription()
     * @uses AccountGroup::setExpense()
     * @uses AccountGroup::setSortOrder()
     * @uses AccountGroup::setType()
     * @param \StructType\StringValue $accountGroupID
     * @param \StructType\BooleanValue $active
     * @param \StructType\Attributes $attributes
     * @param \StructType\StringValue $defaultAccountID
     * @param \StructType\StringValue $description
     * @param \StructType\BooleanValue $expense
     * @param \StructType\ShortValue $sortOrder
     * @param \StructType\StringValue $type
     */
    public function __construct(\StructType\StringValue $accountGroupID = null, \StructType\BooleanValue $active = null, \StructType\Attributes $attributes = null, \StructType\StringValue $defaultAccountID = null, \StructType\StringValue $description = null, \StructType\BooleanValue $expense = null, \StructType\ShortValue $sortOrder = null, \StructType\StringValue $type = null)
    {
        $this
            ->setAccountGroupID($accountGroupID)
            ->setActive($active)
            ->setAttributes($attributes)
            ->setDefaultAccountID($defaultAccountID)
            ->setDescription($description)
            ->setExpense($expense)
            ->setSortOrder($sortOrder)
            ->setType($type);
    }
    /**
     * Get AccountGroupID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroupID()
    {
        return isset($this->AccountGroupID) ? $this->AccountGroupID : null;
    }
    /**
     * Set AccountGroupID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroupID
     * @return \StructType\AccountGroup
     */
    public function setAccountGroupID(\StructType\StringValue $accountGroupID = null)
    {
        if (is_null($accountGroupID) || (is_array($accountGroupID) && empty($accountGroupID))) {
            unset($this->AccountGroupID);
        } else {
            $this->AccountGroupID = $accountGroupID;
        }
        return $this;
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\AccountGroup
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attributes $attributes
     * @return \StructType\AccountGroup
     */
    public function setAttributes(\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get DefaultAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDefaultAccountID()
    {
        return isset($this->DefaultAccountID) ? $this->DefaultAccountID : null;
    }
    /**
     * Set DefaultAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $defaultAccountID
     * @return \StructType\AccountGroup
     */
    public function setDefaultAccountID(\StructType\StringValue $defaultAccountID = null)
    {
        if (is_null($defaultAccountID) || (is_array($defaultAccountID) && empty($defaultAccountID))) {
            unset($this->DefaultAccountID);
        } else {
            $this->DefaultAccountID = $defaultAccountID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\AccountGroup
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Expense value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getExpense()
    {
        return isset($this->Expense) ? $this->Expense : null;
    }
    /**
     * Set Expense value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $expense
     * @return \StructType\AccountGroup
     */
    public function setExpense(\StructType\BooleanValue $expense = null)
    {
        if (is_null($expense) || (is_array($expense) && empty($expense))) {
            unset($this->Expense);
        } else {
            $this->Expense = $expense;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getSortOrder()
    {
        return isset($this->SortOrder) ? $this->SortOrder : null;
    }
    /**
     * Set SortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $sortOrder
     * @return \StructType\AccountGroup
     */
    public function setSortOrder(\StructType\ShortValue $sortOrder = null)
    {
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->SortOrder);
        } else {
            $this->SortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\AccountGroup
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
