<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailsRow StructType
 * @subpackage Structs
 */
class AccountDetailsRow extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Account;
    /**
     * The BatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BatchNbr;
    /**
     * The BeginingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BeginingBalance;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The CreditAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CreditAmount;
    /**
     * The CurrencyBeginingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrencyBeginingBalance;
    /**
     * The CurrencyCreditAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrencyCreditAmount;
    /**
     * The CurrencyDebitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrencyDebitAmount;
    /**
     * The CurrencyEndingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrencyEndingBalance;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The DebitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DebitAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EndingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $EndingBalance;
    /**
     * The IncludedinReclassHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludedinReclassHistory;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The Module
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Module;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Period;
    /**
     * The ReclassBatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReclassBatchNbr;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Selected;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subaccount;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $TransactionDate;
    /**
     * The VendorOrCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorOrCustomer;
    /**
     * Constructor method for AccountDetailsRow
     * @uses AccountDetailsRow::setAccount()
     * @uses AccountDetailsRow::setBatchNbr()
     * @uses AccountDetailsRow::setBeginingBalance()
     * @uses AccountDetailsRow::setBranch()
     * @uses AccountDetailsRow::setCreditAmount()
     * @uses AccountDetailsRow::setCurrencyBeginingBalance()
     * @uses AccountDetailsRow::setCurrencyCreditAmount()
     * @uses AccountDetailsRow::setCurrencyDebitAmount()
     * @uses AccountDetailsRow::setCurrencyEndingBalance()
     * @uses AccountDetailsRow::setCurrencyID()
     * @uses AccountDetailsRow::setDebitAmount()
     * @uses AccountDetailsRow::setDescription()
     * @uses AccountDetailsRow::setEndingBalance()
     * @uses AccountDetailsRow::setIncludedinReclassHistory()
     * @uses AccountDetailsRow::setInventoryID()
     * @uses AccountDetailsRow::setLineNbr()
     * @uses AccountDetailsRow::setModule()
     * @uses AccountDetailsRow::setPeriod()
     * @uses AccountDetailsRow::setReclassBatchNbr()
     * @uses AccountDetailsRow::setReferenceNbr()
     * @uses AccountDetailsRow::setSelected()
     * @uses AccountDetailsRow::setSubaccount()
     * @uses AccountDetailsRow::setTransactionDate()
     * @uses AccountDetailsRow::setVendorOrCustomer()
     * @param \StructType\StringValue $account
     * @param \StructType\StringValue $batchNbr
     * @param \StructType\DecimalValue $beginingBalance
     * @param \StructType\StringValue $branch
     * @param \StructType\DecimalValue $creditAmount
     * @param \StructType\DecimalValue $currencyBeginingBalance
     * @param \StructType\DecimalValue $currencyCreditAmount
     * @param \StructType\DecimalValue $currencyDebitAmount
     * @param \StructType\DecimalValue $currencyEndingBalance
     * @param \StructType\StringValue $currencyID
     * @param \StructType\DecimalValue $debitAmount
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $endingBalance
     * @param \StructType\BooleanValue $includedinReclassHistory
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\StringValue $module
     * @param \StructType\StringValue $period
     * @param \StructType\StringValue $reclassBatchNbr
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\BooleanValue $selected
     * @param \StructType\StringValue $subaccount
     * @param \StructType\DateTimeValue $transactionDate
     * @param \StructType\StringValue $vendorOrCustomer
     */
    public function __construct(\StructType\StringValue $account = null, \StructType\StringValue $batchNbr = null, \StructType\DecimalValue $beginingBalance = null, \StructType\StringValue $branch = null, \StructType\DecimalValue $creditAmount = null, \StructType\DecimalValue $currencyBeginingBalance = null, \StructType\DecimalValue $currencyCreditAmount = null, \StructType\DecimalValue $currencyDebitAmount = null, \StructType\DecimalValue $currencyEndingBalance = null, \StructType\StringValue $currencyID = null, \StructType\DecimalValue $debitAmount = null, \StructType\StringValue $description = null, \StructType\DecimalValue $endingBalance = null, \StructType\BooleanValue $includedinReclassHistory = null, \StructType\StringValue $inventoryID = null, \StructType\IntValue $lineNbr = null, \StructType\StringValue $module = null, \StructType\StringValue $period = null, \StructType\StringValue $reclassBatchNbr = null, \StructType\StringValue $referenceNbr = null, \StructType\BooleanValue $selected = null, \StructType\StringValue $subaccount = null, \StructType\DateTimeValue $transactionDate = null, \StructType\StringValue $vendorOrCustomer = null)
    {
        $this
            ->setAccount($account)
            ->setBatchNbr($batchNbr)
            ->setBeginingBalance($beginingBalance)
            ->setBranch($branch)
            ->setCreditAmount($creditAmount)
            ->setCurrencyBeginingBalance($currencyBeginingBalance)
            ->setCurrencyCreditAmount($currencyCreditAmount)
            ->setCurrencyDebitAmount($currencyDebitAmount)
            ->setCurrencyEndingBalance($currencyEndingBalance)
            ->setCurrencyID($currencyID)
            ->setDebitAmount($debitAmount)
            ->setDescription($description)
            ->setEndingBalance($endingBalance)
            ->setIncludedinReclassHistory($includedinReclassHistory)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setModule($module)
            ->setPeriod($period)
            ->setReclassBatchNbr($reclassBatchNbr)
            ->setReferenceNbr($referenceNbr)
            ->setSelected($selected)
            ->setSubaccount($subaccount)
            ->setTransactionDate($transactionDate)
            ->setVendorOrCustomer($vendorOrCustomer);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $account
     * @return \StructType\AccountDetailsRow
     */
    public function setAccount(\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get BatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBatchNbr()
    {
        return isset($this->BatchNbr) ? $this->BatchNbr : null;
    }
    /**
     * Set BatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $batchNbr
     * @return \StructType\AccountDetailsRow
     */
    public function setBatchNbr(\StructType\StringValue $batchNbr = null)
    {
        if (is_null($batchNbr) || (is_array($batchNbr) && empty($batchNbr))) {
            unset($this->BatchNbr);
        } else {
            $this->BatchNbr = $batchNbr;
        }
        return $this;
    }
    /**
     * Get BeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBeginingBalance()
    {
        return isset($this->BeginingBalance) ? $this->BeginingBalance : null;
    }
    /**
     * Set BeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $beginingBalance
     * @return \StructType\AccountDetailsRow
     */
    public function setBeginingBalance(\StructType\DecimalValue $beginingBalance = null)
    {
        if (is_null($beginingBalance) || (is_array($beginingBalance) && empty($beginingBalance))) {
            unset($this->BeginingBalance);
        } else {
            $this->BeginingBalance = $beginingBalance;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\AccountDetailsRow
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCreditAmount()
    {
        return isset($this->CreditAmount) ? $this->CreditAmount : null;
    }
    /**
     * Set CreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $creditAmount
     * @return \StructType\AccountDetailsRow
     */
    public function setCreditAmount(\StructType\DecimalValue $creditAmount = null)
    {
        if (is_null($creditAmount) || (is_array($creditAmount) && empty($creditAmount))) {
            unset($this->CreditAmount);
        } else {
            $this->CreditAmount = $creditAmount;
        }
        return $this;
    }
    /**
     * Get CurrencyBeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrencyBeginingBalance()
    {
        return isset($this->CurrencyBeginingBalance) ? $this->CurrencyBeginingBalance : null;
    }
    /**
     * Set CurrencyBeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currencyBeginingBalance
     * @return \StructType\AccountDetailsRow
     */
    public function setCurrencyBeginingBalance(\StructType\DecimalValue $currencyBeginingBalance = null)
    {
        if (is_null($currencyBeginingBalance) || (is_array($currencyBeginingBalance) && empty($currencyBeginingBalance))) {
            unset($this->CurrencyBeginingBalance);
        } else {
            $this->CurrencyBeginingBalance = $currencyBeginingBalance;
        }
        return $this;
    }
    /**
     * Get CurrencyCreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrencyCreditAmount()
    {
        return isset($this->CurrencyCreditAmount) ? $this->CurrencyCreditAmount : null;
    }
    /**
     * Set CurrencyCreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currencyCreditAmount
     * @return \StructType\AccountDetailsRow
     */
    public function setCurrencyCreditAmount(\StructType\DecimalValue $currencyCreditAmount = null)
    {
        if (is_null($currencyCreditAmount) || (is_array($currencyCreditAmount) && empty($currencyCreditAmount))) {
            unset($this->CurrencyCreditAmount);
        } else {
            $this->CurrencyCreditAmount = $currencyCreditAmount;
        }
        return $this;
    }
    /**
     * Get CurrencyDebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrencyDebitAmount()
    {
        return isset($this->CurrencyDebitAmount) ? $this->CurrencyDebitAmount : null;
    }
    /**
     * Set CurrencyDebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currencyDebitAmount
     * @return \StructType\AccountDetailsRow
     */
    public function setCurrencyDebitAmount(\StructType\DecimalValue $currencyDebitAmount = null)
    {
        if (is_null($currencyDebitAmount) || (is_array($currencyDebitAmount) && empty($currencyDebitAmount))) {
            unset($this->CurrencyDebitAmount);
        } else {
            $this->CurrencyDebitAmount = $currencyDebitAmount;
        }
        return $this;
    }
    /**
     * Get CurrencyEndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrencyEndingBalance()
    {
        return isset($this->CurrencyEndingBalance) ? $this->CurrencyEndingBalance : null;
    }
    /**
     * Set CurrencyEndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currencyEndingBalance
     * @return \StructType\AccountDetailsRow
     */
    public function setCurrencyEndingBalance(\StructType\DecimalValue $currencyEndingBalance = null)
    {
        if (is_null($currencyEndingBalance) || (is_array($currencyEndingBalance) && empty($currencyEndingBalance))) {
            unset($this->CurrencyEndingBalance);
        } else {
            $this->CurrencyEndingBalance = $currencyEndingBalance;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\AccountDetailsRow
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get DebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDebitAmount()
    {
        return isset($this->DebitAmount) ? $this->DebitAmount : null;
    }
    /**
     * Set DebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $debitAmount
     * @return \StructType\AccountDetailsRow
     */
    public function setDebitAmount(\StructType\DecimalValue $debitAmount = null)
    {
        if (is_null($debitAmount) || (is_array($debitAmount) && empty($debitAmount))) {
            unset($this->DebitAmount);
        } else {
            $this->DebitAmount = $debitAmount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\AccountDetailsRow
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getEndingBalance()
    {
        return isset($this->EndingBalance) ? $this->EndingBalance : null;
    }
    /**
     * Set EndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $endingBalance
     * @return \StructType\AccountDetailsRow
     */
    public function setEndingBalance(\StructType\DecimalValue $endingBalance = null)
    {
        if (is_null($endingBalance) || (is_array($endingBalance) && empty($endingBalance))) {
            unset($this->EndingBalance);
        } else {
            $this->EndingBalance = $endingBalance;
        }
        return $this;
    }
    /**
     * Get IncludedinReclassHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludedinReclassHistory()
    {
        return isset($this->IncludedinReclassHistory) ? $this->IncludedinReclassHistory : null;
    }
    /**
     * Set IncludedinReclassHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includedinReclassHistory
     * @return \StructType\AccountDetailsRow
     */
    public function setIncludedinReclassHistory(\StructType\BooleanValue $includedinReclassHistory = null)
    {
        if (is_null($includedinReclassHistory) || (is_array($includedinReclassHistory) && empty($includedinReclassHistory))) {
            unset($this->IncludedinReclassHistory);
        } else {
            $this->IncludedinReclassHistory = $includedinReclassHistory;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\AccountDetailsRow
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\AccountDetailsRow
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get Module value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getModule()
    {
        return isset($this->Module) ? $this->Module : null;
    }
    /**
     * Set Module value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $module
     * @return \StructType\AccountDetailsRow
     */
    public function setModule(\StructType\StringValue $module = null)
    {
        if (is_null($module) || (is_array($module) && empty($module))) {
            unset($this->Module);
        } else {
            $this->Module = $module;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $period
     * @return \StructType\AccountDetailsRow
     */
    public function setPeriod(\StructType\StringValue $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get ReclassBatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReclassBatchNbr()
    {
        return isset($this->ReclassBatchNbr) ? $this->ReclassBatchNbr : null;
    }
    /**
     * Set ReclassBatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reclassBatchNbr
     * @return \StructType\AccountDetailsRow
     */
    public function setReclassBatchNbr(\StructType\StringValue $reclassBatchNbr = null)
    {
        if (is_null($reclassBatchNbr) || (is_array($reclassBatchNbr) && empty($reclassBatchNbr))) {
            unset($this->ReclassBatchNbr);
        } else {
            $this->ReclassBatchNbr = $reclassBatchNbr;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\AccountDetailsRow
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $selected
     * @return \StructType\AccountDetailsRow
     */
    public function setSelected(\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subaccount
     * @return \StructType\AccountDetailsRow
     */
    public function setSubaccount(\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $transactionDate
     * @return \StructType\AccountDetailsRow
     */
    public function setTransactionDate(\StructType\DateTimeValue $transactionDate = null)
    {
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get VendorOrCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorOrCustomer()
    {
        return isset($this->VendorOrCustomer) ? $this->VendorOrCustomer : null;
    }
    /**
     * Set VendorOrCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorOrCustomer
     * @return \StructType\AccountDetailsRow
     */
    public function setVendorOrCustomer(\StructType\StringValue $vendorOrCustomer = null)
    {
        if (is_null($vendorOrCustomer) || (is_array($vendorOrCustomer) && empty($vendorOrCustomer))) {
            unset($this->VendorOrCustomer);
        } else {
            $this->VendorOrCustomer = $vendorOrCustomer;
        }
        return $this;
    }
}
