<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * @subpackage Structs
 */
class Account extends Entity
{
    /**
     * The AccountCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountCD;
    /**
     * The AccountClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountClass;
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $AccountID;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CashAccount;
    /**
     * The ChartOfAccountsOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $ChartOfAccountsOrder;
    /**
     * The ConsolidationAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ConsolidationAccount;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The PostOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PostOption;
    /**
     * The RequireUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RequireUnits;
    /**
     * The RevaluationRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RevaluationRateType;
    /**
     * The Secured
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Secured;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The UseDefaultSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $UseDefaultSubaccount;
    /**
     * Constructor method for Account
     * @uses Account::setAccountCD()
     * @uses Account::setAccountClass()
     * @uses Account::setAccountGroup()
     * @uses Account::setAccountID()
     * @uses Account::setActive()
     * @uses Account::setCashAccount()
     * @uses Account::setChartOfAccountsOrder()
     * @uses Account::setConsolidationAccount()
     * @uses Account::setCreatedDateTime()
     * @uses Account::setCurrencyID()
     * @uses Account::setDescription()
     * @uses Account::setLastModifiedDateTime()
     * @uses Account::setPostOption()
     * @uses Account::setRequireUnits()
     * @uses Account::setRevaluationRateType()
     * @uses Account::setSecured()
     * @uses Account::setTaxCategory()
     * @uses Account::setType()
     * @uses Account::setUseDefaultSubaccount()
     * @param \StructType\StringValue $accountCD
     * @param \StructType\StringValue $accountClass
     * @param \StructType\StringValue $accountGroup
     * @param \StructType\IntValue $accountID
     * @param \StructType\BooleanValue $active
     * @param \StructType\BooleanValue $cashAccount
     * @param \StructType\IntValue $chartOfAccountsOrder
     * @param \StructType\StringValue $consolidationAccount
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $currencyID
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $postOption
     * @param \StructType\BooleanValue $requireUnits
     * @param \StructType\StringValue $revaluationRateType
     * @param \StructType\BooleanValue $secured
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\StringValue $type
     * @param \StructType\BooleanValue $useDefaultSubaccount
     */
    public function __construct(\StructType\StringValue $accountCD = null, \StructType\StringValue $accountClass = null, \StructType\StringValue $accountGroup = null, \StructType\IntValue $accountID = null, \StructType\BooleanValue $active = null, \StructType\BooleanValue $cashAccount = null, \StructType\IntValue $chartOfAccountsOrder = null, \StructType\StringValue $consolidationAccount = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $currencyID = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $postOption = null, \StructType\BooleanValue $requireUnits = null, \StructType\StringValue $revaluationRateType = null, \StructType\BooleanValue $secured = null, \StructType\StringValue $taxCategory = null, \StructType\StringValue $type = null, \StructType\BooleanValue $useDefaultSubaccount = null)
    {
        $this
            ->setAccountCD($accountCD)
            ->setAccountClass($accountClass)
            ->setAccountGroup($accountGroup)
            ->setAccountID($accountID)
            ->setActive($active)
            ->setCashAccount($cashAccount)
            ->setChartOfAccountsOrder($chartOfAccountsOrder)
            ->setConsolidationAccount($consolidationAccount)
            ->setCreatedDateTime($createdDateTime)
            ->setCurrencyID($currencyID)
            ->setDescription($description)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setPostOption($postOption)
            ->setRequireUnits($requireUnits)
            ->setRevaluationRateType($revaluationRateType)
            ->setSecured($secured)
            ->setTaxCategory($taxCategory)
            ->setType($type)
            ->setUseDefaultSubaccount($useDefaultSubaccount);
    }
    /**
     * Get AccountCD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountCD()
    {
        return isset($this->AccountCD) ? $this->AccountCD : null;
    }
    /**
     * Set AccountCD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountCD
     * @return \StructType\Account
     */
    public function setAccountCD(\StructType\StringValue $accountCD = null)
    {
        if (is_null($accountCD) || (is_array($accountCD) && empty($accountCD))) {
            unset($this->AccountCD);
        } else {
            $this->AccountCD = $accountCD;
        }
        return $this;
    }
    /**
     * Get AccountClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountClass()
    {
        return isset($this->AccountClass) ? $this->AccountClass : null;
    }
    /**
     * Set AccountClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountClass
     * @return \StructType\Account
     */
    public function setAccountClass(\StructType\StringValue $accountClass = null)
    {
        if (is_null($accountClass) || (is_array($accountClass) && empty($accountClass))) {
            unset($this->AccountClass);
        } else {
            $this->AccountClass = $accountClass;
        }
        return $this;
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroup
     * @return \StructType\Account
     */
    public function setAccountGroup(\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get AccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getAccountID()
    {
        return isset($this->AccountID) ? $this->AccountID : null;
    }
    /**
     * Set AccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $accountID
     * @return \StructType\Account
     */
    public function setAccountID(\StructType\IntValue $accountID = null)
    {
        if (is_null($accountID) || (is_array($accountID) && empty($accountID))) {
            unset($this->AccountID);
        } else {
            $this->AccountID = $accountID;
        }
        return $this;
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\Account
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $cashAccount
     * @return \StructType\Account
     */
    public function setCashAccount(\StructType\BooleanValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get ChartOfAccountsOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getChartOfAccountsOrder()
    {
        return isset($this->ChartOfAccountsOrder) ? $this->ChartOfAccountsOrder : null;
    }
    /**
     * Set ChartOfAccountsOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $chartOfAccountsOrder
     * @return \StructType\Account
     */
    public function setChartOfAccountsOrder(\StructType\IntValue $chartOfAccountsOrder = null)
    {
        if (is_null($chartOfAccountsOrder) || (is_array($chartOfAccountsOrder) && empty($chartOfAccountsOrder))) {
            unset($this->ChartOfAccountsOrder);
        } else {
            $this->ChartOfAccountsOrder = $chartOfAccountsOrder;
        }
        return $this;
    }
    /**
     * Get ConsolidationAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getConsolidationAccount()
    {
        return isset($this->ConsolidationAccount) ? $this->ConsolidationAccount : null;
    }
    /**
     * Set ConsolidationAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $consolidationAccount
     * @return \StructType\Account
     */
    public function setConsolidationAccount(\StructType\StringValue $consolidationAccount = null)
    {
        if (is_null($consolidationAccount) || (is_array($consolidationAccount) && empty($consolidationAccount))) {
            unset($this->ConsolidationAccount);
        } else {
            $this->ConsolidationAccount = $consolidationAccount;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\Account
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\Account
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Account
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\Account
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get PostOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPostOption()
    {
        return isset($this->PostOption) ? $this->PostOption : null;
    }
    /**
     * Set PostOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $postOption
     * @return \StructType\Account
     */
    public function setPostOption(\StructType\StringValue $postOption = null)
    {
        if (is_null($postOption) || (is_array($postOption) && empty($postOption))) {
            unset($this->PostOption);
        } else {
            $this->PostOption = $postOption;
        }
        return $this;
    }
    /**
     * Get RequireUnits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequireUnits()
    {
        return isset($this->RequireUnits) ? $this->RequireUnits : null;
    }
    /**
     * Set RequireUnits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $requireUnits
     * @return \StructType\Account
     */
    public function setRequireUnits(\StructType\BooleanValue $requireUnits = null)
    {
        if (is_null($requireUnits) || (is_array($requireUnits) && empty($requireUnits))) {
            unset($this->RequireUnits);
        } else {
            $this->RequireUnits = $requireUnits;
        }
        return $this;
    }
    /**
     * Get RevaluationRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRevaluationRateType()
    {
        return isset($this->RevaluationRateType) ? $this->RevaluationRateType : null;
    }
    /**
     * Set RevaluationRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $revaluationRateType
     * @return \StructType\Account
     */
    public function setRevaluationRateType(\StructType\StringValue $revaluationRateType = null)
    {
        if (is_null($revaluationRateType) || (is_array($revaluationRateType) && empty($revaluationRateType))) {
            unset($this->RevaluationRateType);
        } else {
            $this->RevaluationRateType = $revaluationRateType;
        }
        return $this;
    }
    /**
     * Get Secured value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSecured()
    {
        return isset($this->Secured) ? $this->Secured : null;
    }
    /**
     * Set Secured value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $secured
     * @return \StructType\Account
     */
    public function setSecured(\StructType\BooleanValue $secured = null)
    {
        if (is_null($secured) || (is_array($secured) && empty($secured))) {
            unset($this->Secured);
        } else {
            $this->Secured = $secured;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\Account
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\Account
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UseDefaultSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getUseDefaultSubaccount()
    {
        return isset($this->UseDefaultSubaccount) ? $this->UseDefaultSubaccount : null;
    }
    /**
     * Set UseDefaultSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $useDefaultSubaccount
     * @return \StructType\Account
     */
    public function setUseDefaultSubaccount(\StructType\BooleanValue $useDefaultSubaccount = null)
    {
        if (is_null($useDefaultSubaccount) || (is_array($useDefaultSubaccount) && empty($useDefaultSubaccount))) {
            unset($this->UseDefaultSubaccount);
        } else {
            $this->UseDefaultSubaccount = $useDefaultSubaccount;
        }
        return $this;
    }
}
