<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetList $parameters
     * @return \StructType\GetListResponse|bool
     */
    public function GetList(\StructType\GetList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get $parameters
     * @return \StructType\GetResponse|bool
     */
    public function Get(\StructType\Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomFieldSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomFieldSchema $parameters
     * @return \StructType\GetCustomFieldSchemaResponse|bool
     */
    public function GetCustomFieldSchema(\StructType\GetCustomFieldSchema $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomFieldSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProcessStatus $parameters
     * @return \StructType\GetProcessStatusResponse|bool
     */
    public function GetProcessStatus(\StructType\GetProcessStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFiles $parameters
     * @return \StructType\GetFilesResponse|bool
     */
    public function GetFiles(\StructType\GetFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCustomFieldSchemaResponse|\StructType\GetFilesResponse|\StructType\GetListResponse|\StructType\GetProcessStatusResponse|\StructType\GetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
