<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BooleanCondition EnumType
 * @subpackage Enumerations
 */
class BooleanCondition extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Equal'
     * @return string 'Equal'
     */
    const VALUE_EQUAL = 'Equal';
    /**
     * Constant for value 'NotEqual'
     * @return string 'NotEqual'
     */
    const VALUE_NOT_EQUAL = 'NotEqual';
    /**
     * Constant for value 'IsNull'
     * @return string 'IsNull'
     */
    const VALUE_IS_NULL = 'IsNull';
    /**
     * Constant for value 'IsNotNull'
     * @return string 'IsNotNull'
     */
    const VALUE_IS_NOT_NULL = 'IsNotNull';
    /**
     * Return allowed values
     * @uses self::VALUE_EQUAL
     * @uses self::VALUE_NOT_EQUAL
     * @uses self::VALUE_IS_NULL
     * @uses self::VALUE_IS_NOT_NULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUAL,
            self::VALUE_NOT_EQUAL,
            self::VALUE_IS_NULL,
            self::VALUE_IS_NOT_NULL,
        );
    }
}
