<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zones StructType
 * @subpackage Structs
 */
class Zones extends AbstractStructBase
{
    /**
     * The TaxZoneDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxZoneDetail[]
     */
    public $TaxZoneDetail;
    /**
     * Constructor method for Zones
     * @uses Zones::setTaxZoneDetail()
     * @param \StructType\TaxZoneDetail[] $taxZoneDetail
     */
    public function __construct(array $taxZoneDetail = array())
    {
        $this
            ->setTaxZoneDetail($taxZoneDetail);
    }
    /**
     * Get TaxZoneDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxZoneDetail[]|null
     */
    public function getTaxZoneDetail()
    {
        return isset($this->TaxZoneDetail) ? $this->TaxZoneDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxZoneDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxZoneDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxZoneDetailForArrayConstraintsFromSetTaxZoneDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zonesTaxZoneDetailItem) {
            // validation for constraint: itemType
            if (!$zonesTaxZoneDetailItem instanceof \StructType\TaxZoneDetail) {
                $invalidValues[] = is_object($zonesTaxZoneDetailItem) ? get_class($zonesTaxZoneDetailItem) : sprintf('%s(%s)', gettype($zonesTaxZoneDetailItem), var_export($zonesTaxZoneDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxZoneDetail property can only contain items of type \StructType\TaxZoneDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxZoneDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TaxZoneDetail[] $taxZoneDetail
     * @return \StructType\Zones
     */
    public function setTaxZoneDetail(array $taxZoneDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($taxZoneDetailArrayErrorMessage = self::validateTaxZoneDetailForArrayConstraintsFromSetTaxZoneDetail($taxZoneDetail))) {
            throw new \InvalidArgumentException($taxZoneDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($taxZoneDetail) || (is_array($taxZoneDetail) && empty($taxZoneDetail))) {
            unset($this->TaxZoneDetail);
        } else {
            $this->TaxZoneDetail = $taxZoneDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxZoneDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxZoneDetail $item
     * @return \StructType\Zones
     */
    public function addToTaxZoneDetail(\StructType\TaxZoneDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxZoneDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxZoneDetail property can only contain items of type \StructType\TaxZoneDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxZoneDetail[] = $item;
        return $this;
    }
}
