<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseLocation StructType
 * @subpackage Structs
 */
class WarehouseLocation extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The AssemblyAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AssemblyAllowed;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The PickPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $PickPriority;
    /**
     * The ReceiptsAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ReceiptsAllowed;
    /**
     * The SalesAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SalesAllowed;
    /**
     * The TransfersAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $TransfersAllowed;
    /**
     * Constructor method for WarehouseLocation
     * @uses WarehouseLocation::setActive()
     * @uses WarehouseLocation::setAssemblyAllowed()
     * @uses WarehouseLocation::setDescription()
     * @uses WarehouseLocation::setLocationID()
     * @uses WarehouseLocation::setPickPriority()
     * @uses WarehouseLocation::setReceiptsAllowed()
     * @uses WarehouseLocation::setSalesAllowed()
     * @uses WarehouseLocation::setTransfersAllowed()
     * @param \StructType\BooleanValue $active
     * @param \StructType\BooleanValue $assemblyAllowed
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $locationID
     * @param \StructType\ShortValue $pickPriority
     * @param \StructType\BooleanValue $receiptsAllowed
     * @param \StructType\BooleanValue $salesAllowed
     * @param \StructType\BooleanValue $transfersAllowed
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\BooleanValue $assemblyAllowed = null, \StructType\StringValue $description = null, \StructType\StringValue $locationID = null, \StructType\ShortValue $pickPriority = null, \StructType\BooleanValue $receiptsAllowed = null, \StructType\BooleanValue $salesAllowed = null, \StructType\BooleanValue $transfersAllowed = null)
    {
        $this
            ->setActive($active)
            ->setAssemblyAllowed($assemblyAllowed)
            ->setDescription($description)
            ->setLocationID($locationID)
            ->setPickPriority($pickPriority)
            ->setReceiptsAllowed($receiptsAllowed)
            ->setSalesAllowed($salesAllowed)
            ->setTransfersAllowed($transfersAllowed);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\WarehouseLocation
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AssemblyAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAssemblyAllowed()
    {
        return isset($this->AssemblyAllowed) ? $this->AssemblyAllowed : null;
    }
    /**
     * Set AssemblyAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $assemblyAllowed
     * @return \StructType\WarehouseLocation
     */
    public function setAssemblyAllowed(\StructType\BooleanValue $assemblyAllowed = null)
    {
        if (is_null($assemblyAllowed) || (is_array($assemblyAllowed) && empty($assemblyAllowed))) {
            unset($this->AssemblyAllowed);
        } else {
            $this->AssemblyAllowed = $assemblyAllowed;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\WarehouseLocation
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\WarehouseLocation
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get PickPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getPickPriority()
    {
        return isset($this->PickPriority) ? $this->PickPriority : null;
    }
    /**
     * Set PickPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $pickPriority
     * @return \StructType\WarehouseLocation
     */
    public function setPickPriority(\StructType\ShortValue $pickPriority = null)
    {
        if (is_null($pickPriority) || (is_array($pickPriority) && empty($pickPriority))) {
            unset($this->PickPriority);
        } else {
            $this->PickPriority = $pickPriority;
        }
        return $this;
    }
    /**
     * Get ReceiptsAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getReceiptsAllowed()
    {
        return isset($this->ReceiptsAllowed) ? $this->ReceiptsAllowed : null;
    }
    /**
     * Set ReceiptsAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $receiptsAllowed
     * @return \StructType\WarehouseLocation
     */
    public function setReceiptsAllowed(\StructType\BooleanValue $receiptsAllowed = null)
    {
        if (is_null($receiptsAllowed) || (is_array($receiptsAllowed) && empty($receiptsAllowed))) {
            unset($this->ReceiptsAllowed);
        } else {
            $this->ReceiptsAllowed = $receiptsAllowed;
        }
        return $this;
    }
    /**
     * Get SalesAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSalesAllowed()
    {
        return isset($this->SalesAllowed) ? $this->SalesAllowed : null;
    }
    /**
     * Set SalesAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $salesAllowed
     * @return \StructType\WarehouseLocation
     */
    public function setSalesAllowed(\StructType\BooleanValue $salesAllowed = null)
    {
        if (is_null($salesAllowed) || (is_array($salesAllowed) && empty($salesAllowed))) {
            unset($this->SalesAllowed);
        } else {
            $this->SalesAllowed = $salesAllowed;
        }
        return $this;
    }
    /**
     * Get TransfersAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getTransfersAllowed()
    {
        return isset($this->TransfersAllowed) ? $this->TransfersAllowed : null;
    }
    /**
     * Set TransfersAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $transfersAllowed
     * @return \StructType\WarehouseLocation
     */
    public function setTransfersAllowed(\StructType\BooleanValue $transfersAllowed = null)
    {
        if (is_null($transfersAllowed) || (is_array($transfersAllowed) && empty($transfersAllowed))) {
            unset($this->TransfersAllowed);
        } else {
            $this->TransfersAllowed = $transfersAllowed;
        }
        return $this;
    }
}
