<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warehouse StructType
 * @subpackage Structs
 */
class Warehouse extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The COGSExpenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $COGSExpenseAccount;
    /**
     * The COGSExpenseSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $COGSExpenseSubaccount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountAccount;
    /**
     * The DiscountSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountSubaccount;
    /**
     * The DropShipLocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DropShipLocationID;
    /**
     * The FreightChargeAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FreightChargeAccount;
    /**
     * The FreightChargeSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FreightChargeSubaccount;
    /**
     * The InventoryAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryAccount;
    /**
     * The InventorySubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventorySubaccount;
    /**
     * The LandedCostVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LandedCostVarianceAccount;
    /**
     * The LandedCostVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LandedCostVarianceSubaccount;
    /**
     * The Locations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Locations
     */
    public $Locations;
    /**
     * The MiscChargeAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $MiscChargeAccount;
    /**
     * The MiscChargeSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $MiscChargeSubaccount;
    /**
     * The OverrideInventoryAccountSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $OverrideInventoryAccountSubaccount;
    /**
     * The POAccrualAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POAccrualAccount;
    /**
     * The POAccrualSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POAccrualSubaccount;
    /**
     * The PurchasePriceVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PurchasePriceVarianceAccount;
    /**
     * The PurchasePriceVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PurchasePriceVarianceSubaccount;
    /**
     * The ReasonCodeSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReasonCodeSubaccount;
    /**
     * The ReceivingLocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReceivingLocationID;
    /**
     * The RMALocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RMALocationID;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The ShippingLocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingLocationID;
    /**
     * The StandardCostRevaluationAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StandardCostRevaluationAccount;
    /**
     * The StandardCostRevaluationSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StandardCostRevaluationSubaccount;
    /**
     * The StandardCostVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StandardCostVarianceAccount;
    /**
     * The StandardCostVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StandardCostVarianceSubaccount;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for Warehouse
     * @uses Warehouse::setActive()
     * @uses Warehouse::setCOGSExpenseAccount()
     * @uses Warehouse::setCOGSExpenseSubaccount()
     * @uses Warehouse::setDescription()
     * @uses Warehouse::setDiscountAccount()
     * @uses Warehouse::setDiscountSubaccount()
     * @uses Warehouse::setDropShipLocationID()
     * @uses Warehouse::setFreightChargeAccount()
     * @uses Warehouse::setFreightChargeSubaccount()
     * @uses Warehouse::setInventoryAccount()
     * @uses Warehouse::setInventorySubaccount()
     * @uses Warehouse::setLandedCostVarianceAccount()
     * @uses Warehouse::setLandedCostVarianceSubaccount()
     * @uses Warehouse::setLocations()
     * @uses Warehouse::setMiscChargeAccount()
     * @uses Warehouse::setMiscChargeSubaccount()
     * @uses Warehouse::setOverrideInventoryAccountSubaccount()
     * @uses Warehouse::setPOAccrualAccount()
     * @uses Warehouse::setPOAccrualSubaccount()
     * @uses Warehouse::setPurchasePriceVarianceAccount()
     * @uses Warehouse::setPurchasePriceVarianceSubaccount()
     * @uses Warehouse::setReasonCodeSubaccount()
     * @uses Warehouse::setReceivingLocationID()
     * @uses Warehouse::setRMALocationID()
     * @uses Warehouse::setSalesAccount()
     * @uses Warehouse::setSalesSubaccount()
     * @uses Warehouse::setShippingLocationID()
     * @uses Warehouse::setStandardCostRevaluationAccount()
     * @uses Warehouse::setStandardCostRevaluationSubaccount()
     * @uses Warehouse::setStandardCostVarianceAccount()
     * @uses Warehouse::setStandardCostVarianceSubaccount()
     * @uses Warehouse::setWarehouseID()
     * @param \StructType\BooleanValue $active
     * @param \StructType\StringValue $cOGSExpenseAccount
     * @param \StructType\StringValue $cOGSExpenseSubaccount
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $discountAccount
     * @param \StructType\StringValue $discountSubaccount
     * @param \StructType\StringValue $dropShipLocationID
     * @param \StructType\StringValue $freightChargeAccount
     * @param \StructType\StringValue $freightChargeSubaccount
     * @param \StructType\StringValue $inventoryAccount
     * @param \StructType\StringValue $inventorySubaccount
     * @param \StructType\StringValue $landedCostVarianceAccount
     * @param \StructType\StringValue $landedCostVarianceSubaccount
     * @param \StructType\Locations $locations
     * @param \StructType\StringValue $miscChargeAccount
     * @param \StructType\StringValue $miscChargeSubaccount
     * @param \StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @param \StructType\StringValue $pOAccrualAccount
     * @param \StructType\StringValue $pOAccrualSubaccount
     * @param \StructType\StringValue $purchasePriceVarianceAccount
     * @param \StructType\StringValue $purchasePriceVarianceSubaccount
     * @param \StructType\StringValue $reasonCodeSubaccount
     * @param \StructType\StringValue $receivingLocationID
     * @param \StructType\StringValue $rMALocationID
     * @param \StructType\StringValue $salesAccount
     * @param \StructType\StringValue $salesSubaccount
     * @param \StructType\StringValue $shippingLocationID
     * @param \StructType\StringValue $standardCostRevaluationAccount
     * @param \StructType\StringValue $standardCostRevaluationSubaccount
     * @param \StructType\StringValue $standardCostVarianceAccount
     * @param \StructType\StringValue $standardCostVarianceSubaccount
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\StringValue $cOGSExpenseAccount = null, \StructType\StringValue $cOGSExpenseSubaccount = null, \StructType\StringValue $description = null, \StructType\StringValue $discountAccount = null, \StructType\StringValue $discountSubaccount = null, \StructType\StringValue $dropShipLocationID = null, \StructType\StringValue $freightChargeAccount = null, \StructType\StringValue $freightChargeSubaccount = null, \StructType\StringValue $inventoryAccount = null, \StructType\StringValue $inventorySubaccount = null, \StructType\StringValue $landedCostVarianceAccount = null, \StructType\StringValue $landedCostVarianceSubaccount = null, \StructType\Locations $locations = null, \StructType\StringValue $miscChargeAccount = null, \StructType\StringValue $miscChargeSubaccount = null, \StructType\BooleanValue $overrideInventoryAccountSubaccount = null, \StructType\StringValue $pOAccrualAccount = null, \StructType\StringValue $pOAccrualSubaccount = null, \StructType\StringValue $purchasePriceVarianceAccount = null, \StructType\StringValue $purchasePriceVarianceSubaccount = null, \StructType\StringValue $reasonCodeSubaccount = null, \StructType\StringValue $receivingLocationID = null, \StructType\StringValue $rMALocationID = null, \StructType\StringValue $salesAccount = null, \StructType\StringValue $salesSubaccount = null, \StructType\StringValue $shippingLocationID = null, \StructType\StringValue $standardCostRevaluationAccount = null, \StructType\StringValue $standardCostRevaluationSubaccount = null, \StructType\StringValue $standardCostVarianceAccount = null, \StructType\StringValue $standardCostVarianceSubaccount = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setActive($active)
            ->setCOGSExpenseAccount($cOGSExpenseAccount)
            ->setCOGSExpenseSubaccount($cOGSExpenseSubaccount)
            ->setDescription($description)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSubaccount($discountSubaccount)
            ->setDropShipLocationID($dropShipLocationID)
            ->setFreightChargeAccount($freightChargeAccount)
            ->setFreightChargeSubaccount($freightChargeSubaccount)
            ->setInventoryAccount($inventoryAccount)
            ->setInventorySubaccount($inventorySubaccount)
            ->setLandedCostVarianceAccount($landedCostVarianceAccount)
            ->setLandedCostVarianceSubaccount($landedCostVarianceSubaccount)
            ->setLocations($locations)
            ->setMiscChargeAccount($miscChargeAccount)
            ->setMiscChargeSubaccount($miscChargeSubaccount)
            ->setOverrideInventoryAccountSubaccount($overrideInventoryAccountSubaccount)
            ->setPOAccrualAccount($pOAccrualAccount)
            ->setPOAccrualSubaccount($pOAccrualSubaccount)
            ->setPurchasePriceVarianceAccount($purchasePriceVarianceAccount)
            ->setPurchasePriceVarianceSubaccount($purchasePriceVarianceSubaccount)
            ->setReasonCodeSubaccount($reasonCodeSubaccount)
            ->setReceivingLocationID($receivingLocationID)
            ->setRMALocationID($rMALocationID)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setShippingLocationID($shippingLocationID)
            ->setStandardCostRevaluationAccount($standardCostRevaluationAccount)
            ->setStandardCostRevaluationSubaccount($standardCostRevaluationSubaccount)
            ->setStandardCostVarianceAccount($standardCostVarianceAccount)
            ->setStandardCostVarianceSubaccount($standardCostVarianceSubaccount)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\Warehouse
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get COGSExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCOGSExpenseAccount()
    {
        return isset($this->COGSExpenseAccount) ? $this->COGSExpenseAccount : null;
    }
    /**
     * Set COGSExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cOGSExpenseAccount
     * @return \StructType\Warehouse
     */
    public function setCOGSExpenseAccount(\StructType\StringValue $cOGSExpenseAccount = null)
    {
        if (is_null($cOGSExpenseAccount) || (is_array($cOGSExpenseAccount) && empty($cOGSExpenseAccount))) {
            unset($this->COGSExpenseAccount);
        } else {
            $this->COGSExpenseAccount = $cOGSExpenseAccount;
        }
        return $this;
    }
    /**
     * Get COGSExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCOGSExpenseSubaccount()
    {
        return isset($this->COGSExpenseSubaccount) ? $this->COGSExpenseSubaccount : null;
    }
    /**
     * Set COGSExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cOGSExpenseSubaccount
     * @return \StructType\Warehouse
     */
    public function setCOGSExpenseSubaccount(\StructType\StringValue $cOGSExpenseSubaccount = null)
    {
        if (is_null($cOGSExpenseSubaccount) || (is_array($cOGSExpenseSubaccount) && empty($cOGSExpenseSubaccount))) {
            unset($this->COGSExpenseSubaccount);
        } else {
            $this->COGSExpenseSubaccount = $cOGSExpenseSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Warehouse
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountAccount()
    {
        return isset($this->DiscountAccount) ? $this->DiscountAccount : null;
    }
    /**
     * Set DiscountAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountAccount
     * @return \StructType\Warehouse
     */
    public function setDiscountAccount(\StructType\StringValue $discountAccount = null)
    {
        if (is_null($discountAccount) || (is_array($discountAccount) && empty($discountAccount))) {
            unset($this->DiscountAccount);
        } else {
            $this->DiscountAccount = $discountAccount;
        }
        return $this;
    }
    /**
     * Get DiscountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountSubaccount()
    {
        return isset($this->DiscountSubaccount) ? $this->DiscountSubaccount : null;
    }
    /**
     * Set DiscountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountSubaccount
     * @return \StructType\Warehouse
     */
    public function setDiscountSubaccount(\StructType\StringValue $discountSubaccount = null)
    {
        if (is_null($discountSubaccount) || (is_array($discountSubaccount) && empty($discountSubaccount))) {
            unset($this->DiscountSubaccount);
        } else {
            $this->DiscountSubaccount = $discountSubaccount;
        }
        return $this;
    }
    /**
     * Get DropShipLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDropShipLocationID()
    {
        return isset($this->DropShipLocationID) ? $this->DropShipLocationID : null;
    }
    /**
     * Set DropShipLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $dropShipLocationID
     * @return \StructType\Warehouse
     */
    public function setDropShipLocationID(\StructType\StringValue $dropShipLocationID = null)
    {
        if (is_null($dropShipLocationID) || (is_array($dropShipLocationID) && empty($dropShipLocationID))) {
            unset($this->DropShipLocationID);
        } else {
            $this->DropShipLocationID = $dropShipLocationID;
        }
        return $this;
    }
    /**
     * Get FreightChargeAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFreightChargeAccount()
    {
        return isset($this->FreightChargeAccount) ? $this->FreightChargeAccount : null;
    }
    /**
     * Set FreightChargeAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $freightChargeAccount
     * @return \StructType\Warehouse
     */
    public function setFreightChargeAccount(\StructType\StringValue $freightChargeAccount = null)
    {
        if (is_null($freightChargeAccount) || (is_array($freightChargeAccount) && empty($freightChargeAccount))) {
            unset($this->FreightChargeAccount);
        } else {
            $this->FreightChargeAccount = $freightChargeAccount;
        }
        return $this;
    }
    /**
     * Get FreightChargeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFreightChargeSubaccount()
    {
        return isset($this->FreightChargeSubaccount) ? $this->FreightChargeSubaccount : null;
    }
    /**
     * Set FreightChargeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $freightChargeSubaccount
     * @return \StructType\Warehouse
     */
    public function setFreightChargeSubaccount(\StructType\StringValue $freightChargeSubaccount = null)
    {
        if (is_null($freightChargeSubaccount) || (is_array($freightChargeSubaccount) && empty($freightChargeSubaccount))) {
            unset($this->FreightChargeSubaccount);
        } else {
            $this->FreightChargeSubaccount = $freightChargeSubaccount;
        }
        return $this;
    }
    /**
     * Get InventoryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryAccount()
    {
        return isset($this->InventoryAccount) ? $this->InventoryAccount : null;
    }
    /**
     * Set InventoryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryAccount
     * @return \StructType\Warehouse
     */
    public function setInventoryAccount(\StructType\StringValue $inventoryAccount = null)
    {
        if (is_null($inventoryAccount) || (is_array($inventoryAccount) && empty($inventoryAccount))) {
            unset($this->InventoryAccount);
        } else {
            $this->InventoryAccount = $inventoryAccount;
        }
        return $this;
    }
    /**
     * Get InventorySubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventorySubaccount()
    {
        return isset($this->InventorySubaccount) ? $this->InventorySubaccount : null;
    }
    /**
     * Set InventorySubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventorySubaccount
     * @return \StructType\Warehouse
     */
    public function setInventorySubaccount(\StructType\StringValue $inventorySubaccount = null)
    {
        if (is_null($inventorySubaccount) || (is_array($inventorySubaccount) && empty($inventorySubaccount))) {
            unset($this->InventorySubaccount);
        } else {
            $this->InventorySubaccount = $inventorySubaccount;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLandedCostVarianceAccount()
    {
        return isset($this->LandedCostVarianceAccount) ? $this->LandedCostVarianceAccount : null;
    }
    /**
     * Set LandedCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $landedCostVarianceAccount
     * @return \StructType\Warehouse
     */
    public function setLandedCostVarianceAccount(\StructType\StringValue $landedCostVarianceAccount = null)
    {
        if (is_null($landedCostVarianceAccount) || (is_array($landedCostVarianceAccount) && empty($landedCostVarianceAccount))) {
            unset($this->LandedCostVarianceAccount);
        } else {
            $this->LandedCostVarianceAccount = $landedCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLandedCostVarianceSubaccount()
    {
        return isset($this->LandedCostVarianceSubaccount) ? $this->LandedCostVarianceSubaccount : null;
    }
    /**
     * Set LandedCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $landedCostVarianceSubaccount
     * @return \StructType\Warehouse
     */
    public function setLandedCostVarianceSubaccount(\StructType\StringValue $landedCostVarianceSubaccount = null)
    {
        if (is_null($landedCostVarianceSubaccount) || (is_array($landedCostVarianceSubaccount) && empty($landedCostVarianceSubaccount))) {
            unset($this->LandedCostVarianceSubaccount);
        } else {
            $this->LandedCostVarianceSubaccount = $landedCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get Locations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Locations|null
     */
    public function getLocations()
    {
        return isset($this->Locations) ? $this->Locations : null;
    }
    /**
     * Set Locations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Locations $locations
     * @return \StructType\Warehouse
     */
    public function setLocations(\StructType\Locations $locations = null)
    {
        if (is_null($locations) || (is_array($locations) && empty($locations))) {
            unset($this->Locations);
        } else {
            $this->Locations = $locations;
        }
        return $this;
    }
    /**
     * Get MiscChargeAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getMiscChargeAccount()
    {
        return isset($this->MiscChargeAccount) ? $this->MiscChargeAccount : null;
    }
    /**
     * Set MiscChargeAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $miscChargeAccount
     * @return \StructType\Warehouse
     */
    public function setMiscChargeAccount(\StructType\StringValue $miscChargeAccount = null)
    {
        if (is_null($miscChargeAccount) || (is_array($miscChargeAccount) && empty($miscChargeAccount))) {
            unset($this->MiscChargeAccount);
        } else {
            $this->MiscChargeAccount = $miscChargeAccount;
        }
        return $this;
    }
    /**
     * Get MiscChargeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getMiscChargeSubaccount()
    {
        return isset($this->MiscChargeSubaccount) ? $this->MiscChargeSubaccount : null;
    }
    /**
     * Set MiscChargeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $miscChargeSubaccount
     * @return \StructType\Warehouse
     */
    public function setMiscChargeSubaccount(\StructType\StringValue $miscChargeSubaccount = null)
    {
        if (is_null($miscChargeSubaccount) || (is_array($miscChargeSubaccount) && empty($miscChargeSubaccount))) {
            unset($this->MiscChargeSubaccount);
        } else {
            $this->MiscChargeSubaccount = $miscChargeSubaccount;
        }
        return $this;
    }
    /**
     * Get OverrideInventoryAccountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getOverrideInventoryAccountSubaccount()
    {
        return isset($this->OverrideInventoryAccountSubaccount) ? $this->OverrideInventoryAccountSubaccount : null;
    }
    /**
     * Set OverrideInventoryAccountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @return \StructType\Warehouse
     */
    public function setOverrideInventoryAccountSubaccount(\StructType\BooleanValue $overrideInventoryAccountSubaccount = null)
    {
        if (is_null($overrideInventoryAccountSubaccount) || (is_array($overrideInventoryAccountSubaccount) && empty($overrideInventoryAccountSubaccount))) {
            unset($this->OverrideInventoryAccountSubaccount);
        } else {
            $this->OverrideInventoryAccountSubaccount = $overrideInventoryAccountSubaccount;
        }
        return $this;
    }
    /**
     * Get POAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOAccrualAccount()
    {
        return isset($this->POAccrualAccount) ? $this->POAccrualAccount : null;
    }
    /**
     * Set POAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOAccrualAccount
     * @return \StructType\Warehouse
     */
    public function setPOAccrualAccount(\StructType\StringValue $pOAccrualAccount = null)
    {
        if (is_null($pOAccrualAccount) || (is_array($pOAccrualAccount) && empty($pOAccrualAccount))) {
            unset($this->POAccrualAccount);
        } else {
            $this->POAccrualAccount = $pOAccrualAccount;
        }
        return $this;
    }
    /**
     * Get POAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOAccrualSubaccount()
    {
        return isset($this->POAccrualSubaccount) ? $this->POAccrualSubaccount : null;
    }
    /**
     * Set POAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOAccrualSubaccount
     * @return \StructType\Warehouse
     */
    public function setPOAccrualSubaccount(\StructType\StringValue $pOAccrualSubaccount = null)
    {
        if (is_null($pOAccrualSubaccount) || (is_array($pOAccrualSubaccount) && empty($pOAccrualSubaccount))) {
            unset($this->POAccrualSubaccount);
        } else {
            $this->POAccrualSubaccount = $pOAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPurchasePriceVarianceAccount()
    {
        return isset($this->PurchasePriceVarianceAccount) ? $this->PurchasePriceVarianceAccount : null;
    }
    /**
     * Set PurchasePriceVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $purchasePriceVarianceAccount
     * @return \StructType\Warehouse
     */
    public function setPurchasePriceVarianceAccount(\StructType\StringValue $purchasePriceVarianceAccount = null)
    {
        if (is_null($purchasePriceVarianceAccount) || (is_array($purchasePriceVarianceAccount) && empty($purchasePriceVarianceAccount))) {
            unset($this->PurchasePriceVarianceAccount);
        } else {
            $this->PurchasePriceVarianceAccount = $purchasePriceVarianceAccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPurchasePriceVarianceSubaccount()
    {
        return isset($this->PurchasePriceVarianceSubaccount) ? $this->PurchasePriceVarianceSubaccount : null;
    }
    /**
     * Set PurchasePriceVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $purchasePriceVarianceSubaccount
     * @return \StructType\Warehouse
     */
    public function setPurchasePriceVarianceSubaccount(\StructType\StringValue $purchasePriceVarianceSubaccount = null)
    {
        if (is_null($purchasePriceVarianceSubaccount) || (is_array($purchasePriceVarianceSubaccount) && empty($purchasePriceVarianceSubaccount))) {
            unset($this->PurchasePriceVarianceSubaccount);
        } else {
            $this->PurchasePriceVarianceSubaccount = $purchasePriceVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get ReasonCodeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReasonCodeSubaccount()
    {
        return isset($this->ReasonCodeSubaccount) ? $this->ReasonCodeSubaccount : null;
    }
    /**
     * Set ReasonCodeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reasonCodeSubaccount
     * @return \StructType\Warehouse
     */
    public function setReasonCodeSubaccount(\StructType\StringValue $reasonCodeSubaccount = null)
    {
        if (is_null($reasonCodeSubaccount) || (is_array($reasonCodeSubaccount) && empty($reasonCodeSubaccount))) {
            unset($this->ReasonCodeSubaccount);
        } else {
            $this->ReasonCodeSubaccount = $reasonCodeSubaccount;
        }
        return $this;
    }
    /**
     * Get ReceivingLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReceivingLocationID()
    {
        return isset($this->ReceivingLocationID) ? $this->ReceivingLocationID : null;
    }
    /**
     * Set ReceivingLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $receivingLocationID
     * @return \StructType\Warehouse
     */
    public function setReceivingLocationID(\StructType\StringValue $receivingLocationID = null)
    {
        if (is_null($receivingLocationID) || (is_array($receivingLocationID) && empty($receivingLocationID))) {
            unset($this->ReceivingLocationID);
        } else {
            $this->ReceivingLocationID = $receivingLocationID;
        }
        return $this;
    }
    /**
     * Get RMALocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRMALocationID()
    {
        return isset($this->RMALocationID) ? $this->RMALocationID : null;
    }
    /**
     * Set RMALocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $rMALocationID
     * @return \StructType\Warehouse
     */
    public function setRMALocationID(\StructType\StringValue $rMALocationID = null)
    {
        if (is_null($rMALocationID) || (is_array($rMALocationID) && empty($rMALocationID))) {
            unset($this->RMALocationID);
        } else {
            $this->RMALocationID = $rMALocationID;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesAccount
     * @return \StructType\Warehouse
     */
    public function setSalesAccount(\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesSubaccount
     * @return \StructType\Warehouse
     */
    public function setSalesSubaccount(\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get ShippingLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingLocationID()
    {
        return isset($this->ShippingLocationID) ? $this->ShippingLocationID : null;
    }
    /**
     * Set ShippingLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingLocationID
     * @return \StructType\Warehouse
     */
    public function setShippingLocationID(\StructType\StringValue $shippingLocationID = null)
    {
        if (is_null($shippingLocationID) || (is_array($shippingLocationID) && empty($shippingLocationID))) {
            unset($this->ShippingLocationID);
        } else {
            $this->ShippingLocationID = $shippingLocationID;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStandardCostRevaluationAccount()
    {
        return isset($this->StandardCostRevaluationAccount) ? $this->StandardCostRevaluationAccount : null;
    }
    /**
     * Set StandardCostRevaluationAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $standardCostRevaluationAccount
     * @return \StructType\Warehouse
     */
    public function setStandardCostRevaluationAccount(\StructType\StringValue $standardCostRevaluationAccount = null)
    {
        if (is_null($standardCostRevaluationAccount) || (is_array($standardCostRevaluationAccount) && empty($standardCostRevaluationAccount))) {
            unset($this->StandardCostRevaluationAccount);
        } else {
            $this->StandardCostRevaluationAccount = $standardCostRevaluationAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStandardCostRevaluationSubaccount()
    {
        return isset($this->StandardCostRevaluationSubaccount) ? $this->StandardCostRevaluationSubaccount : null;
    }
    /**
     * Set StandardCostRevaluationSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $standardCostRevaluationSubaccount
     * @return \StructType\Warehouse
     */
    public function setStandardCostRevaluationSubaccount(\StructType\StringValue $standardCostRevaluationSubaccount = null)
    {
        if (is_null($standardCostRevaluationSubaccount) || (is_array($standardCostRevaluationSubaccount) && empty($standardCostRevaluationSubaccount))) {
            unset($this->StandardCostRevaluationSubaccount);
        } else {
            $this->StandardCostRevaluationSubaccount = $standardCostRevaluationSubaccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStandardCostVarianceAccount()
    {
        return isset($this->StandardCostVarianceAccount) ? $this->StandardCostVarianceAccount : null;
    }
    /**
     * Set StandardCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $standardCostVarianceAccount
     * @return \StructType\Warehouse
     */
    public function setStandardCostVarianceAccount(\StructType\StringValue $standardCostVarianceAccount = null)
    {
        if (is_null($standardCostVarianceAccount) || (is_array($standardCostVarianceAccount) && empty($standardCostVarianceAccount))) {
            unset($this->StandardCostVarianceAccount);
        } else {
            $this->StandardCostVarianceAccount = $standardCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStandardCostVarianceSubaccount()
    {
        return isset($this->StandardCostVarianceSubaccount) ? $this->StandardCostVarianceSubaccount : null;
    }
    /**
     * Set StandardCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $standardCostVarianceSubaccount
     * @return \StructType\Warehouse
     */
    public function setStandardCostVarianceSubaccount(\StructType\StringValue $standardCostVarianceSubaccount = null)
    {
        if (is_null($standardCostVarianceSubaccount) || (is_array($standardCostVarianceSubaccount) && empty($standardCostVarianceSubaccount))) {
            unset($this->StandardCostVarianceSubaccount);
        } else {
            $this->StandardCostVarianceSubaccount = $standardCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\Warehouse
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
