<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Values StructType
 * @subpackage Structs
 */
class Values extends AbstractStructBase
{
    /**
     * The AttributeDefinitionValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AttributeDefinitionValue[]
     */
    public $AttributeDefinitionValue;
    /**
     * Constructor method for Values
     * @uses Values::setAttributeDefinitionValue()
     * @param \StructType\AttributeDefinitionValue[] $attributeDefinitionValue
     */
    public function __construct(array $attributeDefinitionValue = array())
    {
        $this
            ->setAttributeDefinitionValue($attributeDefinitionValue);
    }
    /**
     * Get AttributeDefinitionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AttributeDefinitionValue[]|null
     */
    public function getAttributeDefinitionValue()
    {
        return isset($this->AttributeDefinitionValue) ? $this->AttributeDefinitionValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributeDefinitionValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributeDefinitionValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeDefinitionValueForArrayConstraintsFromSetAttributeDefinitionValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $valuesAttributeDefinitionValueItem) {
            // validation for constraint: itemType
            if (!$valuesAttributeDefinitionValueItem instanceof \StructType\AttributeDefinitionValue) {
                $invalidValues[] = is_object($valuesAttributeDefinitionValueItem) ? get_class($valuesAttributeDefinitionValueItem) : sprintf('%s(%s)', gettype($valuesAttributeDefinitionValueItem), var_export($valuesAttributeDefinitionValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttributeDefinitionValue property can only contain items of type \StructType\AttributeDefinitionValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttributeDefinitionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeDefinitionValue[] $attributeDefinitionValue
     * @return \StructType\Values
     */
    public function setAttributeDefinitionValue(array $attributeDefinitionValue = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeDefinitionValueArrayErrorMessage = self::validateAttributeDefinitionValueForArrayConstraintsFromSetAttributeDefinitionValue($attributeDefinitionValue))) {
            throw new \InvalidArgumentException($attributeDefinitionValueArrayErrorMessage, __LINE__);
        }
        if (is_null($attributeDefinitionValue) || (is_array($attributeDefinitionValue) && empty($attributeDefinitionValue))) {
            unset($this->AttributeDefinitionValue);
        } else {
            $this->AttributeDefinitionValue = $attributeDefinitionValue;
        }
        return $this;
    }
    /**
     * Add item to AttributeDefinitionValue value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeDefinitionValue $item
     * @return \StructType\Values
     */
    public function addToAttributeDefinitionValue(\StructType\AttributeDefinitionValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributeDefinitionValue) {
            throw new \InvalidArgumentException(sprintf('The AttributeDefinitionValue property can only contain items of type \StructType\AttributeDefinitionValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttributeDefinitionValue[] = $item;
        return $this;
    }
}
