<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrialBalance StructType
 * @subpackage Structs
 */
class TrialBalance extends Entity
{
    /**
     * The BatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BatchNbr;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The ControlTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ControlTotal;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CreditTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CreditTotal;
    /**
     * The DebitTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DebitTotal;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The ImportDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ImportDate;
    /**
     * The ImportNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ImportNbr;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The Ledger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Ledger;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Period;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for TrialBalance
     * @uses TrialBalance::setBatchNbr()
     * @uses TrialBalance::setBranch()
     * @uses TrialBalance::setControlTotal()
     * @uses TrialBalance::setCreatedDateTime()
     * @uses TrialBalance::setCreditTotal()
     * @uses TrialBalance::setDebitTotal()
     * @uses TrialBalance::setDescription()
     * @uses TrialBalance::setDetails()
     * @uses TrialBalance::setHold()
     * @uses TrialBalance::setImportDate()
     * @uses TrialBalance::setImportNbr()
     * @uses TrialBalance::setLastModifiedDateTime()
     * @uses TrialBalance::setLedger()
     * @uses TrialBalance::setPeriod()
     * @uses TrialBalance::setStatus()
     * @param \StructType\StringValue $batchNbr
     * @param \StructType\StringValue $branch
     * @param \StructType\DecimalValue $controlTotal
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\DecimalValue $creditTotal
     * @param \StructType\DecimalValue $debitTotal
     * @param \StructType\StringValue $description
     * @param \StructType\Details $details
     * @param \StructType\BooleanValue $hold
     * @param \StructType\DateTimeValue $importDate
     * @param \StructType\StringValue $importNbr
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $ledger
     * @param \StructType\StringValue $period
     * @param \StructType\StringValue $status
     */
    public function __construct(\StructType\StringValue $batchNbr = null, \StructType\StringValue $branch = null, \StructType\DecimalValue $controlTotal = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\DecimalValue $creditTotal = null, \StructType\DecimalValue $debitTotal = null, \StructType\StringValue $description = null, \StructType\Details $details = null, \StructType\BooleanValue $hold = null, \StructType\DateTimeValue $importDate = null, \StructType\StringValue $importNbr = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $ledger = null, \StructType\StringValue $period = null, \StructType\StringValue $status = null)
    {
        $this
            ->setBatchNbr($batchNbr)
            ->setBranch($branch)
            ->setControlTotal($controlTotal)
            ->setCreatedDateTime($createdDateTime)
            ->setCreditTotal($creditTotal)
            ->setDebitTotal($debitTotal)
            ->setDescription($description)
            ->setDetails($details)
            ->setHold($hold)
            ->setImportDate($importDate)
            ->setImportNbr($importNbr)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLedger($ledger)
            ->setPeriod($period)
            ->setStatus($status);
    }
    /**
     * Get BatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBatchNbr()
    {
        return isset($this->BatchNbr) ? $this->BatchNbr : null;
    }
    /**
     * Set BatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $batchNbr
     * @return \StructType\TrialBalance
     */
    public function setBatchNbr(\StructType\StringValue $batchNbr = null)
    {
        if (is_null($batchNbr) || (is_array($batchNbr) && empty($batchNbr))) {
            unset($this->BatchNbr);
        } else {
            $this->BatchNbr = $batchNbr;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\TrialBalance
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ControlTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getControlTotal()
    {
        return isset($this->ControlTotal) ? $this->ControlTotal : null;
    }
    /**
     * Set ControlTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $controlTotal
     * @return \StructType\TrialBalance
     */
    public function setControlTotal(\StructType\DecimalValue $controlTotal = null)
    {
        if (is_null($controlTotal) || (is_array($controlTotal) && empty($controlTotal))) {
            unset($this->ControlTotal);
        } else {
            $this->ControlTotal = $controlTotal;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\TrialBalance
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CreditTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCreditTotal()
    {
        return isset($this->CreditTotal) ? $this->CreditTotal : null;
    }
    /**
     * Set CreditTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $creditTotal
     * @return \StructType\TrialBalance
     */
    public function setCreditTotal(\StructType\DecimalValue $creditTotal = null)
    {
        if (is_null($creditTotal) || (is_array($creditTotal) && empty($creditTotal))) {
            unset($this->CreditTotal);
        } else {
            $this->CreditTotal = $creditTotal;
        }
        return $this;
    }
    /**
     * Get DebitTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDebitTotal()
    {
        return isset($this->DebitTotal) ? $this->DebitTotal : null;
    }
    /**
     * Set DebitTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $debitTotal
     * @return \StructType\TrialBalance
     */
    public function setDebitTotal(\StructType\DecimalValue $debitTotal = null)
    {
        if (is_null($debitTotal) || (is_array($debitTotal) && empty($debitTotal))) {
            unset($this->DebitTotal);
        } else {
            $this->DebitTotal = $debitTotal;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\TrialBalance
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\TrialBalance
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\TrialBalance
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get ImportDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getImportDate()
    {
        return isset($this->ImportDate) ? $this->ImportDate : null;
    }
    /**
     * Set ImportDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $importDate
     * @return \StructType\TrialBalance
     */
    public function setImportDate(\StructType\DateTimeValue $importDate = null)
    {
        if (is_null($importDate) || (is_array($importDate) && empty($importDate))) {
            unset($this->ImportDate);
        } else {
            $this->ImportDate = $importDate;
        }
        return $this;
    }
    /**
     * Get ImportNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getImportNbr()
    {
        return isset($this->ImportNbr) ? $this->ImportNbr : null;
    }
    /**
     * Set ImportNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $importNbr
     * @return \StructType\TrialBalance
     */
    public function setImportNbr(\StructType\StringValue $importNbr = null)
    {
        if (is_null($importNbr) || (is_array($importNbr) && empty($importNbr))) {
            unset($this->ImportNbr);
        } else {
            $this->ImportNbr = $importNbr;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\TrialBalance
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $ledger
     * @return \StructType\TrialBalance
     */
    public function setLedger(\StructType\StringValue $ledger = null)
    {
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $period
     * @return \StructType\TrialBalance
     */
    public function setPeriod(\StructType\StringValue $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\TrialBalance
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
