<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeActivity StructType
 * @subpackage Structs
 */
class TimeActivity extends Entity
{
    /**
     * The Approver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Approver;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Billable;
    /**
     * The BillableOvertime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillableOvertime;
    /**
     * The BillableTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillableTime;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The EarningType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EarningType;
    /**
     * The Overtime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Overtime;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Released
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Released;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TimeSpent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TimeSpent;
    /**
     * The TrackTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $TrackTime;
    /**
     * Constructor method for TimeActivity
     * @uses TimeActivity::setApprover()
     * @uses TimeActivity::setBillable()
     * @uses TimeActivity::setBillableOvertime()
     * @uses TimeActivity::setBillableTime()
     * @uses TimeActivity::setCostCode()
     * @uses TimeActivity::setEarningType()
     * @uses TimeActivity::setOvertime()
     * @uses TimeActivity::setProject()
     * @uses TimeActivity::setProjectTask()
     * @uses TimeActivity::setReferenceNbr()
     * @uses TimeActivity::setReleased()
     * @uses TimeActivity::setStatus()
     * @uses TimeActivity::setTimeSpent()
     * @uses TimeActivity::setTrackTime()
     * @param \StructType\StringValue $approver
     * @param \StructType\BooleanValue $billable
     * @param \StructType\StringValue $billableOvertime
     * @param \StructType\StringValue $billableTime
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $earningType
     * @param \StructType\StringValue $overtime
     * @param \StructType\StringValue $project
     * @param \StructType\StringValue $projectTask
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\BooleanValue $released
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $timeSpent
     * @param \StructType\BooleanValue $trackTime
     */
    public function __construct(\StructType\StringValue $approver = null, \StructType\BooleanValue $billable = null, \StructType\StringValue $billableOvertime = null, \StructType\StringValue $billableTime = null, \StructType\StringValue $costCode = null, \StructType\StringValue $earningType = null, \StructType\StringValue $overtime = null, \StructType\StringValue $project = null, \StructType\StringValue $projectTask = null, \StructType\StringValue $referenceNbr = null, \StructType\BooleanValue $released = null, \StructType\StringValue $status = null, \StructType\StringValue $timeSpent = null, \StructType\BooleanValue $trackTime = null)
    {
        $this
            ->setApprover($approver)
            ->setBillable($billable)
            ->setBillableOvertime($billableOvertime)
            ->setBillableTime($billableTime)
            ->setCostCode($costCode)
            ->setEarningType($earningType)
            ->setOvertime($overtime)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setReferenceNbr($referenceNbr)
            ->setReleased($released)
            ->setStatus($status)
            ->setTimeSpent($timeSpent)
            ->setTrackTime($trackTime);
    }
    /**
     * Get Approver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getApprover()
    {
        return isset($this->Approver) ? $this->Approver : null;
    }
    /**
     * Set Approver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $approver
     * @return \StructType\TimeActivity
     */
    public function setApprover(\StructType\StringValue $approver = null)
    {
        if (is_null($approver) || (is_array($approver) && empty($approver))) {
            unset($this->Approver);
        } else {
            $this->Approver = $approver;
        }
        return $this;
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billable
     * @return \StructType\TimeActivity
     */
    public function setBillable(\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get BillableOvertime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillableOvertime()
    {
        return isset($this->BillableOvertime) ? $this->BillableOvertime : null;
    }
    /**
     * Set BillableOvertime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billableOvertime
     * @return \StructType\TimeActivity
     */
    public function setBillableOvertime(\StructType\StringValue $billableOvertime = null)
    {
        if (is_null($billableOvertime) || (is_array($billableOvertime) && empty($billableOvertime))) {
            unset($this->BillableOvertime);
        } else {
            $this->BillableOvertime = $billableOvertime;
        }
        return $this;
    }
    /**
     * Get BillableTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillableTime()
    {
        return isset($this->BillableTime) ? $this->BillableTime : null;
    }
    /**
     * Set BillableTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billableTime
     * @return \StructType\TimeActivity
     */
    public function setBillableTime(\StructType\StringValue $billableTime = null)
    {
        if (is_null($billableTime) || (is_array($billableTime) && empty($billableTime))) {
            unset($this->BillableTime);
        } else {
            $this->BillableTime = $billableTime;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\TimeActivity
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get EarningType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEarningType()
    {
        return isset($this->EarningType) ? $this->EarningType : null;
    }
    /**
     * Set EarningType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $earningType
     * @return \StructType\TimeActivity
     */
    public function setEarningType(\StructType\StringValue $earningType = null)
    {
        if (is_null($earningType) || (is_array($earningType) && empty($earningType))) {
            unset($this->EarningType);
        } else {
            $this->EarningType = $earningType;
        }
        return $this;
    }
    /**
     * Get Overtime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOvertime()
    {
        return isset($this->Overtime) ? $this->Overtime : null;
    }
    /**
     * Set Overtime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $overtime
     * @return \StructType\TimeActivity
     */
    public function setOvertime(\StructType\StringValue $overtime = null)
    {
        if (is_null($overtime) || (is_array($overtime) && empty($overtime))) {
            unset($this->Overtime);
        } else {
            $this->Overtime = $overtime;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $project
     * @return \StructType\TimeActivity
     */
    public function setProject(\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTask
     * @return \StructType\TimeActivity
     */
    public function setProjectTask(\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\TimeActivity
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Released value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getReleased()
    {
        return isset($this->Released) ? $this->Released : null;
    }
    /**
     * Set Released value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $released
     * @return \StructType\TimeActivity
     */
    public function setReleased(\StructType\BooleanValue $released = null)
    {
        if (is_null($released) || (is_array($released) && empty($released))) {
            unset($this->Released);
        } else {
            $this->Released = $released;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\TimeActivity
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TimeSpent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTimeSpent()
    {
        return isset($this->TimeSpent) ? $this->TimeSpent : null;
    }
    /**
     * Set TimeSpent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $timeSpent
     * @return \StructType\TimeActivity
     */
    public function setTimeSpent(\StructType\StringValue $timeSpent = null)
    {
        if (is_null($timeSpent) || (is_array($timeSpent) && empty($timeSpent))) {
            unset($this->TimeSpent);
        } else {
            $this->TimeSpent = $timeSpent;
        }
        return $this;
    }
    /**
     * Get TrackTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getTrackTime()
    {
        return isset($this->TrackTime) ? $this->TrackTime : null;
    }
    /**
     * Set TrackTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $trackTime
     * @return \StructType\TimeActivity
     */
    public function setTrackTime(\StructType\BooleanValue $trackTime = null)
    {
        if (is_null($trackTime) || (is_array($trackTime) && empty($trackTime))) {
            unset($this->TrackTime);
        } else {
            $this->TrackTime = $trackTime;
        }
        return $this;
    }
}
