<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxScheduleDetail StructType
 * @subpackage Structs
 */
class TaxScheduleDetail extends Entity
{
    /**
     * The DeductibleTaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DeductibleTaxRate;
    /**
     * The MaxTaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxTaxableAmount;
    /**
     * The MinTaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MinTaxableAmount;
    /**
     * The ReportingGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReportingGroup;
    /**
     * The RevisionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $RevisionID;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * Constructor method for TaxScheduleDetail
     * @uses TaxScheduleDetail::setDeductibleTaxRate()
     * @uses TaxScheduleDetail::setMaxTaxableAmount()
     * @uses TaxScheduleDetail::setMinTaxableAmount()
     * @uses TaxScheduleDetail::setReportingGroup()
     * @uses TaxScheduleDetail::setRevisionID()
     * @uses TaxScheduleDetail::setStartDate()
     * @uses TaxScheduleDetail::setTaxID()
     * @uses TaxScheduleDetail::setTaxRate()
     * @param \StructType\DecimalValue $deductibleTaxRate
     * @param \StructType\DecimalValue $maxTaxableAmount
     * @param \StructType\DecimalValue $minTaxableAmount
     * @param \StructType\StringValue $reportingGroup
     * @param \StructType\IntValue $revisionID
     * @param \StructType\DateTimeValue $startDate
     * @param \StructType\StringValue $taxID
     * @param \StructType\DecimalValue $taxRate
     */
    public function __construct(\StructType\DecimalValue $deductibleTaxRate = null, \StructType\DecimalValue $maxTaxableAmount = null, \StructType\DecimalValue $minTaxableAmount = null, \StructType\StringValue $reportingGroup = null, \StructType\IntValue $revisionID = null, \StructType\DateTimeValue $startDate = null, \StructType\StringValue $taxID = null, \StructType\DecimalValue $taxRate = null)
    {
        $this
            ->setDeductibleTaxRate($deductibleTaxRate)
            ->setMaxTaxableAmount($maxTaxableAmount)
            ->setMinTaxableAmount($minTaxableAmount)
            ->setReportingGroup($reportingGroup)
            ->setRevisionID($revisionID)
            ->setStartDate($startDate)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate);
    }
    /**
     * Get DeductibleTaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDeductibleTaxRate()
    {
        return isset($this->DeductibleTaxRate) ? $this->DeductibleTaxRate : null;
    }
    /**
     * Set DeductibleTaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $deductibleTaxRate
     * @return \StructType\TaxScheduleDetail
     */
    public function setDeductibleTaxRate(\StructType\DecimalValue $deductibleTaxRate = null)
    {
        if (is_null($deductibleTaxRate) || (is_array($deductibleTaxRate) && empty($deductibleTaxRate))) {
            unset($this->DeductibleTaxRate);
        } else {
            $this->DeductibleTaxRate = $deductibleTaxRate;
        }
        return $this;
    }
    /**
     * Get MaxTaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxTaxableAmount()
    {
        return isset($this->MaxTaxableAmount) ? $this->MaxTaxableAmount : null;
    }
    /**
     * Set MaxTaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxTaxableAmount
     * @return \StructType\TaxScheduleDetail
     */
    public function setMaxTaxableAmount(\StructType\DecimalValue $maxTaxableAmount = null)
    {
        if (is_null($maxTaxableAmount) || (is_array($maxTaxableAmount) && empty($maxTaxableAmount))) {
            unset($this->MaxTaxableAmount);
        } else {
            $this->MaxTaxableAmount = $maxTaxableAmount;
        }
        return $this;
    }
    /**
     * Get MinTaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMinTaxableAmount()
    {
        return isset($this->MinTaxableAmount) ? $this->MinTaxableAmount : null;
    }
    /**
     * Set MinTaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $minTaxableAmount
     * @return \StructType\TaxScheduleDetail
     */
    public function setMinTaxableAmount(\StructType\DecimalValue $minTaxableAmount = null)
    {
        if (is_null($minTaxableAmount) || (is_array($minTaxableAmount) && empty($minTaxableAmount))) {
            unset($this->MinTaxableAmount);
        } else {
            $this->MinTaxableAmount = $minTaxableAmount;
        }
        return $this;
    }
    /**
     * Get ReportingGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReportingGroup()
    {
        return isset($this->ReportingGroup) ? $this->ReportingGroup : null;
    }
    /**
     * Set ReportingGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reportingGroup
     * @return \StructType\TaxScheduleDetail
     */
    public function setReportingGroup(\StructType\StringValue $reportingGroup = null)
    {
        if (is_null($reportingGroup) || (is_array($reportingGroup) && empty($reportingGroup))) {
            unset($this->ReportingGroup);
        } else {
            $this->ReportingGroup = $reportingGroup;
        }
        return $this;
    }
    /**
     * Get RevisionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getRevisionID()
    {
        return isset($this->RevisionID) ? $this->RevisionID : null;
    }
    /**
     * Set RevisionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $revisionID
     * @return \StructType\TaxScheduleDetail
     */
    public function setRevisionID(\StructType\IntValue $revisionID = null)
    {
        if (is_null($revisionID) || (is_array($revisionID) && empty($revisionID))) {
            unset($this->RevisionID);
        } else {
            $this->RevisionID = $revisionID;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $startDate
     * @return \StructType\TaxScheduleDetail
     */
    public function setStartDate(\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxID
     * @return \StructType\TaxScheduleDetail
     */
    public function setTaxID(\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxRate
     * @return \StructType\TaxScheduleDetail
     */
    public function setTaxRate(\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
}
